# Objective assessment of wear time during orthodontic aligner therapy using microsensors: A randomized controlled trial

Authors: Hisham Sabbagh, Uwe Baumert, Juliana Liedtke, Sarah Thiem, Velina Venkova, Andrea Wichelhaus

Affiliation: Department of Orthodontics and Dentofacial Orthopedics, LMU University Hospital, LMU Munich

To be published in the American Journal of Orthodontics and Dentofacial Orthopedics (AJO-DO)

DOI: [10.1016/j.ajodo.2025.10.008](https://doi.org/10.1016/j.ajodo.2025.10.008); PMID: [41615342](https://www.ncbi.nlm.nih.gov/pubmed/41615342)

## Data supplement

This data supplement contains the approved study protocol (in German), the data, the R code used to analyze the data (Quarto rmarkdown) and the corresponding results (`html`). It consists of:

1. Readme.md (this file)
2. Current-data-supplement.zip

The `zip` file contains:

* `Theramon_data_long2.sav`: SPSS data file containing raw data for each of the 40 participants. Language of this document is English.
* `Theramon_data-supplement_accepted.qmd`: Quarto/Markdown formatted text file containing the R language instructions; to be opened in RStudio or similar. Language of this document is English.
* `_quarto.yml`: YAML file for the Quarto script
* `style.css`: CSS style file for the Quarto script
* `Theramon_data-supplement_accepted.html`: `html` file containing the output of the `qmd` file. Language of this document is English.
* `Studienprotokoll_TheraMon_v11_FINAL_approved.pdf`: Original study protocol as approved by the LMU's ethics committee (project nr. 21-1190). Language of this document is German.

The following resources were used for computation:
- Apple MacBookPro (M2 Pro, 32GB RAM), MacOS 13.6.9
- R, version 4.4.3 (or 4.5.0) [available from CRAN](https://cloud.r-project.org/index.html)
- RStudio 2024.12.1-563 [available from Posit.co](https://posit.co/download/rstudio-desktop/)
- Several R packages, mentioned in the `qmd` and `html` files
- Cave: as of 2025-10-04, installation of 'ggplot2' (version 4.0.0 or newer) breaks the generation of a mosaic plot contained in the Quarto script, since the R library 'ggmosaic' (version 0.3.3) has not been updated to 'ggplot2' ≥ 4.0.0. The mosaic plot can also be prepared using 'vcd' for example. The replacement code is included in the Quarto script.
