function splittedMasks = splitMask(mask)

    startIdxs = find(diff(mask) > 0) + 1;
    stopIdxs = find(diff(mask) < 0);

    if mask(1) startIdxs = [1, startIdxs]; end
    if mask(end) startIdxs = [stopIdxs, length(mask)]; end

    splittedMasks = zeros(length(startIdxs), length(mask));
    
    
    for imask = 1:length(startIdxs)
        newMask = zeros(1, length(mask));
        newMask(startIdxs(imask):stopIdxs(imask)) = mask(startIdxs(imask):stopIdxs(imask));
        splittedMasks(imask,:) = newMask;
    end
end
