 function loadedData = load_loc_data(dirRoot, dirSubject, session, refChannels, continuous)
% Basic dataloader to load the localizer data:
% Outputs:
%     - loadedData: Fieldtrip struct containing the localizer data
%     
% Inputs:
%     - dirRoot: string with the main directory containing the data
%     - dirSubject: struct of the directory of the specific subject
%     - session: whether get objects (session = 1) or scenes (session = 2)
%     - refChannels: indicate reference of channels (none, all, specific
%     channels)
%     - continuous: load all continuous localizer data or the already split
%     one

    if continuous
        locFile = dir(fullfile(dirRoot,dirSubject(session).name,'loc',strcat(dirSubject(session).name,'*_loc.mat')));
    else
        % In case of loading the segmented version, a split must be done
        % afterwards
        locFile = dir(fullfile(dirRoot,dirSubject(session).name,'loc',strcat(dirSubject(session).name,'*_loc_segm.mat')));
    end
    
    % Load the file
    tmp          = load(fullfile(locFile(1).folder, locFile(1).name));
    data_loc       = tmp.loc;
    
    %% Get EEG data
    cfg                    = [];
    cfg.channel            = {'EEG1010'}; 
    cfg.removemean         = 'no';
    cfg.bpfilter   = 'yes';
    cfg.bpfreq     = [0.1 45];
    cfg.bpinstabilityfix = 'reduce';

    data_loc_eeg           = ft_preprocessing(cfg, data_loc);

    % Rereference if indicated in refChannels
    if ~isempty(refChannels)
        cfg            = [];
        cfg.reref      = 'yes';
        cfg.refmethod  = 'avg';
        cfg.refchannel = refChannels;

        data_loc_eeg            = ft_preprocessing(cfg, data_loc_eeg);
    end
    
    %% Get respiration data
    % Get resp1 and resp2 into a single channel (convert monopolars to bipolars)
    cfg               = [];
    cfg.channel       = {'Resp1' 'Resp2'};
    cfg.reref         = 'yes';
    cfg.refchannel    = {'Resp2'}; 
    data_loc_resp         = ft_preprocessing(cfg,data_loc);
    
    % only keep one channel, and rename the resp channel
    cfg              = [];
    cfg.channel      = 'Resp1';
    data_loc_resp        = ft_selectdata(cfg, data_loc_resp);
    data_loc_resp.label  = {'resp'};
    
    % Very conservative filter to not affect the trace
    cfg                    = [];
    cfg.channel            = {'resp'}; 
    cfg.removemean         = 'no';
    cfg.bpfilter   = 'yes';
    cfg.bpfreq     = [0.1 20];
    cfg.bpinstabilityfix = 'reduce';

    data_loc_resp            = ft_preprocessing(cfg, data_loc_resp);
    
    %% Append both eeg and resp for each retrieval separately
    cfg = [];
    data_loc = ft_appenddata(cfg, data_loc_eeg, data_loc_resp);
    
    %% TODO: Some preprocessing
    
    %%
    loadedData = data_loc;
end
