clear all;
ft_defaults
dirRoot = 'D:\BreathRet\data';
dirSave = "D:\BreathRet\saves";

subjects    = {'P02' 'P05' 'P07' 'P09' 'P11' 'P12' 'P13' 'P14' 'P15' 'P16' 'P19' 'P21' 'P22' 'P25' 'P26' 'P29' 'P30' 'P31'};

window_radii = 5;
timeRange = [-1, 2];
split_norm = 0;
nPerm = 100;
genNull = 0;
%% RUN

% First for inhalation peaks
TFRs_inhp_all = cell(numel(subjects),2);
TFRs_inhp_null_all = cell(numel(subjects), 1);
parfor isubject=1:numel(subjects)
    
    dirSubject = dir(fullfile(dirRoot, strcat(subjects(isubject), "*")));
    TFRs_null = cell(2,1);
    for session = 1:2
        
        % Load continuous data
        data_all = dataloader.load_cont_data(dirRoot, dirSubject, session, [], 0, 0, 'nan');      
        
        % Split into trials that contain an inhalation peak
        [data_all_split, timings] = util.splitTrials_breathFeat(data_all, "inhalePeaks",timeRange, window_radii, 1, split_norm, dirSubject, session);
        
        %% Get TFR for each trial
        % Separate EEG and Resp data
        cfg         = [];
        cfg.channel = {'all', '-resp'};
        data_eeg  = ft_selectdata(cfg,data_all_split);      
                        
        cfg             = [];
        cfg.keeptrials  = 'yes';
        cfg.output      = 'pow';
        cfg.method      = 'mtmconvol';
        cfg.taper       = 'hanning';
        cfg.foi         = 1:1:30; % frequency range
        cfg.t_ftimwin   = 5./cfg.foi;  % 5 cycles per time window
        cfg.toi         = -5:0.05:5; % time range
        tfr_inh        = ft_freqanalysis(cfg, data_eeg);
    
        cfg         = [];
        cfg.channel = {'resp'};
        data_resp  = ft_selectdata(cfg,data_all_split);
        
        %% Save for later (CHANGE INHP OR EXHT BEFORE SAVING!!!)
        TFR_inhp = struct();
        TFR_inhp.TFR = tfr_inh; 
        TFR_inhp.Resp = data_resp;
        TFR_inhp.timings = timings;
        
        TFRs_inhp_all{isubject, session} = TFR_inhp;
        
        %% Get null distribution
        if genNull
            TFRs_null{session} = util.gen_null_TFR(data_all, data_all_split, window_radii, nPerm);
        end    
    end
    
    if genNull
        s1_null = TFRs_null{1};
        s2_null = TFRs_null{2};
        
        null_dist = zeros(nPerm, size(s1_null{1}.powspctrm, 1), size(s1_null{1}.powspctrm, 2), size(s1_null{1}.powspctrm, 3));
        for i=1:nPerm
            null = s1_null{i};
            null.powspctrm = (s1_null{i}.powspctrm + s2_null{i}.powspctrm)/2;
            null_dist(i, :,:,:) = null;
        end
        
        tfr_all_null = null;
        tfr_all_null.powspctrm = squeeze(mean(null_dist));
        TFRs_inhp_null_all{isubject} = tfr_all_null;
    end
end
save(fullfile(dirSave, "TFRs_inhp_all"), "TFRs_inhp_all",'-v7.3');

% Then for exhalation troughs
timeRange = [0, 3];
TFRs_exht_all = cell(numel(subjects),2);

parfor isubject=1:numel(subjects)
    
    dirSubject = dir(fullfile(dirRoot, strcat(subjects(isubject), "*")));
    TFRs_null = cell(2,1);
    null = 0;
    for session = 1:2 
        
        % Load continuous data
        data_all = dataloader.load_cont_data(dirRoot, dirSubject, session, [], 0, 0, 'nan');      
        
        % Split into trials that contain an inhalation peak
        [data_all_split, timings] = util.splitTrials_breathFeat(data_all, "exhaleTroughs",timeRange, window_radii, 1, split_norm, dirSubject, session);
        
        %% Get TFR for each trial
        % Separate EEG and Resp data
        cfg         = []; 
        cfg.channel = {'all', '-resp'};
        data_eeg  = ft_selectdata(cfg,data_all_split);      
                        
        cfg             = [];
        cfg.keeptrials  = 'yes';
        cfg.output      = 'pow';
        cfg.method      = 'mtmconvol';
        cfg.taper       = 'hanning';
        cfg.foi         = 1:1:30; % frequency range
        cfg.t_ftimwin   = 5./cfg.foi;  % 5 cycles per time window
        cfg.toi         = -5:0.05:5 ; % time range
        tfr_exh        = ft_freqanalysis(cfg, data_eeg);
    
        cfg         = [];
        cfg.channel = {'resp'};  
        data_resp  = ft_selectdata(cfg,data_all_split);
        
        %% Save for later (CHANGE INHP OR EXHT BEFORE SAVING!!!)
        TFR_exht = struct();
        TFR_exht.TFR = tfr_exh; 
        TFR_exht.Resp = data_resp;
        TFR_exht.timings = timings;
        
        TFRs_exht_all{isubject, session} = TFR_exht;
        %% Get null distribution
        if genNull
            TFRs_null{session} = util.gen_null_TFR(data_all, data_all_split, window_radii, nPerm);
        end    
    end
    
    if genNull
        s1_null = TFRs_null{1};
        s2_null = TFRs_null{2};
        
        null_dist = zeros(nPerm, size(s1_null{1}.powspctrm, 1), size(s1_null{1}.powspctrm, 2), size(s1_null{1}.powspctrm, 3));
        for i=1:nPerm
            null = s1_null{i};
            null.powspctrm = (s1_null{i}.powspctrm + s2_null{i}.powspctrm)/2;
            null_dist(i, :,:,:) = null;
        end
        
        tfr_all_null = null;
        tfr_all_null.powspctrm = squeeze(mean(null_dist));
        TFRs_inhp_null_all{isubject} = tfr_all_null;
    end
end
save(fullfile(dirSave, "TFRs_exht_all"), "TFRs_exht_all", '-v7.3');