% Bullon Tarraso et al. 2025
% Code for figure 1d (+ inset)

ft_defaults
clear 

dirRoot = 'data';

subjects    = {'P02'  'P05'  'P07'  'P09'  'P11'  'P12' 'P13'  'P14' 'P15' 'P16'  'P19' 'P21' 'P22' 'P25' 'P26' 'P29' 'P30' 'P31'};

%% subject loop

for isubject=1:numel(subjects)
    
    % Load data for each session and retrieval task
    name1             = sprintf('%s%s',subjects{isubject},'_obj');
    tmp_obj1          = load(fullfile(dirRoot,name1,'ret1',sprintf('%s_obj_ret1_segm_resp',subjects{isubject})));
    data_obj_r1       = tmp_obj1.ret1;
    tmp_obj1          = [];

    tmp_obj2          = load(fullfile(dirRoot,name1,'ret2',sprintf('%s_obj_ret2_segm_resp',subjects{isubject})));
    data_obj_r2       = tmp_obj2.ret2;
    tmp_obj2          = [];

    name2             = sprintf('%s%s',subjects{isubject},'_sce');
    tmp_sce1          = load(fullfile(dirRoot,name2,'ret1',sprintf('%s_sce_ret1_segm_resp',subjects{isubject})));
    data_sce_r1       = tmp_sce1.ret1;
    tmp_sce1          = [];

    tmp_sce2          = load(fullfile(dirRoot,name2,'ret2',sprintf('%s_sce_ret2_segm_resp',subjects{isubject})));
    data_sce_r2       = tmp_sce2.ret2;
    tmp_sce2          = [];  


    %% bring data into better format and normalize (z-score)
    % Remove respiration
    cfg                    = [];
    cfg.channel            = 'eeg'; 
    cfg.removemean         = 'no';
    cfg.detrend            = 'yes';
    cfg.demean             = 'yes';
    data_obj_r1            = ft_preprocessing(cfg, data_obj_r1);
    data_obj_r2            = ft_preprocessing(cfg, data_obj_r2);
    data_sce_r1            = ft_preprocessing(cfg, data_sce_r1);
    data_sce_r2            = ft_preprocessing(cfg, data_sce_r2);                               

    % Append object and scene data
    trialinfo_all          = [data_obj_r1.trialinfo; data_obj_r2.trialinfo;data_sce_r1.trialinfo;data_sce_r2.trialinfo];
    cfg                    = [];
    data_all               = ft_appenddata(cfg, data_obj_r1, data_obj_r2, data_sce_r1, data_sce_r2);
    data_all.fsample       = 200;
    data_all.trialinfo     = trialinfo_all; 

    % Rereference to all channels
    cfg            = [];
    cfg.reref      = 'yes';
    cfg.refmethod  = 'avg';
    cfg.refchannel = {'all'};
    data_all       = ft_preprocessing(cfg, data_all);

    % define stimulus categories and fetch corresponding trial indices
    trs_rem        = [];
    trs_nrem       = [];

    for tr = 1 : length(data_all.trial)
        if (data_all.trialinfo{tr,1}.ExemplarAccuracy ==1)&&(data_all.trialinfo{tr,1}.OldNew ==1)...
    trs_rem = cat(1,trs_rem,tr);

        elseif(data_all.trialinfo{tr,1}.ExemplarAccuracy ==0)&&(data_all.trialinfo{tr,1}.OldNew ==1)...
    trs_nrem = cat(1,trs_nrem,tr);

        end                     
    end

    % now time frequency part
    cfg              = [];
    cfg.keeptrials   = 'yes';
    cfg.output       = 'pow';
    cfg.method       = 'mtmconvol';
    cfg.taper        = 'hanning';
    cfg.foi          = 1:1:30;     % frequency range
    cfg.t_ftimwin    = 5./cfg.foi; % 5 cycles per time window
    cfg.toi          = -1:0.05:4;  % time range   
    tfr_all          = ft_freqanalysis(cfg, data_all);
    
    % zscore all trials (normalizing with 250 ms before cue onset)
    startT  = nearest(tfr_all.time,-0.25);
    endT    = nearest(tfr_all.time, 0);
    
    pow  = tfr_all.powspctrm;
    powz = nan(size(pow));

    for ichan = 1:size(pow,2)
        for ifreq = 1:size(pow,3)
            d = squeeze(pow(:,ichan,ifreq,startT:endT));
            m = nanmean(d(:));
            s = nanstd(d(:));

            powz(:,ichan,ifreq,:) = (pow(:,ichan,ifreq,:) - m)./s;
        end
    end

    pow                 = [];
    tfr_all.powspctrm   = powz;                   
    clear powz;    
           
    % segment data according to conditions
    cfg = []; cfg.trials = trs_rem; tfr_rem      = ft_selectdata(cfg,tfr_all);
    cfg = []; cfg.trials = trs_nrem;tfr_nrem     = ft_selectdata(cfg,tfr_all);
 
    tfr_rem.dimord       = 'chan_freq_time';
    tfr_nrem.dimord      = 'chan_freq_time';

    tfr_rem.powspctrm    = squeeze(nanmean(tfr_rem.powspctrm,1));
    tfr_nrem.powspctrm   = squeeze(nanmean(tfr_nrem.powspctrm,1));

    % collect all data in one structure   
    ALL_TFR_rem{isubject}    = tfr_rem;
    ALL_TFR_nrem{isubject}   = tfr_nrem;

           
end


%% Load eeg cap data for channel localization

statsAuxDir = 'auxiliary';

cfg             = [];
cfg.layout      = fullfile(statsAuxDir,'Bham-64CH-Lay.mat');
layout          = ft_prepare_layout(cfg);

cfg             = [];
cfg.method      = 'template';
cfg.template    = fullfile(statsAuxDir,'Bham-64CH-Neighbours.mat');
neighbours      = ft_prepare_neighbours(cfg);  
 
%% Run stats
cfg = [];
cfg.latency          = [-0.15 1.5];    
cfg.avgovertime      = 'no';
cfg.spmversion       = 'spm12';

cfg.frequency        = [3 30];                                    
cfg.method           = 'montecarlo';
cfg.statistic        = 'ft_statfun_depsamplesT';
cfg.correctm         = 'cluster';
cfg.clusteralpha     = 0.05;
cfg.clusterstatistic = 'maxsum';
cfg.minnbchan        = 2;
cfg.tail             = 0;
cfg.clustertail      = 0;
cfg.alpha            = 0.05;
cfg.numrandomization = 1000;
cfg.computecritval   = 'yes';
cfg.correcttail      = 'alpha';

%specifies with which sensors other sensors can form clusters
cfg.neighbours = neighbours

subj = size (subjects,2);  
design = zeros(2,2*subj);
for i = 1:subj
  design(1,i) = i;
end
for i = 1:subj
  design(1,subj+i) = i;
end
design(2,1:subj)        = 1;
design(2,subj+1:2*subj) = 2;

cfg.design   = design;
cfg.uvar     = 1;
cfg.ivar     = 2;
Fieldtripstat = ft_freqstatistics(cfg,ALL_TFR_rem{:}, ALL_TFR_nrem{:});
length(find(Fieldtripstat.mask))

stat = Fieldtripstat;


%% plot stats (Figure 1d)

cfg = [];
cfg.foilim        = [3 30];                                    
cfg.toilim          = [-0.15 1.5];    

ga_rem  = ft_freqgrandaverage(cfg,ALL_TFR_rem{:});
ga_nrem = ft_freqgrandaverage(cfg,ALL_TFR_nrem{:});

diff = ga_rem.powspctrm - ga_nrem.powspctrm ; 
cfg.latency          = [-0.15 3.5];    
cfg.frequency        = [2 30];                                    

diff_m = squeeze(mean(diff));

%stat.stat = stat.stat .* stat.mask;
t_sums = squeeze(sum(stat.stat));

figure;

pcolor(stat.time,[3:1:30], t_sums); 
shading interp;%lighting phong;
axis xy; 
ll = xlabel('Time retrieval (s)', 'Fontsize', 17);
yy = ylabel('Frequency (Hz)', 'Fontsize', 17);
set(gca,'layer','top')
set(gca,'TickDir','in', 'Linewidth',2);

caxis([-100 100]);
set(gcf, 'Color', 'w')
hcb = colorbar;
ylabel(hcb, 't-values','FontSize', 17);

set(gca,'FontSize',14)
ax = gca;
ax.XTick = [-0.49 0 0.5 1 1.49, 2, 2.5, 3, 3.49];
ax.XTickLabel = [{'-0.5'} '0' '0.5' '1' '1.5' '2' '2.5' '3' '3.5'];

ax.YTick = [5 10 15 20 25];

set(gcf, 'Position', [100, 400, 570, 200]);

stats_time = nearest(stat.time,cfg.latency(1)):nearest(stat.time,cfg.latency(2));
stats_freq = nearest(stat.freq,cfg.frequency(1)):nearest(stat.freq,cfg.frequency(2));

sigmap = double(squeeze(any(stat.mask)));

plot_contour(stat.time,stat.freq,sigmap)

xline(0,'--', 'linewidth',2, 'color','k');
set(findall(gcf,'-property','FontSize'),'FontSize',20)

%% topo (inset of figure 1d)
stat        = Fieldtripstat;
stat.stat = stat.stat.*stat.mask; % mask t-values
t_sums_topo = squeeze(nansum(nansum(stat.stat,2),3)); % sum of sig. t-values

% fake grand average
cfg         = [];
cfg.toilim  = [1 1];
cfg.foilim  = [5 5];
ga_topo     = ft_freqgrandaverage(cfg,ALL_TFR_rem{:});

ga_topo.powspctrm = t_sums_topo;

figure;
topo             = [];
topo.zlim        = [-300 300];
topo.layout      = layout;
topo.parameter   = 'powspctrm';
topo.gridscale   = 360;
topo.marker      = 'off';
topo.comment     = 'no';
topo.style       = 'both';
topo.contournum  = 2;
ft_topoplotTFR(topo, ga_topo);
set(gcf, 'Color', 'w');
hcb = colorbar;
ylabel(hcb, 'summed t-values');
set(findall(gcf,'-property','FontSize'),'FontSize',22)


