function [data_all, timing_trials] = splitTrials_breathFeat(data_all, feat, timeRange, window_radii, force_ret_trials, norm, dirSubject, session)

    if ~force_ret_trials
        %% Do not force the peaks/troughs to happen within a trial (continous)
        data_rets = cell(1,2);
        timing_trials = [];
        for iret=1:2
            % Get ret data
            data_ret = data_all;
            data_ret.trial = data_all.trial(iret);
            data_ret.time = data_all.time(iret);
            data_ret.sampleinfo = data_all.sampleinfo(iret,:);

            % start respiration detection       
            idx_resp   = find(strcmp(data_ret.label, 'resp'));
            resp_sleep = data_ret.trial{1, 1}(idx_resp,:);
            srate      = data_ret.fsample;

%             [b, a] = butter(2, [0.1, 0.35]/(srate/2), 'bandpass');
%             resp_sleep = filtfilt(b, a, resp_sleep);
            
            resp_sleep(isoutlier(resp_sleep)) = 0;
            
            dataType   = 'humanAirflow';
            bmObj      = breathmetrics(resp_sleep, srate, dataType);

            % verbose prints out steps as they go. Set to 0 to silence.
            verbose=0; 

            % The sliding window is the most accurate method but takes slightly longer
            baselineCorrectionMethod = 'sliding'; 

            zScore=1;

            bmObj.correctRespirationToBaseline(baselineCorrectionMethod, zScore, verbose)
            bmObj.estimateAllFeatures;
            breathFeat = bmObj.(feat); % inhalePeaks // exhaleTroughs
    
            % Split trials according to the inhalation peaks
            trl = [];
            time_pretrigger = window_radii;
            time_posttrigger = window_radii;

            pretrig = round(time_pretrigger*srate);
            posttrig = round(time_posttrigger*srate);

            for j  = 1:numel(breathFeat)
                offset   = -pretrig;
                trlbegin = breathFeat(j) - pretrig;
                trlend   = breathFeat(j) + posttrig;
                newtrl   = [trlbegin trlend offset];
                trl = [trl; newtrl];
            end

            % Remove incomplete trials
            trl(trl(:,1)<data_ret.sampleinfo(1),:) = [];
            trl(trl(:,2)>data_ret.sampleinfo(2),:) = [];
            
            cfg                 = [];
            cfg.trl             = trl;
            cfg.allowoverlap    = 0;
            data_split         = ft_redefinetrial(cfg, data_ret);

            % zscore data
            if norm
                all_trials = zscore([data_split.trial{:}], [], 2);
                all_trials = reshape(all_trials', [], size(trl,1), size(all_trials,1));
                for itrial = 1:size(all_trials,2)
                    data_split.trial{1,itrial} = squeeze(all_trials(:,itrial,:))';
                end
            end
            
            data_rets{iret} = data_split;
        end

        data_rets{2}.sampleinfo = data_rets{2}.sampleinfo + data_all.sampleinfo(1,2); % Correct sampleinfo

        cfg = [];
        data_all = ft_appenddata(cfg, data_rets{:});
    else
        %% Force the peaks/troughs to be contained in a trial
        data_rets = cell(1,2);
        timing_trials = [];
        for iret=1:2
            % Get ret data separately (we will append at the end)
            data_ret = data_all;
            data_ret.trial = data_all.trial(iret);
            data_ret.time = data_all.time(iret);
            data_ret.sampleinfo = data_all.sampleinfo(iret,:);
            
            % start respiration detection       
            idx_resp   = find(strcmp(data_ret.label, 'resp'));
            resp_sleep = data_ret.trial{1, 1}(idx_resp,:);
            srate      = data_ret.fsample;

%             [b, a] = butter(2, [0.1, 15]/(srate/2), 'bandpass');
%             resp_sleep = filtfilt(b, a, resp_sleep);

            resp_sleep(isoutlier(resp_sleep)) = 0;
            
            dataType   = 'humanAirflow';
            bmObj      = breathmetrics(resp_sleep, srate, dataType);

            % verbose prints out steps as they go. Set to 0 to silence.
            verbose=0; 

            % The sliding window is the most accurate method but takes slightly longer
            baselineCorrectionMethod = 'sliding'; 

            zScore=1;

            bmObj.correctRespirationToBaseline(baselineCorrectionMethod, zScore, verbose)
            bmObj.estimateAllFeatures; % Find inhale peaks and exhale troughs
            breathFeat = bmObj.(feat); % inhalePeaks // exhaleTroughs
            
            % Get triggers and metadata paths
            trigFile = dir(fullfile(dirSubject(session).folder, dirSubject(session).name, strcat('ret', string(iret)),'*.vmrk'));
            trigFile = fullfile(trigFile.folder, trigFile.name);

            trialData = dir(fullfile(dirSubject(session).folder, dirSubject(session).name, strcat('ret', string(iret)), strcat('retrieval', string(iret),'_*.txt')));
            trialData = fullfile(trialData.folder, trialData.name);
            
            original_fs = 1000;
            trial_trig = 'S 41';

            % Read trials data
            trig = ft_read_event(trigFile);

            % down-sample triggers    
            for itrig = 1:numel(trig)
                trig(itrig).sample = round(trig(itrig).sample / original_fs * data_ret.fsample);
            end
             
            % Get only trial onset triggers
            trigMask = arrayfun(@(x) strcmp(x.value, trial_trig), trig);
            trig = trig(trigMask);
            trigSamples = [trig.sample];
            
            % Get inhalation peaks / exhalation troughs within trials
            % I check whether each breathFeat is contained within timeRange from a cue
            % This gives me the inhp/exht that happen within a trial
            inhTrialsMask = arrayfun(@(x) any(((x - trigSamples) < timeRange(2)*srate).*((x - trigSamples) > timeRange(1)*srate)), breathFeat);
            inhTrials = breathFeat(inhTrialsMask);                                  
            
            % Now do the opposite for trial information
            % I check the cues that are close enough (timeRange) to an exht/inhp
            % This gives me the trials that contain at least 1 inhp/exht
            inhTrialsMask = arrayfun(@(x) any(((breathFeat - x) < timeRange(2)*srate).*((breathFeat - x) > timeRange(1)*srate)), trigSamples);
            trialOnsets = trigSamples(inhTrialsMask);
            
            % Load trial information from the experiment files
            [SubjectNumber Part Phase Run TrialNumber FixationDur Verb Image Art_Nat OldNew Answer1 RT1 Answer1Accuracy ExemplarResponse ExemplarAccuracy WriteOutTime TriggerTime TriggerTime2 Clock] = ...
                textread(trialData,...
                '%d %d %s %d %d %f %s %s %d %d %s %f %d %s %d %f %f %f %s','headerlines',1,'delimiter','\t');

            for ientry=1:numel(SubjectNumber)      
                trialinfo{ientry,1}.SubjectNumber   = SubjectNumber(ientry);
                trialinfo{ientry,1}.Run             = Run(ientry);
                trialinfo{ientry,1}.TrialNumber     = TrialNumber(ientry);
                trialinfo{ientry,1}.Verb            = Verb(ientry);
                trialinfo{ientry,1}.Image           = Image(ientry);
                trialinfo{ientry,1}.Art_Nat         = Art_Nat(ientry);
                trialinfo{ientry,1}.OldNew          = OldNew(ientry);
                trialinfo{ientry,1}.Answer1         = Answer1(ientry);
                trialinfo{ientry,1}.Answer1Accuracy = Answer1Accuracy(ientry);
                trialinfo{ientry,1}.RT1             = RT1(ientry);
                trialinfo{ientry,1}.ExemplarResponse= ExemplarResponse(ientry);
                trialinfo{ientry,1}.ExemplarAccuracy= ExemplarAccuracy(ientry);
                trialinfo{ientry,1}.FixationDur     = FixationDur(ientry);
                trialinfo{ientry,1}.TriggerTime     = TriggerTime2(ientry);
            end

            % Remove first peaks/troughs from trials with several
            % peaks/troughs (we only keep the last) by combining the
            % information from lines ~140
            if(length(inhTrials)>length(trialOnsets))
                trialOnsetMask = arrayfun(@(x) sum(((inhTrials - x) < timeRange(2)*srate).*((inhTrials - x) > timeRange(1)*srate)), trialOnsets);
                while(length(inhTrials)>length(trialOnsets))
                    % Remove first inhp/exht from trial with more than one
                    removeIdx = find(trialOnsetMask > 1, 1, 'first');                
                    inhTrials(removeIdx:removeIdx+trialOnsetMask(removeIdx)-2) = [];
                    trialOnsetMask(removeIdx) = 1;
                end
            end
            
            % Split trials according to the inhalation peaks / exhalation
            % troughs
            trl = [];
            time_pretrigger = window_radii;
            time_posttrigger = window_radii;
            
            pretrig = round(time_pretrigger*srate);
            posttrig = round(time_posttrigger*srate);

            % inhTrials = inhTrials + srate; % To go for flows
            
            for j  = 1:numel(inhTrials)
                offset   = -pretrig;
                trlbegin = inhTrials(j) - pretrig;
                trlend   = inhTrials(j) + posttrig;
                newtrl   = [trlbegin trlend offset];
                trl = [trl; newtrl];
            end

            % Remove incomplete trials
            tooEarly = trl(:,1)<data_ret.sampleinfo(1);
            tooLate  = trl(:,2)>data_ret.sampleinfo(2);
            trl(or(tooEarly, tooLate),:) = [];
            
            inhTrialsIdx = find(inhTrialsMask);
            inhTrialsIdx(or(tooEarly, tooLate)) = [];
            
            inhTrials(or(tooEarly, tooLate)) = [];
            trialOnsets(or(tooEarly, tooLate)) = [];
            
            % Do new split
            cfg                 = [];
            cfg.trl             = trl;
            cfg.allowoverlap    = 0;
            data_split         = ft_redefinetrial(cfg, data_ret);
            
            data_split.trialinfo = trialinfo(inhTrialsIdx);
            
            % zscore data
            if norm
                trial_data = [data_split.trial{:}]';
                preprocess_param   = mv_get_preprocess_param('zscore');
                [~, trial_data ]      = mv_preprocess_zscore(preprocess_param, trial_data);        
                all_trials     = trial_data';

%                 all_trials = zscore([data_split.trial{:}], [], 2);
                all_trials = reshape(all_trials', [], length(inhTrialsIdx), size(all_trials,1));
                for itrial = 1:size(all_trials,2)
                    data_split.trial{1,itrial} = squeeze(all_trials(:,itrial,:))';
                end
            end
    
            data_rets{iret} = data_split;
            timing_trials = [timing_trials, (inhTrials - trialOnsets)/srate];
        end
        
        assert(length(inhTrials) == length(inhTrialsIdx)) % Check that the split was done correctly
        data_rets{2}.sampleinfo = data_rets{2}.sampleinfo + data_all.sampleinfo(1,2); % Correct sampleinfo
        
        cfg = [];
        data_all = ft_appenddata(cfg, data_rets{:}); % Append retrieval sessions
    end
end