function split = splitTrials(data_all, trig, window_radii, norm, dirSubject, session, removeArtifacts)

%% Split data into trials

    data_rets = cell(1,2);
    for iret=1:2
        % Get ret data
        data_ret = data_all;
        data_ret.trial = data_all.trial(iret);
        data_ret.time = data_all.time(iret);
        data_ret.sampleinfo = data_all.sampleinfo(iret,:);

        % Get triggers and metadata paths
        trigFile = dir(fullfile(dirSubject(session).folder, dirSubject(session).name, strcat('ret', string(iret)),'*.vmrk'));
        trigFile = fullfile(trigFile.folder, trigFile.name);

        trialData = dir(fullfile(dirSubject(session).folder, dirSubject(session).name, strcat('ret', string(iret)), strcat('retrieval', string(iret),'_*.txt')));
        trialData = fullfile(trialData.folder, trialData.name);

        original_fs = 1000;
        trial_trig = trig;

        % Read trials data
        triggers = ft_read_event(trigFile);

        % down-sample triggers    
        for itrig = 1:numel(triggers)
            triggers(itrig).sample = round(triggers(itrig).sample / original_fs * data_ret.fsample);
        end

        % Get only trial onset triggers
        trigMask = arrayfun(@(x) strcmp(x.value, trial_trig), triggers);
        triggers = triggers(trigMask);
        trigSamples = [triggers.sample];
                                 
        [SubjectNumber Part Phase Run TrialNumber FixationDur Verb Image Art_Nat OldNew Answer1 RT1 Answer1Accuracy ExemplarResponse ExemplarAccuracy WriteOutTime TriggerTime TriggerTime2 Clock] = ...
            textread(trialData,...
            '%d %d %s %d %d %f %s %s %d %d %s %f %d %s %d %f %f %f %s','headerlines',1,'delimiter','\t');

        for ientry=1:numel(SubjectNumber)      
            trialinfo{ientry,1}.SubjectNumber   = SubjectNumber(ientry);
            trialinfo{ientry,1}.Run             = Run(ientry);
            trialinfo{ientry,1}.TrialNumber     = TrialNumber(ientry);
            trialinfo{ientry,1}.Verb            = Verb(ientry);
            trialinfo{ientry,1}.Image           = Image(ientry);
            trialinfo{ientry,1}.Art_Nat         = Art_Nat(ientry);
            trialinfo{ientry,1}.OldNew          = OldNew(ientry);
            trialinfo{ientry,1}.Answer1         = Answer1(ientry);
            trialinfo{ientry,1}.Answer1Accuracy = Answer1Accuracy(ientry);
            trialinfo{ientry,1}.RT1             = RT1(ientry);
            trialinfo{ientry,1}.ExemplarResponse= ExemplarResponse(ientry);
            trialinfo{ientry,1}.ExemplarAccuracy= ExemplarAccuracy(ientry);
            trialinfo{ientry,1}.FixationDur     = FixationDur(ientry);
            trialinfo{ientry,1}.TriggerTime     = TriggerTime2(ientry);
        end

        % Split trials according to the inhalation peaks
        trl = [];
        time_pretrigger = window_radii;
        time_posttrigger = window_radii;

        pretrig = round(time_pretrigger*data_ret.fsample);
        posttrig = round(time_posttrigger*data_ret.fsample);

        % inhTrials = inhTrials + srate; % To go for flows

        for j  = 1:numel(trigSamples)
            offset   = -pretrig;
            trlbegin = trigSamples(j) - pretrig;
            trlend   = trigSamples(j) + posttrig;
            newtrl   = [trlbegin trlend offset];
            trl = [trl; newtrl];
        end

        % Remove incomplete trials
        tooEarly = trl(:,1)<data_ret.sampleinfo(1);
        tooLate  = trl(:,2)>data_ret.sampleinfo(2);
        trl(or(tooEarly, tooLate),:) = [];
        
        % Do new split
        cfg                 = [];
        cfg.trl             = trl;
        cfg.allowoverlap    = 0;
        data_split         = ft_redefinetrial(cfg, data_ret);

        data_split.trialinfo = trialinfo(not(or(tooEarly, tooLate)));      
               
        % zscore data
        if norm
            trial_data = [data_split.trial{:}]';
            preprocess_param   = mv_get_preprocess_param('zscore');
            [~, trial_data ]      = mv_preprocess_zscore(preprocess_param, trial_data);        
            all_trials     = trial_data';

%                 all_trials = zscore([data_split.trial{:}], [], 2);
            all_trials = reshape(all_trials', [], size(trl,1), size(all_trials,1));
            for itrial = 1:size(all_trials,2)
                data_split.trial{1,itrial} = squeeze(all_trials(:,itrial,:))';
            end
        end

        data_rets{iret} = data_split;
    end
    
    cfg = [];
    split = ft_appendtimelock(cfg, data_rets{:});
    
    % Remove artifacts (if marked file exists)
    if removeArtifacts && isfile(fullfile(dirSubject(session).folder, dirSubject(session).name, "artifact_trials.txt"))
        artifs = readmatrix(fullfile(dirSubject(session).folder, dirSubject(session).name,"artifact_trials.txt"));
        cfg = [];
        cfg.artfctdef.visual.artifact = artifs;
        cfg.artfctdef.reject = 'complete';
        split = ft_rejectartifact(cfg, split);

%             copyfile(fullfile(dirSubject(session).folder, dirSubject(session).name,"artifact_trials.txt"), ...
%                 fullfile(destinationFolder, strcat(dirSubject(session).name, "_artifs.txt")));
    end  
end