function resp_modulation(r, true_dvals, null_dvals)
%% Code to reproduce Fig. 2 from Kluger et al., NatComms 2023
% underlying data structures can be obtained from the same OSF directory
% CircStat toolbox is required (https://github.com/circstat/circstat-matlab)

%% Panel A - Group-level slope modulation

shiftmeans = squeeze(mean(null_dvals))';
mins = prctile(shiftmeans,5);
maxs = prctile(shiftmeans,95);

mins(end+1) = mins(1);
maxs(end+1) = maxs(1);

truemeans = squeeze(mean(true_dvals));
for k = 1:60
    [perm_ecdf(:, 1), perm_ecdf(:, 2)] = ecdf(shiftmeans(:,k));
    upper = find(perm_ecdf(:, 2) < truemeans(k), 1, 'last');
    lower = find(perm_ecdf(:, 2) > truemeans(k), 1, 'first');
    x1 = 1-perm_ecdf(upper);
    x2 = 0+perm_ecdf(lower);
    try
        p(k) = min(x1,x2);
    catch
        p(k) = 0;
    end
end

figure;
% Get significance
signMask = (p <= 0.05);

% polar plot for slope
cmap = [magma(30); flipud(magma(30))];
% r = linspace(-pi,pi,60);
ax = polaraxes;
% polarscatter(r,shiftmeans',5,'MarkerFaceColor','k','MarkerFaceAlpha',0.25,'MarkerEdgeColor',[1 1 1]); % It doesnt work
hold on
polarscatter(r,truemeans,[],cmap,'filled');
hold on
r(end+1) = r(1);
polarplot(r,mins,'k--');
polarplot(r,maxs,'k--');
rlim([min(truemeans)-0.1, max(truemeans)+0.1])
set(ax,'RTickLabel','');

% Plot significance
signMask(end+1) = signMask(1);
r_sign = r;
r_sign(~signMask) = nan;
sign_line = ones(size(r_sign))*(max(truemeans)+0.05);
polarplot(r_sign, sign_line, 'k', 'LineWidth', 3);
end