function MI_significant(values, nullValues, sigMask, vFreqs)

sumMask = sum(sigMask(:,vFreqs));
sig = squeeze(mean(values(:,any(sigMask, 2),vFreqs)));
null = squeeze(mean(mean(nullValues(:, any(sigMask, 2),vFreqs,:),4)));

sigMean = mean(sig);
nullMean = mean(null);

sigSEM = std(sig)/sqrt(size(sig,1));
nullSEM = std(null)/sqrt(size(null,1));

fig = figure();
[hl,hp] = boundedline(vFreqs,sigMean, sigSEM, 'black', 'alpha','transparency', 0.15);% 'cmap',[0.85 0 0], 'alpha','transparency', 0.5 // 'cmap',[0 0 0], 'alpha','transparency', 0.25
set(hl, 'linewidth', 3);

hold on;
plot(vFreqs, nullMean, 'k--');

maskPlot = nan(1, length(sumMask));
maskPlot(sumMask > 0) = 1;
plot(vFreqs, maskPlot*min(nullMean), '-r', 'LineWidth', 3);
xlim([vFreqs(1)-1, vFreqs(end)])
xlabel("Frequency (Hz)");
ylabel("Modulation index");
set(gca, 'FontSize', 12);
end