function kfolds = my_kfold_split(labels, nk)

    class1 = find(labels == 1);
    class2 = find(labels == 2);
    
    class1 = Shuffle(class1);
    class2 = Shuffle(class2);
        
    kfold1Length = floor(length(class1)/nk); 
    kfold2Length = floor(length(class1)/nk); 

    for k=1:nk-1
        newkfold1 = class1((k-1)*kfold1Length + 1:k*kfold1Length);
        newkfold2 = class2((k-1)*kfold2Length + 1:k*kfold2Length);
        
        kfolds(k,:) = [newkfold1; newkfold2];
    end
    
    
    
    kfolds(nk,:) = [class1(end-kfold1Length+1:end); ...
        class2(end-kfold2Length+1:end)];
    
end
    
    