function data_phase = load_loc_segm_phase(dirRoot, dirSubject, session, hilbert)

    if hilbert
        tmp          = load(fullfile(dirRoot,dirSubject(session).name,'loc',strcat(dirSubject(session).name,'_loc_resp_segm_Hilbert.mat')));
        loc_data       = tmp.loc_resp;
    else
        tmp          = load(fullfile(dirRoot,dirSubject(session).name,'loc',strcat(dirSubject(session).name,'_loc_resp_segm_DoubleInterp.mat')));
        loc_data       = tmp.loc_resp;
    end

    % bring data into better format
    cfg                    = [];
    cfg.channel            = {'resp'}; 
    cfg.removemean         = 'no';

    loc_data            = ft_preprocessing(cfg, loc_data);

    cfg                    = [];
    cfg.keeptrials         = 'yes';
    cfg.removemean         = 'no';

    loc_data            = ft_timelockanalysis(cfg, loc_data);

    % add conditions
    for i = 1:size (loc_data.trialinfo,1)
            loc_data.trialinfo{i, 1}.Stimtype = session;
    end

    % Remove artifacts (if marked file exists)
    if isfile(fullfile(dirSubject(session).folder, dirSubject(session).name, "artifact_trials_loc.txt"))
        artifs = readmatrix(fullfile(dirSubject(session).folder, dirSubject(session).name,"artifact_trials_loc.txt"));
        cfg = [];
        cfg.artfctdef.visual.artifact = artifs;
        loc_data = ft_rejectartifact(cfg, loc_data);
    end
    
    data_phase = loc_data;
end