%% read in respiration, detect freq peak, filter continoúous data, segment

clear all
ft_defaults;
addpath '/Users/thomasschreiner/Documents/Matlab_Toolboxes/hline_vline/'

addpath(genpath('/Volumes/Seagate Backup Plus Drive2/slobscene_analysis/EEG/analysis_results/'));
mother          = 'D:/BreathRet';

headerdir       = fullfile(mother,'data/');
datadir         = fullfile(mother,'data/');
savedir         = fullfile(mother,'data/');

ret1data        = '_ret1.mat';
ret1dir         = 'ret1';

% GENERAL PREPROCESSING/EPOCHING OPTIONS
new_fs           = 200; % target sampling rate

time_pretrigger  = 1; % in seconds
time_posttrigger = 5; % in seconds
target_trigger   = 'S 41';

%% SUBJECT-SPECIFIC SETTINGS
sub_ = {'P01_obj' 'P02_obj'  'P05_obj'  'P07_obj'  'P09_obj'  'P11_obj'  'P12_obj' 'P13_obj'  'P14_obj' 'P15_obj' 'P16_obj' 'P18_obj'  'P19_obj' 'P21_obj' 'P22_obj' 'P25_obj' 'P26_obj' 'P29_obj' 'P30_obj' 'P31_obj' 'P01_sce'  'P02_sce'  'P05_sce'  'P07_sce'  'P09_sce'  'P11_sce'  'P12_sce' 'P13_sce'  'P14_sce' 'P15_sce' 'P16_sce' 'P18_sce'  'P19_sce' 'P21_sce' 'P22_sce' 'P25_sce' 'P26_sce' 'P29_sce' 'P30_sce' 'P31_sce'};

logfile   = 'retrieval1*.txt';

for iSub  = 1:numel(sub_)    
    
    subID = sub_{iSub};
    
    % read header
    cd(fullfile(headerdir, [sub_{iSub}],ret1dir));

    trigfile = dir('*.vmrk');
    trig = ft_read_event(trigfile.name);

    % read pre-processed data
    cd(fullfile(datadir, [sub_{iSub}], ret1dir));
    load ([sub_{iSub} ret1data]);
    
    % read in the logfile
    cd(fullfile(savedir, [sub_{iSub}], ret1dir));

    logfile = dir('retrieval1*.txt');
    logfile = logfile.name;
    
    trialinfo = [];

    [SubjectNumber Part Phase Run TrialNumber FixationDur Verb Image Art_Nat OldNew Answer1 RT1 Answer1Accuracy ExemplarResponse ExemplarAccuracy WriteOutTime TriggerTime TriggerTime2 Clock] = ...
    textread(logfile,...
    '%d %d %s %d %d %f %s %s %d %d %s %f %d %s %d %f %f %f %s','headerlines',1,'delimiter','\t');

    for ientry=1:numel(SubjectNumber)      
        trialinfo{ientry,1}.SubjectNumber   = SubjectNumber(ientry);
        trialinfo{ientry,1}.Run             = Run(ientry);
        trialinfo{ientry,1}.TrialNumber     = TrialNumber(ientry);
        trialinfo{ientry,1}.Verb            = Verb(ientry);
        trialinfo{ientry,1}.Image           = Image(ientry);
        trialinfo{ientry,1}.Art_Nat         = Art_Nat(ientry);
        trialinfo{ientry,1}.OldNew          = OldNew(ientry);
        trialinfo{ientry,1}.Answer1         = Answer1(ientry);
        trialinfo{ientry,1}.Answer1Accuracy = Answer1Accuracy(ientry);
        trialinfo{ientry,1}.RT1             = RT1(ientry);
        trialinfo{ientry,1}.ExemplarResponse= ExemplarResponse(ientry);
        trialinfo{ientry,1}.ExemplarAccuracy= ExemplarAccuracy(ientry);
        trialinfo{ientry,1}.FixationDur     = FixationDur(ientry);
        trialinfo{ientry,1}.TriggerTime     = TriggerTime2(ientry);
    end
  
    cfg               = [];
    cfg.channel       = {'Resp1' 'Resp2'};
    cfg.reref         = 'yes';
    cfg.refchannel    = {'Resp2'}; 
    ret1_resp         = ft_preprocessing(cfg,ret1);
    
    % only keep one channel, and rename the resp channel
    cfg              = [];
    cfg.channel      = 'Resp1';
    ret1_resp        = ft_selectdata(cfg, ret1_resp);
    ret1_resp.label  = {'resp'};

    cfg = [];                                                                       % empty configuration structure to be filled
    cfg.continuous = 'yes';                                                         % non-segmented data
    cfg.demean     = 'yes';
    cfg.detrend    = 'yes';
    cfg.bpfilter   = 'yes';
    cfg.bpfreq     = [0.1 20];
    cfg.bpinstabilityfix = 'reduce';
    raw = ft_preprocessing(cfg, ret1_resp);   

    % normalise and save full respiration time course
    respchan = match_str(raw.label, 'resp');                                     % find index of the respiration channel
    r = raw.trial{1}(respchan,:)';                                                  % extract time series from this channel
    r(abs(zscore(r)) > 2.5) = NaN;                                                  % normalise time series and set outliers to NaN
    r(isnan(r)) = interp1(find(~isnan(r)), r(~isnan(r)), find(isnan(r)), 'linear'); % linear interpolation of outlier segments
    x = (r - nanmean(r))/nanstd(r);


    nbin = 60; % 60                      % number of data points per cycle (= 'temporal' resolution)                                                                                                                
    phw = 2*pi/10;                  % width of the moving window
    pb = linspace(-pi,pi,nbin);     % boundaries of phase bins


        x_sl = x;%(x(scoringFilter{1, 1}));
    
    
        pause(0.001);                               % quick pause
        frame_h = get(handle(gcf),'JavaFrame');     % index the figure we just made
        set(frame_h,'Maximized',1);                 % set figure to fullscreen
        sgtitle(['ID ' (sub_(iSub))]);        % title of the figure is subject ID
            
    
            % double interpolation
            [~, peaks] = findpeaks(x_sl, 'MinPeakProminence',1);   % minimal prominence = 1 works well for our data, but see for yourself
            troughs = [];                                       % empty structure for troughs
            for k = 2:numel(peaks)                              % loop over all peaks, starting with peak #2
                tmp = x_sl(peaks(k-1):peaks(k));                   % get respiration course between peaks #1 and #2
                inds = peaks(k-1):peaks(k);                     % get corresponding indices of the respiration course
                troughinds = inds(tmp == min(tmp));             % minimum of respiration between peaks is the trough
                troughs(k-1) = troughinds(1); 
                %troughs(k) = troughinds;                   % for the rare but annoying case there is a peak longer than 1 sample

                % for the rare but annoying case there is a peak longer than 1 sample
            end
            
            % sanity check with a figure
            % plot(x_sl,'k'); hold on;                               % plot normalised respiration in black
            % scatter(peaks,x_sl(peaks),10,'r');                     % overlay peaks in red...
            % scatter(troughs,x_sl(troughs),10,'b');                 % ... and troughs in blue
            % waitforbuttonpress;
            % close all

            phasevec = NaN(size(x_sl));                                % make phase vector out of NaNs; length equals that of respiration vector
            phasevec(peaks) = 0;                                    % set phase at inspiration peaks to zero...
            phasevec(troughs) = pi;                                 % ... and troughs to pi
            for k = 1:numel(peaks)-1                                % loop over all peaks
                tmp = phasevec(peaks(k)+1:troughs(k));              % these will be the phase angles between peak #1 and trough #1
                tmp2 = phasevec(troughs(k)+1:peaks(k+1));           % these will be the phase angles between trough #1 and peak #2
                sub = linspace(0+pi/numel(tmp),pi,numel(tmp));      % first: linear interpolation peak-to-trough
                sub2 = linspace(-pi+pi/numel(tmp),0,numel(tmp2));   % then the same for trough-to-peak
                phasevec(peaks(k)+1:troughs(k)) = sub;              % substitute NaNs in phase vector with interpolated phase angles (peak-to-trough)
                phasevec(troughs(k)+1:peaks(k+1)) = sub2;           % same for trough-to-peak
            end


    ret1_resp.trial{1, 1} = phasevec';

    % down-sample triggers    
    for itrig = 1:numel(trig);
        trig(itrig).sample = round(trig(itrig).sample / ret1_resp.hdr.Fs * ret1_resp.fsample);
    end

    % define trials
        
        trl = [];
        
        pretrig = round(time_pretrigger*ret1_resp.fsample);
        posttrig = round(time_posttrigger*ret1_resp.fsample);
        
        for j  = 1:numel(trig)
            if strcmp (trig(1,j).value,target_trigger) == 1; 
            
            offset   = -pretrig;
            trlbegin = trig(1,j).sample - pretrig;
            trlend   = trig(1,j).sample + posttrig;
            newtrl   = [trlbegin trlend offset];
            trl = [trl; newtrl];
            
        end    
        end

    % segemt into trials 
    cfg                 = [];
    cfg.trl             = trl;
    ret1_resp           = ft_redefinetrial(cfg, ret1_resp);
    ret1_resp.trialinfo = trialinfo;

    cd(savedir);
    cd(subID);
    cd(ret1dir);
    save([subID '_ret1_resp_segm_DoubleInterp'], 'ret1_resp') 


end

%% read in respiration, detect freq peak, filter continoúous data, segment

clear all
ft_defaults;
addpath '/Users/thomasschreiner/Documents/Matlab_Toolboxes/hline_vline/'

addpath(genpath('/Volumes/Seagate Backup Plus Drive2/slobscene_analysis/EEG/analysis_results/'));
mother          = 'D:/BreathRet';

headerdir       = fullfile(mother,'data/');
datadir         = fullfile(mother,'data/');
savedir         = fullfile(mother,'data/');

ret2data        = '_ret2.mat';
ret2dir         = 'ret2';

% GENERAL PREPROCESSING/EPOCHING OPTIONS
new_fs           = 200; % target sampling rate

time_pretrigger  = 1; % in seconds
time_posttrigger = 5; % in seconds
target_trigger   = 'S 41';

%% SUBJECT-SPECIFIC SETTINGS
sub_ = {'P01_obj' 'P02_obj'  'P05_obj'  'P07_obj'  'P09_obj'  'P11_obj'  'P12_obj' 'P13_obj'  'P14_obj' 'P15_obj' 'P16_obj' 'P18_obj'  'P19_obj' 'P21_obj' 'P22_obj' 'P25_obj' 'P26_obj' 'P29_obj' 'P30_obj' 'P31_obj' 'P01_sce'  'P02_sce'  'P05_sce'  'P07_sce'  'P09_sce'  'P11_sce'  'P12_sce' 'P13_sce'  'P14_sce' 'P15_sce' 'P16_sce' 'P18_sce'  'P19_sce' 'P21_sce' 'P22_sce' 'P25_sce' 'P26_sce' 'P29_sce' 'P30_sce' 'P31_sce'};

logfile   = 'retrieval2*.txt';

for iSub  = 1:numel(sub_)    
    
    subID = sub_{iSub};
    
    % read header
    cd(fullfile(headerdir, [sub_{iSub}],ret2dir));

    trigfile = dir('*.vmrk');
    trig = ft_read_event(trigfile.name);

    % read pre-processed data
    cd(fullfile(datadir, [sub_{iSub}],ret2dir));
    load ([sub_{iSub} ret2data]);
    
    % read in the logfile
    cd(fullfile(savedir, [sub_{iSub}],ret2dir));

    logfile = dir('retrieval2*.txt');
    logfile = logfile.name;
    
    trialinfo = [];

    [SubjectNumber Part Phase Run TrialNumber FixationDur Verb Image Art_Nat OldNew Answer1 RT1 Answer1Accuracy ExemplarResponse ExemplarAccuracy WriteOutTime TriggerTime TriggerTime2 Clock] = ...
    textread(logfile,...
    '%d %d %s %d %d %f %s %s %d %d %s %f %d %s %d %f %f %f %s','headerlines',1,'delimiter','\t');

    for ientry=1:numel(SubjectNumber)      
        trialinfo{ientry,1}.SubjectNumber   = SubjectNumber(ientry);
        trialinfo{ientry,1}.Run             = Run(ientry);
        trialinfo{ientry,1}.TrialNumber     = TrialNumber(ientry);
        trialinfo{ientry,1}.Verb            = Verb(ientry);
        trialinfo{ientry,1}.Image           = Image(ientry);
        trialinfo{ientry,1}.Art_Nat         = Art_Nat(ientry);
        trialinfo{ientry,1}.OldNew          = OldNew(ientry);
        trialinfo{ientry,1}.Answer1         = Answer1(ientry);
        trialinfo{ientry,1}.Answer1Accuracy = Answer1Accuracy(ientry);
        trialinfo{ientry,1}.RT1             = RT1(ientry);
        trialinfo{ientry,1}.ExemplarResponse= ExemplarResponse(ientry);
        trialinfo{ientry,1}.ExemplarAccuracy= ExemplarAccuracy(ientry);
        trialinfo{ientry,1}.FixationDur     = FixationDur(ientry);
        trialinfo{ientry,1}.TriggerTime     = TriggerTime2(ientry);
    end
  
    cfg               = [];
    cfg.channel       = {'Resp1' 'Resp2'};
    cfg.reref         = 'yes';
    cfg.refchannel    = {'Resp2'}; 
    ret2_resp         = ft_preprocessing(cfg,ret2);
    
    % only keep one channel, and rename the resp channel
    cfg              = [];
    cfg.channel      = 'Resp1';
    ret2_resp        = ft_selectdata(cfg, ret2_resp);
    ret2_resp.label  = {'resp'};

    cfg = [];                                                                       % empty configuration structure to be filled
    cfg.continuous = 'yes';                                                         % non-segmented data
    cfg.demean     = 'yes';
    cfg.detrend    = 'yes';
    cfg.bpfilter   = 'yes';
    cfg.bpfreq     = [0.1 20];
    cfg.bpinstabilityfix = 'reduce';
    raw = ft_preprocessing(cfg, ret2_resp);   

    % normalise and save full respiration time course
    respchan = match_str(raw.label, 'resp');                                     % find index of the respiration channel
    r = raw.trial{1}(respchan,:)';                                                  % extract time series from this channel
    r(abs(zscore(r)) > 2.5) = NaN;                                                  % normalise time series and set outliers to NaN
    r(isnan(r)) = interp1(find(~isnan(r)), r(~isnan(r)), find(isnan(r)), 'linear'); % linear interpolation of outlier segments
    x = (r - nanmean(r))/nanstd(r);


    nbin = 60; % 60                      % number of data points per cycle (= 'temporal' resolution)                                                                                                                
    phw = 2*pi/10;                  % width of the moving window
    pb = linspace(-pi,pi,nbin);     % boundaries of phase bins

        x_sl = x;%(x(scoringFilter{1, 1}));
    
        pause(0.001);                               % quick pause
        frame_h = get(handle(gcf),'JavaFrame');     % index the figure we just made
        set(frame_h,'Maximized',1);                 % set figure to fullscreen
        sgtitle(['ID ' (sub_(iSub))]);        % title of the figure is subject ID
            
    
            % double interpolation
            [~, peaks] = findpeaks(x_sl, 'MinPeakProminence',1);   % minimal prominence = 1 works well for our data, but see for yourself
            troughs = [];                                       % empty structure for troughs
            for k = 2:numel(peaks)                              % loop over all peaks, starting with peak #2
                tmp = x_sl(peaks(k-1):peaks(k));                   % get respiration course between peaks #1 and #2
                inds = peaks(k-1):peaks(k);                     % get corresponding indices of the respiration course
                troughinds = inds(tmp == min(tmp));             % minimum of respiration between peaks is the trough
                troughs(k-1) = troughinds(1); 
                %troughs(k) = troughinds;                   % for the rare but annoying case there is a peak longer than 1 sample

                % for the rare but annoying case there is a peak longer than 1 sample
            end
            
            % sanity check with a figure
            % plot(x_sl,'k'); hold on;                               % plot normalised respiration in black
            % scatter(peaks,x_sl(peaks),10,'r');                     % overlay peaks in red...
            % scatter(troughs,x_sl(troughs),10,'b');                 % ... and troughs in blue
            
            phasevec = NaN(size(x_sl));                                % make phase vector out of NaNs; length equals that of respiration vector
            phasevec(peaks) = 0;                                    % set phase at inspiration peaks to zero...
            phasevec(troughs) = pi;                                 % ... and troughs to pi
            for k = 1:numel(peaks)-1                                % loop over all peaks
                tmp = phasevec(peaks(k)+1:troughs(k));              % these will be the phase angles between peak #1 and trough #1
                tmp2 = phasevec(troughs(k)+1:peaks(k+1));           % these will be the phase angles between trough #1 and peak #2
                sub = linspace(0+pi/numel(tmp),pi,numel(tmp));      % first: linear interpolation peak-to-trough
                sub2 = linspace(-pi+pi/numel(tmp),0,numel(tmp2));   % then the same for trough-to-peak
                phasevec(peaks(k)+1:troughs(k)) = sub;              % substitute NaNs in phase vector with interpolated phase angles (peak-to-trough)
                phasevec(troughs(k)+1:peaks(k+1)) = sub2;           % same for trough-to-peak
            end


    ret2_resp.trial{1, 1} = phasevec';
    

    % down-sample triggers    
    for itrig = 1:numel(trig);
        trig(itrig).sample = round(trig(itrig).sample / ret2_resp.hdr.Fs * ret2_resp.fsample);
    end

    % define trials
        
        trl = [];
        
        pretrig = round(time_pretrigger*ret2_resp.fsample);
        posttrig = round(time_posttrigger*ret2_resp.fsample);
        
        for j  = 1:numel(trig)
            if strcmp (trig(1,j).value,target_trigger) == 1; 
            
            offset   = -pretrig;
            trlbegin = trig(1,j).sample - pretrig;
            trlend   = trig(1,j).sample + posttrig;
            newtrl   = [trlbegin trlend offset];
            trl = [trl; newtrl];
            
        end    
        end

    % segemt into trials 
    cfg            = [];
    cfg.trl        = trl;
    ret2_resp      = ft_redefinetrial(cfg, ret2_resp);
    ret2_resp.trialinfo = trialinfo;

    cd(savedir);
    cd(subID);
    cd(ret2dir);
    save([subID '_ret2_resp_segm_DoubleInterp'], 'ret2_resp') 

end


