clear all;
ft_defaults
dirRoot = 'D:\BreathRet\data';
dirSave = "D:\BreathRet\saves";

subjects    = {'P02' 'P05' 'P07' 'P09' 'P11' 'P12' 'P13' 'P14' 'P15' 'P16' 'P19' 'P21' 'P22' 'P25' 'P26' 'P29' 'P30' 'P31'};

%% RUN

for isubject=1:numel(subjects)
    
    dirSubject = dir(fullfile(dirRoot, strcat(subjects(isubject), "*")));

    for session = 1:length(dirSubject) 
        
        % Load segmented data
        data_all = dataloader.load_segm_data(dirRoot, dirSubject, session, 0, 0);      
        
        %% Get TFR for each trial
        % Separate EEG and Resp data
        cfg         = [];
        cfg.channel = {'all', '-resp'};
        data_eeg  = ft_selectdata(cfg,data_all);      
                        
        cfg             = [];
        cfg.keeptrials  = 'yes';
        cfg.output      = 'pow';
        cfg.method      = 'mtmconvol';
        cfg.taper       = 'hanning';
        cfg.foi         = 1:2:30; % frequency range
        cfg.t_ftimwin   = 5./cfg.foi;  % 5 cycles per time window
        cfg.toi         = -1:0.05:3; % time range
        TFR_all        = ft_freqanalysis(cfg, data_eeg);  
        
        %% Separate rem and nrem
        % Split rem vs nrem
        trlinfo  = cell2mat(TFR_all.trialinfo);   
        accuracy = [trlinfo.ExemplarAccuracy];
        oldnew   = [trlinfo.OldNew];
        TFR_all = rmfield(TFR_all, "trialinfo"); % Remove trialinfo for average

        cfg = [];
        cfg.trials = find(accuracy == 1 & oldnew == 1);
        TFR_rem = ft_selectdata(cfg, TFR_all);

        cfg = [];
        cfg.trials = find(accuracy == 0 & oldnew == 1);
        TFR_nrem = ft_selectdata(cfg, TFR_all);
        
        %% Save for later
        save(fullfile(dirSubject(session).folder, dirSubject(session).name, "TFR_all"), "TFR_all");
        save(fullfile(dirSubject(session).folder, dirSubject(session).name, "TFR_rem"), "TFR_rem");
        save(fullfile(dirSubject(session).folder, dirSubject(session).name, "TFR_nrem"), "TFR_nrem");
    end
end