% Bullon Tarraso et al. 2025
% Code for figure 2c

dirRoot = 'data';
dirSave = "saves";
load("auxiliary\peak_resp.mat");

subjects    = {'P02'  'P05'  'P07'  'P09'  'P11'  'P12' 'P13'  'P14' 'P15' 'P16' 'P19' 'P21' 'P22' 'P25' 'P26' 'P29' 'P30' 'P31'};

%% subject loop

for isubject=1:numel(subjects)
    
        subID     = subjects{isubject};
        dirSubject = dir(fullfile(dirRoot, strcat(subjects(isubject), "*")));
        
        % Load continuous data
        data_all_obj = dataloader.load_cont_data(dirRoot, dirSubject, 1, 'all', 0, 0, 'nan'); 
        data_all_sce = dataloader.load_cont_data(dirRoot, dirSubject, 2, 'all', 0, 0, 'nan');

        % Separate respiration
        cfg         = [];
        cfg.channel = {'resp'};
        data_phase_o     = ft_selectdata(cfg, data_all_obj);
        data_phase_s     = ft_selectdata(cfg, data_all_sce);

        dat_phase_o   = horzcat(data_phase_o.trial{:});
        dat_phase_s   = horzcat(data_phase_s.trial{:});

        % then EEG  
        cfg         = [];
        cfg.channel = {'all' '-resp'};
        data_eeg_o   = ft_selectdata(cfg, data_all_obj);
        data_eeg_s   = ft_selectdata(cfg, data_all_sce);    

        dat_eeg_o   = horzcat(data_eeg_o.trial{:});
        dat_eeg_s   = horzcat(data_eeg_s.trial{:});
        
         
        dat_phase = [dat_phase_o, dat_phase_s];
        dat_eeg = [dat_eeg_o, dat_eeg_s];
        
        for ichan = 1:size(dat_eeg_o,1)
            
            fs = 200;
            cfg                  = [];
            cfg.Fs               = fs;
            cfg.phase_freqs      = peak_resp(isubject);     % freq for phase
            cfg.amp_freqs        = 3:1:30; % freq for amplitude
            cfg.method           = 'tort';
            cfg.filt_order       = 1;
            cfg.amp_bandw_method = 'number';
            cfg.amp_bandw        = 2;
            [MI_raw(ichan,:)]  = math.orig_PAC_resp(cfg,dat_phase,dat_eeg(ichan,:));

            % shuffle for random distribution           
            data_eegi = dat_eeg(ichan,:);
            
            parfor i = 1:200

                dat_phase_shuff     = Shuffle(dat_phase); 
                dat_eeg_shuff       = Shuffle(data_eegi); 
                
                cfg                     = [];
                cfg.Fs                  = fs;
                cfg.phase_freqs         = peak_resp(isubject);
                cfg.amp_freqs           = 3:1:30;
                cfg.method              = 'tort';
                cfg.filt_order          = 1;
                cfg.amp_bandw_method    = 'number';
                cfg.amp_bandw           = 2;
 
                [MI_shuff(i,ichan,:)]   = math.orig_PAC_resp(cfg,dat_phase_shuff,dat_eeg_shuff); 

            end
        end
                   
        % cd(dirRoot)
        if ~continuous
            save(fullfile(dirSave, "MI", [subID '_MI_shuffle_2']), 'MI_shuff');
            save(fullfile(dirSave, "MI", [subID '_MI_raw_2']), 'MI_raw');
        else
            save(fullfile(dirSave, "MI", [subID '_MI_shuffle_cont']), 'MI_shuff');
            save(fullfile(dirSave, "MI", [subID '_MI_raw_cont']), 'MI_raw');
        end
end



%% stats via z-score

for isubject =  1:18
    
        name1         = sprintf('%s%s',subjects{isubject},'_obj');
        load(fullfile(dirSave, "MI", sprintf('%s_MI_raw_2',subjects{isubject})));
        tmp_mi(isubject,:,:) = MI_raw;
        
        load(fullfile(dirSave, "MI", sprintf('%s_MI_shuffle_2',subjects{isubject})));
        tmp_mi_shuffle(isubject,:,:,:) = MI_shuff;

end
    
for ii = 1:18
    
    mi_all_fin = squeeze(tmp_mi(ii,:,:));
    mi_null_fin = squeeze(tmp_mi_shuffle(ii,:,:,:));

    % zscore the empirical data by the reference distribution
    for i = 1:size(mi_all_fin,1)
        MI_z(i,:) = (mi_all_fin(i,:)-squeeze(mean(mi_null_fin(:,i,:)))')./squeeze(std(mi_null_fin(:,i,:)))';
    end
    
    MI_z_all(ii,:,:) = MI_z;
    
end

mean_MI_z = squeeze(mean(MI_z_all));


%% plot zscore

load('data\P02_obj\ret1\P02_obj_ret1.mat')
load('auxiliary/Bham-64CH-Neighbours.mat')
load('auxiliary\Bham-64CH-Lay.mat')

% get rid of resp (does not work via lables, not sure why) and then EOG
cfg         = [];
cfg.channel = ret1.label(1:54);
data        = ft_selectdata(cfg, ret1); 

cfg         = [];
cfg.channel = {'all', '-E1', '-E2', '-resp'};
data        = ft_selectdata(cfg, data);

% get nicer data structure 
cfg = [];
cfg.latency = [data.time{1, 1}(1) data.time{1, 1}(25)];
temp        = ft_timelockanalysis(cfg, data);

temp.time   = 3:30;
temp.avg    = mean_MI_z;


%% topo

        
stat_illustration      = temp;
stat_illustration.freq = 1;
stat_illustration.time = 1;
stat_illustration.stat = sum(mean_MI_z(mean_MI_z(:,6:18)>1.96),2);
% stat_illustration.stat = sum(mean_MI_z(:,11:end)>1.96,2); % Take only alpha
% stat_illustration.stat = chansIs;

figure;
topo             = [];
topo.zlim       = [-5 5];
topo.layout      = lay;
topo.parameter   = 'stat';
topo.gridscale   = 360;
topo.marker      = 'off';
topo.comment     = 'no';
topo.style       = 'both';
topo.contournum  = 2;  
ft_topoplotTFR(topo, stat_illustration);
set(gcf, 'Color', 'w');
h = colorbar;
ylabel(h, "summed z-values");
set(findall(gcf,'-property','FontSize'),'FontSize',20)
fig = gcf;


%% plot mean of sign electrodes
grey       = [0.6 0.6 0.6];

chansIs = (mean_MI_z(:,6:18) >1.96); % corresponds to  p = 0.05
chansIs = sum(chansIs,2);

sign_chns = (mean_MI_z(logical(chansIs),:));

m = (mean(sign_chns));
s    = nanstd(sign_chns)./sqrt(size(sign_chns,1));

f = figure;

time = [3:30];

[hl,~]    = boundedline(time  ,m,s,'cmap', grey);
set(hl, 'linewidth', 0.0001, 'LineStyle', 'none') 

hold on
plot([3:30],m,'color', [0 0 0],'linewidth',2);        
        
sigline        = nan(1,numel(time));
sigline(m>1.96) = 1.55;
 
hold on
plot(time,sigline,'color',grey,'linewidth',6);

axis tight
ylim([1 3.5])

f.Position = [440   278   355   420];

xlabel("Frequency (Hz)");
ylabel("Modulation index");
set(findall(gcf,'-property','FontSize'),'FontSize',12)