function interp_data_all = time2PhaseAxis(data_all, data_resp, locking, interpMethod)

    phase_fs = 120;
    inhPhases = -pi:1/phase_fs:-1/phase_fs;
    exhPhases = 0:1/phase_fs:pi;
    newPhases = [inhPhases, exhPhases];
    
    centralPeakLoc = floor(size(data_all.time{1,1},2)/2);
    old_fs = data_resp.fsample;
    
    % Get peaks for the interpolation limits
    if strcmp(locking, "exhaleTroughs")
        [~, peakLocs] = cellfun(@(x) findpeaks(x, 'NPeaks', 2, 'SortStr', 'descend', 'MinPeakDistance', old_fs*3), data_resp.trial, 'UniformOutput', false);
    else
        [~, peakLocs] = cellfun(@(x) findpeaks(-x, 'NPeaks', 2, 'SortStr', 'descend', 'MinPeakDistance', old_fs*3), data_resp.trial, 'UniformOutput', false);
    end
    
    % Remove trials without a complete respiration cycle
    completeTrials = cellfun( @(x) length(x), peakLocs) == 2;
    peakLocs = peakLocs(completeTrials);
    
    peakLocs = cellfun(@(x) sort(x, 'ascend'), peakLocs, 'UniformOutput', false);
    
    cfg              = [];
    cfg.trials = completeTrials;
    data_all   = ft_selectdata(cfg,data_all);
    
    % Get original phases
    originalPhases = cellfun(@(x) [linspace(-pi, 0, abs(x(1)-centralPeakLoc)),linspace(pi/abs(x(2)-centralPeakLoc), pi, abs(x(2)-centralPeakLoc))],...
        peakLocs, 'UniformOutput', false);
%     originalAngles = cellfun(@(x) angle(hilbert(x)), data_resp.trial, 'UniformOutput', false);
%     originalAngles = originalAngles(completeTrials);
%     for i=1:size(originalAngles,2)
%         if strcmp(locking, "exhaleTroughs")
%             originalPhases{i} = circ_dist(originalAngles{i}(peakLocs{i}(1):peakLocs{i}(2)),-pi);
%         else
%             originalPhases{i} = originalAngles{i}(peakLocs{i}(1):peakLocs{i}(2));
%         end
%     end
    
    % Perform the interpolation per trial
    interp_data_all = data_all;
    for itrial=1:size(data_all.trial,2)
        interpEEG = interp1(originalPhases{itrial}, data_all.trial{itrial}(:,peakLocs{itrial}(1):peakLocs{itrial}(2)-1)', newPhases);
        interp_data_all.trial{itrial} = interpEEG';
        interp_data_all.time{itrial} = newPhases;
    end
    %interp_data_all = rmfield(interp_data_all, "sampleinfo");
    interp_data_all.fsample = phase_fs;
end