function tfr_null = gen_null_TFR(data_all, data_all_split, window_radii, nPerm)

fs = 200;
tfr_null = cell(nPerm, 1);
for i = 1:nPerm
    % Get random datapoints split
    r1_size = find(diff(data_all_split.sampleinfo(:,1)) < 0);
    split={};
    split{1} = data_all_split.sampleinfo(1:r1_size,:);
    split{2} = data_all_split.sampleinfo(r1_size+1:end,:);

    data_rets = cell(2,1);
    for iret=1:2
        split_centers = round(split{iret}(:,1)+(split{iret}(:,2)-split{iret}(:,1)).*rand(size(split{iret},1),1));
        data_ret = data_all;
        data_ret.trial = data_all.trial(iret);
        data_ret.time = data_all.time(iret);
        data_ret.sampleinfo = data_all.sampleinfo(iret,:);

        trials = zeros(size(split_centers,1),3);
        trials(:,1) = split_centers - fs*window_radii;
        trials(:,2) = split_centers + fs*window_radii;
        trials(:,3) = - fs*window_radii;
        trials(trials(:,1) < 1 | trials(:,2) > data_ret.sampleinfo(2),:) = [];

        cfg = [];
        cfg.trl = trials;
        data_ret  = ft_redefinetrial(cfg, data_ret);
        data_rets{iret} = data_ret;
    end
    cfg = [];
    data_rnd = ft_appenddata(cfg, data_rets{:});

    % Separate EEG and Resp data
    cfg         = [];
    cfg.channel = {'all', '-resp'};
    data_eeg_rnd  = ft_selectdata(cfg,data_rnd);      

    cfg             = [];
    cfg.keeptrials  = 'yes';
    cfg.output      = 'pow';
    cfg.method      = 'mtmconvol';
    cfg.taper       = 'hanning';
    cfg.foi         = 1:2:30; % frequency range
    cfg.t_ftimwin   = 5./cfg.foi;  % 5 cycles per time window
    cfg.toi         = -5:0.05:5; % time range
    tfr_inh_rnd        = ft_freqanalysis(cfg, data_eeg_rnd);

    startT  = nearest(tfr_inh_rnd.time,-4);
    endT    = nearest(tfr_inh_rnd.time, 4);

    pow  = tfr_inh_rnd.powspctrm;
    powz = nan(size(pow));

    for ichan = 1:size(pow,2)
        for ifreq = 1:size(pow,3)
            d = squeeze(pow(:,ichan,ifreq,startT:endT));
            m = nanmean(d(:));
            s = nanstd(d(:));

            % powz(:,ichan,ifreq,:) = (pow(:,ichan,ifreq,:) - m)./s;
            powz(:,ichan,ifreq,:) = (pow(:,ichan,ifreq,:) - m);
        end
    end

    tfr_inh_rnd.powspctrm = powz;

    cfg                = [];
    cfg.avgoverrpt     = 'yes';
    tfr_null{i}           = ft_selectdata(cfg, tfr_inh_rnd);
end