function [ITC_all_null, ITC_rem_null, ITC_nrem_null] = gen_null_ITC(TFR_all, nPerms)

ITC_all = zeros(nPerms, length(TFR_all.label), length(TFR_all.freq), length(TFR_all.time));
ITC_rem = zeros(nPerms, length(TFR_all.label), length(TFR_all.freq), length(TFR_all.time));
ITC_nrem = zeros(nPerms, length(TFR_all.label), length(TFR_all.freq), length(TFR_all.time));

 

parfor i=1:nPerms
    
    %% Shuffle labels  
    trlinfo  = cell2mat(TFR_all.trialinfo);
    trlinfo = Shuffle(trlinfo);
    
    %% Separate rem and nrem
    accuracy = [trlinfo.ExemplarAccuracy];
    oldnew   = [trlinfo.OldNew];

    cfg = [];
    cfg.trials = find(accuracy == 1 & oldnew == 1);
    TFR_rem = ft_selectdata(cfg, TFR_all);

    cfg = [];
    cfg.trials = find(accuracy == 0 & oldnew == 1);
    TFR_nrem = ft_selectdata(cfg, TFR_all);

    %% Compute ITCs
    
    ITC_all(i, :,:,:) = squeeze(abs(sum(TFR_all.fourierspctrm./abs(TFR_all.fourierspctrm)))/size(TFR_all.fourierspctrm, 1));
    ITC_rem(i, :,:,:) = squeeze(abs(sum(TFR_rem.fourierspctrm./abs(TFR_rem.fourierspctrm)))/size(TFR_rem.fourierspctrm, 1));
    ITC_nrem(i, :,:,:) = squeeze(abs(sum(TFR_nrem.fourierspctrm./abs(TFR_nrem.fourierspctrm)))/size(TFR_nrem.fourierspctrm, 1));
    
end

%% Assign to null variables
itc           = [];
itc.label     = TFR_all.label;
itc.freq      = TFR_all.freq;
itc.time      = TFR_all.time;
itc.dimord    = 'rpt_chan_freq_time';

ITC_all_null = itc;
ITC_all_null.itpc = ITC_all;

ITC_rem_null = itc;
ITC_rem_null.itpc = ITC_rem;

ITC_nrem_null = itc;
ITC_nrem_null.itpc = ITC_nrem;
end
