function resp_modulation2_null(r, true_vals, null_vals, signMask, mask_chan)
%% Code to reproduce Fig. 2 from Kluger et al., NatComms 2023
% underlying data structures can be obtained from the same OSF directory
% CircStat toolbox is required (https://github.com/circstat/circstat-matlab)

m    = nanmean(true_vals);
s    = nanstd(true_vals)./sqrt(size(true_vals,1)+sum(mask_chan));

m_shuff    = nanmean(null_vals);
s_shuff    = nanstd(null_vals)./sqrt(size(null_vals,1)+sum(mask_chan)); 


mins = m - s;
maxs = m + s;
mins(end+1) = mins(1);
maxs(end+1) = maxs(1);
m(end+1) = m(1);
r(end+1) = r(1);

mins_shuff = m_shuff - s_shuff;
maxs_shuff = m_shuff + s_shuff;
mins_shuff(end+1) = mins_shuff(1);
maxs_shuff(end+1) = maxs_shuff(1);

figure;

% polar plot for slope
cmap = [magma(30); flipud(magma(31))];
% r = linspace(-pi,pi,60);
ax = polaraxes;
% polarscatter(r,shiftmeans',5,'MarkerFaceColor','k','MarkerFaceAlpha',0.25,'MarkerEdgeColor',[1 1 1]); % It doesnt work
hold on
polarplot(r,m,'Color', [0.4940 0.1840 0.5560], 'LineWidth', 4);
hold on


polarplot(r,mins_shuff,'k--');

rlim([min(mins)-0.01, max(maxs)+0.01])
set(ax,'RTickLabel','');

% Plot significance
signMask = movmax(signMask, [1,0]);
signMask(end+1) = signMask(1);
r_sign = r;
r_sign(~signMask) = nan;
sign_line = m;
polarplot(r_sign, sign_line, 'r', 'LineWidth', 3);

legend(["Power [8-20 Hz]", "Null distribution", "p < 0.05"], 'AutoUpdate', 'off');
polarplot(r,mins,'Color', [0.4940 0.1840 0.5560]);
polarplot(r,maxs, 'Color', [0.4940 0.1840 0.5560]);
polarplot(r,maxs_shuff,'k--');

end