function data_final = smooth_circular(data, avg_window, dim)

    % Expand data to account for circularity
    dataExpanded = cat(dim, data, data, data);
    
    % Smooth as usual
    smoothedData = movmean(dataExpanded, avg_window, dim);
    
    % Truncate to the original size
    switch(dim)
        case 1
            data_final = smoothedData(size(data,1)+1:size(data,1)*2,:);
        case 2
            data_final = smoothedData(:, size(data,2)+1:size(data,2)*2);
        case 3
            data_final = smoothedData(:, :, size(data,3)+1:size(data,3)*2);
        case 4
            data_final = smoothedData(:, :, :, size(data,4)+1:size(data,4)*2);
        otherwise
            disp("Not coded for that dimension")
            data_final = data;
    end
end
    
    