function comp = my_PCA(cfg, data_to_run)
% Code adapted from Abdellahi_2024

if strcmp(cfg.step,'calculate')
    comp=[];
    if iscell(data_to_run.trial)
        data = cell2mat(data_to_run.trial)';
    else
        data = permute(data_to_run.trial, [3 1 2]);
        data = reshape(data, [], size(data,3));
    end
    data(isnan(sum(data,2)), :)=[]; % removing nans
    if cfg.centered==0
        data = data - repmat(mean(data,1),size(data,1),1); % removing the mean because the mean changes the location of the PC and data and we need
        % to be scale/value invariant and not change the orientation
    end
    [comp.eigVects,comp.scores,~,~, comp.eigVals] = pca(data); % gets eig vectors and values and they are sorted
    comp.eigValsCum = cumsum(comp.eigVals);
    % according to variance descendingly, cols in eigVects
    % are the eigen vectors so to project data with pc1: eigVects(:,1)' * data' ... assuming data is samples_features
end
if strcmp(cfg.step,'transform')
    
    if ~iscell(data_to_run.trial)
        for itrial = 1:size(data_to_run.trial,1)
            trial{itrial} = squeeze(data_to_run.trial(itrial,:,:));
        end
        data = data_to_run;
        data.trial = trial;
    else
        data =data_to_run;
    end
    
    if cfg.centered==0
        temp = cell2mat(data.trial); temp = temp'; % removing the mean
        temp = (temp - repmat(nanmean(temp,1),size(temp,1),1))';
        temp = reshape(temp,size(data.trial{1,1},1),size(data.trial{1,1},2), length(data.trial));
        for i=1:size(temp,3), temp2{1,i} = squeeze(temp(:,:,i)); end
        data.trial = temp2;
    end   
    
    
    comp.trial = cellfun(@(x) (cfg.eigVects(:,logical(cfg.chosen))' * x), data.trial,'Un',0); %cfg.chosen is logical that contains the eigVects to keep
    
    if ~cfg.updateSens
        comp.trial = cellfun(@(x) (cfg.eigVects(:,logical(cfg.chosen)) * x), comp.trial,'Un',0);
    end
    
    % this comp.trial is the projection of the data using the eigVects
    % chosen in cfg.chosen
end