function phase_angles = get_angle_phase(cfg, data)

% Save structure
phase_angles = data;

% Get sampling frequency
Fs = ft_getopt(cfg,'Fs',[]);

if isempty(Fs)
    error('Please Specify cfg.Fs');
elseif ~isnumeric(Fs)
    error('cfg.Fs needs to be numeric (e.g. 1000)');
end

% Get phase frequencies
phase_freqs = ft_getopt(cfg,'phase_freqs', 0.25);

% Get phase window
phase_freqs_radi = ft_getopt(cfg,'phase_freqs_radi', 0.05);

% Get filter order
filt_order = ft_getopt(cfg,'filt_order',2);

for itrial = 1:size(data.trial,2)
    data_trial = data.trial{1, itrial};
    phase_trial = zeros(1, size(data_trial,2), 1); % The dimensions are for possible future expansion
    
    try
        [filt] = ft_preproc_bandpassfilter(data_trial, Fs,...
            [phase_freqs-phase_freqs_radi, phase_freqs+phase_freqs_radi],...
            filt_order, 'but', 'twopass', 'no');
    catch
        error('Could not filter ... Perhaps try a lower filter order');
    end

    phase_trial(1,:,1) = ft_preproc_hilbert(filt, 'angle');
    phase_angles.trial{1,itrial} = phase_trial;
end

phase_angles.cfg_ang_phase.Fs = Fs;
phase_angles.cfg_ang_phase.filt_order = filt_order;
phase_angles.cfg_ang_phase.phase_freqs = phase_freqs;
phase_angles.cfg_ang_phase.phase_freqs_radi = phase_freqs_radi;

end