function amp_envs = get_amp_envelopes(cfg, data)

amp_envs = data; % Save structure

% Get sampling frequency
Fs = ft_getopt(cfg,'Fs',[]);

if isempty(Fs)
    error('Please Specify cfg.Fs');
elseif ~isnumeric(Fs)
    error('cfg.Fs needs to be numeric (e.g. 1000)');
end

% Get amplitude frequencies
amp_freqs = ft_getopt(cfg,'amp_freqs',[0.5:2:Fs/2]);

% Get filter order
filt_order = ft_getopt(cfg,'filt_order',4);

% Get amplitude bandwidth method
amp_bandw_method = ft_getopt(cfg,'amp_bandw_method','maxphase');
amp_bandw = ft_getopt(cfg,'amp_bandw',10);

% Get envelope amplitude per trial (retrieval session)
for itrial = 1:size(data.trial,2)
    data_trial = data.trial{1, itrial};
    amp_trial = zeros(size(data_trial,1), size(data_trial,2), length(amp_freqs));

    for amp = 1:length(amp_freqs)

        % Switch based on bandwidth method
        switch amp_bandw_method

            case 'number'

                if amp_freqs(amp) == .5
                    Af1 = .2;
                else

                Af1 = amp_freqs(amp) - amp_bandw;
                end

                Af2 = amp_freqs(amp) + amp_bandw;

            case 'maxphase'
                if amp == 1
                    fprintf('Bandwidth = %.1fHz\n',1.5.*max(phase_freqs));
                end
                %
                Af1 = amp_freqs(amp) - 1.5*max(phase_freqs);
                Af2 = amp_freqs(amp) + 1.5*max(phase_freqs);

            case 'centre_freq'
                if amp == 1
                    fprintf('Bandwidth = 2.5* centre amplitude frequency\n')
                end

                Af1 = round(amp_freqs(amp) -(amp_freqs(amp)/2.5));
                Af2 = round(amp_freqs(amp) +(amp_freqs(amp)/2.5));

        end

        % Filter
        [filt] = ft_preproc_bandpassfilter(data_trial, Fs,...
            [Af1 Af2],filt_order, 'but', 'twopass', 'no');

        % Take abs
        amp_trial(:,:,amp) = ft_preproc_hilbert(filt, 'abs');
    end

    amp_envs.trial{1,itrial} = amp_trial;
end

amp_envs.cfg_amp_env.Fs = Fs;
amp_envs.cfg_amp_env.amp_freqs = amp_freqs;
amp_envs.cfg_amp_env.filt_order = filt_order;
amp_envs.cfg_amp_env.amp_bandw_method = amp_bandw_method;
amp_envs.cfg_amp_env.amp_bandw = amp_bandw;

end