function [MI] = calc_MI_tort(Phase,Amp,nbin)
    position=zeros(1,nbin); 
    winsize = 2*pi/nbin;
    for j=1:nbin
        position(j) = -pi+(j-1)*winsize;
    end
    
    MeanAmp=zeros(1,nbin);
    for j=1:nbin
        I = (Phase <  position(j)+winsize) & (Phase >=  position(j));
        MeanAmp(j)=nanmean(Amp(I), 'all');
    end
    
    MI=(log(nbin)-(-sum((MeanAmp/sum(MeanAmp)).*log((MeanAmp/sum(MeanAmp))))))/log(nbin);
end