function loadedData = load_segm_data(dirRoot, dirSubject, session, norm, removeArtifacts)

    tmp          = load(fullfile(dirRoot,dirSubject(session).name,'ret1',strcat(dirSubject(session).name,'_ret1_segm_resp.mat')));
    data_r1       = tmp.ret1;

    tmp          = load(fullfile(dirRoot,dirSubject(session).name,'ret2',strcat(dirSubject(session).name,'_ret2_segm_resp.mat')));
    data_r2       = tmp.ret2;

    % Get EEG data
    cfg                    = [];
    cfg.channel            = {'all', '-resp'}; 
    cfg.removemean         = 'no';
    cfg.bpfilter   = 'yes';
    cfg.bpfreq     = [0.1 45];
    cfg.bpinstabilityfix = 'reduce';

    data_eeg1            = ft_preprocessing(cfg, data_r1);
    data_eeg2            = ft_preprocessing(cfg, data_r2);                            

    % Get respiration data
    cfg                    = [];
    cfg.channel            = {'resp'}; 
    cfg.removemean         = 'no';
%     cfg.bpfilter   = 'yes';
%     cfg.bpfreq     = [0.1 0.5];
%     cfg.bpinstabilityfix = 'reduce';
        
    data_resp1            = ft_preprocessing(cfg, data_r1);  
    data_resp2            = ft_preprocessing(cfg, data_r2);
    
    % Append both
    cfg = [];

    data_r1 = ft_appenddata(cfg, data_eeg1, data_resp1);
    data_r2 = ft_appenddata(cfg, data_eeg2, data_resp2);


    cfg                    = [];
    cfg.keeptrials         = 'yes';
    cfg.removemean         = 'no';

    data_r1            = ft_timelockanalysis(cfg, data_r1);
    data_r2            = ft_timelockanalysis(cfg, data_r2);

    % add conditions
    for i = 1:size (data_r1.trialinfo,1)
            data_r1.trialinfo{i, 1}.Stimtype = session;
    end

    for i = 1:size (data_r2.trialinfo,1)
            data_r2.trialinfo{i, 1}.Stimtype = session;
    end     

    trialinfo_all = [data_r1.trialinfo; data_r2.trialinfo];
    data_all = ft_appendtimelock([], data_r1, data_r2);
    data_all.trialinfo = trialinfo_all;

    % Remove artifacts (if marked file exists)
    if removeArtifacts && isfile(fullfile(dirSubject(session).folder, dirSubject(session).name, "artifact_trials.txt"))
        artifs = readmatrix(fullfile(dirSubject(session).folder, dirSubject(session).name,"artifact_trials.txt"));
        cfg = [];
        cfg.artfctdef.visual.artifact = artifs;
        data_all = ft_rejectartifact(cfg, data_all);

%             copyfile(fullfile(dirSubject(session).folder, dirSubject(session).name,"artifact_trials.txt"), ...
%                 fullfile(destinationFolder, strcat(dirSubject(session).name, "_artifs.txt")));
    end                         

    num_trials = size(data_all.time, 2);
    num_channels = size(data_all.label, 1);
    
    if norm
        % zscore data
        all_trials = zscore([data_all.trial{:}], [], 2);
        all_trials = reshape(all_trials', [], num_trials, num_channels);
        for itrial = 1:size(all_trials,2)
            data_all.trial{1,itrial} = squeeze(all_trials(:,itrial,:))';
        end
    end
    
    loadedData = data_all;
end