% Schreiner et al. 2024: Figure_4;

%% Ripple TFR

subjects     = {'Pmtl02'};


for iSub=1:numel(subjects)
            
    subID      = subjects{iSub};   
                
    cd(fullfile(datadir, [subjects{iSub}], sleep_folder))    
    
    load ([subjects{iSub} sleep_ripples]);
              
    cfg              = [];
    cfg.bsfilter     = 'yes';
    cfg.bsfreq       = [48 52];
    cfg.lpfilter     = 'yes';
    cfg.lpfreq       = 200;
   
    cfg.removemean   = 'no';        
    eeg              = ft_preprocessing(cfg, eeg);

    cfg              = [];
    cfg.channel      = {'Hipp*', 'Ento*', 'Para*'};
    cfg.latency      = [-1 1];
    eeg              = ft_selectdata(cfg, eeg);
   

    for irip = 1:size(eeg.label,1)

        cfg              = [];
        cfg.keeptrials   = 'yes';
        cfg.output       = 'pow';
        cfg.channel      = eeg.label(irip);
        cfg.method       = 'mtmconvol';
        cfg.taper        = 'hanning'; 
        cfg.foi          = [1:1:200];    
        cfg.tapsmofrq    = 0.5 *cfg.foi; 

        cfg.t_ftimwin    = 5./cfg.foi; 
        cfg.pad          = 16;
        cfg.toi          = -1:0.01:1;  
        tfr_all_rip      = ft_freqanalysis(cfg, eeg);

        startT  = nearest(tfr_all_rip.time,-1);
        endT    = nearest(tfr_all_rip.time, 1);
        
            pow  = tfr_all_rip.powspctrm;
            powz = nan(size(pow));
            
            for ichan = 1:size(pow,2)
                for ifreq = 1:size(pow,3)
                    d = squeeze(pow(:,ichan,ifreq,startT:endT));
                    m = nanmean(d(:));
                    s = nanstd(d(:));
                    
                    powz(:,ichan,ifreq,:) = (pow(:,ichan,ifreq,:) - m)./s;
                end
            end
            
        pow                    = [];
        tfr_all_rip.powspctrm  = powz;                   
        clear powz;  

        tfr_all_rip.dimord    = 'chan_freq_time';
        temp(1,:,:)           = squeeze(nanmean(tfr_all_rip.powspctrm,1));
        tfr_all_rip.powspctrm = temp;
        
        cfg                   = [];
        cfg.latency           = [-.25 .25];  % time range  
        tfr_all_rip           = ft_selectdata(cfg, tfr_all_rip);
        tfr_all_rip.label     = {'ripple'};

        tfr_all_ripsi{irip}   =  tfr_all_rip;
             
    end

    all_rip{iSub}   = tfr_all_ripsi;

end

    alli_r = []; 
    alli_r = horzcat(all_rip{:});

    cfg = [];
    cfg.toilim   = [-.1 .1];
    ga  = ft_freqgrandaverage(cfg, alli_r{:});

    h = pcolor(ga.time,ga.freq,squeeze(ga.powspctrm));
    shading interp ;%
    lighting phong;
    axis xy; 
    set(h, 'EdgeColor', 'none');
    caxis([0 2])
    colorbar

    set(gcf, 'Position', [100, 400, 570, 200]);

    
    
%% Spindle TFR
    
subjects     = {'Pmtl02'};


for iSub=1:numel(subjects)
            
    subID      = subjects{iSub};   
                
    cd(fullfile(datadir, [subjects{iSub}], sleep_folder))    
    
    load ([subjects{iSub} sleep_ripples]);
              
    cfg              = [];
    cfg.bsfilter     = 'yes';
    cfg.bsfreq       = [48 52];
    cfg.lpfilter     = 'yes';
    cfg.lpfreq       = 200;
   
    cfg.removemean   = 'no';        
    eeg              = ft_preprocessing(cfg, eeg);

    cfg              = [];
    cfg.channel      = {'Front*', 'Temp*', 'Pari*'};
    eeg              = ft_selectdata(cfg, eeg);
   

    for irip = 1:size(eeg.label,1)

        cfg              = [];
        cfg.keeptrials   = 'yes';
        cfg.output       = 'pow';
        cfg.channel      = eeg.label(irip);
        cfg.method       = 'mtmconvol';
        cfg.taper        = 'hanning'; 
        cfg.foi          = [1:1:30];    
        cfg.tapsmofrq    = 0.5 *cfg.foi; 

        cfg.t_ftimwin    = 5./cfg.foi; 
        cfg.pad          = 16;
        cfg.toi          = -1:0.01:4;  
        tfr_all_spi      = ft_freqanalysis(cfg, eeg);

        startT  = nearest(tfr_all_spi.time,-1);
        endT    = nearest(tfr_all_spi.time, 4);
        
            pow  = tfr_all_spi.powspctrm;
            powz = nan(size(pow));
            
            for ichan = 1:size(pow,2)
                for ifreq = 1:size(pow,3)
                    d = squeeze(pow(:,ichan,ifreq,startT:endT));
                    m = nanmean(d(:));
                    s = nanstd(d(:));
                    
                    powz(:,ichan,ifreq,:) = (pow(:,ichan,ifreq,:) - m)./s;
                end
            end
            
        pow                    = [];
        tfr_all_spi.powspctrm  = powz;                   
        clear powz;  

        tfr_all_spi.dimord    = 'chan_freq_time';
        temp(1,:,:)           = squeeze(nanmean(tfr_all_spi.powspctrm,1));
        tfr_all_spi.powspctrm = temp;
        
        cfg                   = [];
        cfg.latency           = [-.25 .25];  % time range  
        tfr_all_spi           = ft_selectdata(cfg, tfr_all_spi);
        tfr_all_spi.label     = {'spindle'};

        tfr_all_spi{irip}     =  tfr_all_spi;
             
    end

    all_spi{iSub}   = tfr_all_spi;

end

    alli_r = []; 
    alli_r = horzcat(all_spi{:});

    cfg        = [];
    cfg.toilim = [-.1 .1];
    ga         = ft_freqgrandaverage(cfg, alli_r{:});

    h = pcolor(ga.time,ga.freq,squeeze(ga.powspctrm));
    shading interp ;%
    lighting phong;
    axis xy; 
    set(h, 'EdgeColor', 'none');
    caxis([0 2])
    colorbar

    set(gcf, 'Position', [100, 400, 570, 200]);

    
%% Modulation Index

TMRdir     = fullfile(mother,'/sleep/');
sleep_EEG  = '_ripple_centered_4MI_and_phase'; % ripple centered TMR (emerging during time-window of spindle activity)   

subjects   = {'Pmtl02'}; 

for iSub = 1:numel(subjects)
            
    cd(fullfile(TMRdir, [subjects{iSub}]))    
    load ([subjects{iSub} sleep_EEG]);

    freqwidth_factor = 0.3; 

    f_pha = 4:.5:20; % frequency for phase
    f_amp = 4:5:140; % frequency for amplitude      
  
    for ichan = 1:size(temp.chanMTL,1) % loop across MTL contacts
    
        % for f_phase
        for ifreq = 1:length(f_pha)
            
            fc = f_pha(ifreq);
            hw = fc*freqwidth_factor; 
            
            %%%% get hilbert filtert data
            cfg = [];
            cfg.bpfilttype = 'fir';
            cfg.bpfilter   = 'yes';
            cfg.bpfreq     = [fc-hw fc+hw];
            cfg.channel    = {temp.chanMTL{ichan}};
    
            cfg.hilbert    = 'angle';
            cfg.keeptrials = 'yes';
            cfg.demean     = 'yes';
            cfg.detrend    = 'yes';    
            data           = ft_preprocessing(cfg,temp); %% angles/phases
            
            cfg         = [];
            cfg.latency = [-.75 ,.75];
            data        = ft_selectdata(cfg, data); 
    
            cfg         = [];
            data        = ft_appenddata(cfg, data);
           
            data_f_pha(ifreq,:,:) = cat(3,data.trial{:});clearvars data
    
        end
        
        % for f_amp
        for ifreq = 1:length(f_amp)
            fc = f_amp(ifreq);
            hw = fc*freqwidth_factor; 
            
            %%%% get hilbert filert data
            cfg = [];
            cfg.bpfilttype = 'fir';
            cfg.bpfilter   = 'yes';
            cfg.channel    = temp.chanSpindle;
            cfg.bpfreq     = [fc-hw fc+hw];
            cfg.hilbert    = 'abs';
            cfg.keeptrials = 'yes';
            cfg.demean     = 'yes';
            cfg.detrend    = 'yes';
            data           = ft_preprocessing(cfg,temp); 
            
            cfg            = [];
            cfg.latency    = [-.75 .75];
            data           = ft_selectdata(cfg, data); 
    
            cfg            = [];
            data           = ft_appenddata(cfg, data);
            
            data_f_amp(ifreq,:,:) = cat(3,data.trial{:});clearvars data
    
        end
    
        % Bin the Phase/Amp 
        AMP            = permute(data_f_amp,[3,1,2]); 
        PHASE          = permute(data_f_pha,[3,1,2]);
    
        cfg            = [];
        cfg.modify     = 'no'; 
        cfg.keeptrials = 'yes'; 
        cfg.nbins      = 18;
                
        for i_f_amp = 1:numel(f_amp)
            disp(['Sub ', int2str(iSub), 'chan ', int2str(ichan) , ' : for Freq ' int2str(i_f_amp) ' / ' int2str(numel(f_amp))])
    
            for i_f_pha = 1:numel(f_pha)
                p_all(i_f_amp,i_f_pha,:,:) = Binning(AMP(:,i_f_amp,:), PHASE(:,i_f_pha,:), cfg); 
                % Entropy measure    
                H(i_f_amp,i_f_pha,:) = -sum(squeeze(p_all(i_f_amp,i_f_pha,:,:)).*log(squeeze(p_all(i_f_amp,i_f_pha,:,:))),2);
                % Modulation Index 
                MI(i_f_amp,i_f_pha,:) = (log(cfg.nbins)-H(i_f_amp,i_f_pha,:))./log(cfg.nbins);
    
            end
        end
        
        MI_chan{ichan} = MI;
        clear MI
    
        % surrogate trials from here (200 shuffles)
        n_shf = 200;
    
        % Bin the Phase/Amp 
        AMP            = permute(data_f_amp,[3,1,2]); 
        PHASE          = permute(data_f_pha,[3,1,2]);
        cfg            = [];
        cfg.modify     = 'no'; 
        cfg.keeptrials = 'yes'; 
        cfg.nbins      = 18;
        
        for i_shf = 1:n_shf
            rand_idx = randperm(length(AMP(:, 1, 1)));
            disp(['Sub ', int2str(iSub),'chan ', int2str(ichan)  , ' , Shuffle number: ', int2str(i_shf), ' / ', int2str(n_shf)])    
            
            for i_f_amp = 1:numel(f_amp)
                for i_f_pha = 1:numel(f_pha)
                    p_all = Binning(AMP(rand_idx,i_f_amp,:), PHASE(:,i_f_pha,:), cfg); 
                    % Entropy measure
                    H = -sum(squeeze(p_all).*log(squeeze(p_all)),2);
                    % Modulation Index 
                    MI_shuf(i_f_amp,i_f_pha,:,i_shf) = (log(cfg.nbins)-H)./log(cfg.nbins);
                    clearvars p_all H
                end
            end
    
        end 
    
       MI_shuf = mean(MI_shuf,4); 
    
       MI_shuf_chan{ichan} = MI_shuf;
       MI_sub{iSub}        = MI_chan; 
       MI_shuf_sub{iSub}   = MI_shuf_chan; 
    
    end

end

% prepare stats

MI_m = horzcat(MI_sub{:});
MI_shuf_m = horzcat(MI_shuf_sub{:});

% average across trials, add first singleton dim for FT

for  i = 1:length(MI_shuf_m)    
    MI_shuf_m{1, i} = mean(MI_shuf_m{1, i},3);
    MI_m     {1, i} = (mean(MI_m{1, i},3));

    MI_shuf{1, i}(1,:,:) = MI_shuf_m{1, i};
    MI{1, i}(1,:,:)      = MI_m{1, i};   
end

% build template
temp            = [];
temp.fsample    = 1000;
temp.time       = f_pha;
temp.freq       = f_amp;
temp.dimord     = 'chan_freq_time';
temp.powspctrm  = MI{1,1};
temp.label      = {'MI'};

for i = 1:length(MI)
    MI_all{i}                   = temp;
    MI_all{1, i}.powspctrm      = MI{1, i};

    MI_all_shuf{i}              = temp;
    MI_all_shuf{1, i}.powspctrm = MI_shuf{1, i}; 
end


% run stats
cfg                     = [];
cfg.spmversion          = 'spm12';
cfg.latency             = [4 20];
cfg.frequency           = [20 130];
cfg.statistic           = 'depsamplesT';
cfg.method              = 'montecarlo';
cfg.correctm            = 'cluster';
cfg.alpha               = .05;
cfg.clusteralpha        = .05;
cfg.tail                = 0;
cfg.correcttail         = 'alpha';
cfg.neighbours          = [];
cfg.minnbchan           = 0;
cfg.computecritval      = 'yes';
cfg.numrandomization    = 1000;

cfg.clusterstatistic    = 'maxsum';
cfg.clustertail         = cfg.tail;
cfg.parameter           = 'powspctrm';

design = zeros(2,2*(size(MI_all,2)));
design(1,:)= [1:size(MI_all,2), 1:size(MI_all,2)];
design(2,:)= [ones(1,size(MI_all,2)), 2*ones(1,size(MI_all,2))];

cfg.design  = design;
cfg.uvar    = 1;
cfg.ivar    = 2;

[Fieldtripstats] = ft_freqstatistics(cfg, MI_all{:}, MI_all_shuf{:});
length(find(Fieldtripstats.mask))

    
% plot stats
stat.stat = Fieldtripstats.stat.*Fieldtripstats.mask; 
t_sums    = squeeze((stat.stat));

figure;

pcolor(Fieldtripstats.time,Fieldtripstats.freq, t_sums); 
shading interp;
axis xy; 
ll = xlabel('time [seconds]', 'Fontsize', 17);
yy = ylabel('Frequency [Hz]', 'Fontsize', 17);
set(gca,'layer','top')
set(gca,'TickDir','in', 'Linewidth',2);

caxis([0 3]);
set(gcf, 'Color', 'w')
colorbar;
hcb = colorbar;

set(gca,'FontSize',14)
ax = gca;


%% Preferred spindle phase for ripple coupling


TMRdir     = fullfile(mother,'/sleep/');
sleep_EEG  = '_ripple_centered_4MI_and_phase'; % ripple centered TMR (emerging during time-window of spindle activity)   

subjects   = {'Pmtl02'};

for iSub = 1:numel(subjects)
           
    cd(fullfile(TMRdir, [subjects{iSub}]))    
    load ([subjects{iSub} sleep_EEG]);

    for ichan = 1:size(temp.chanMTL,1)

        cfg.channel               = {temp.chanSpindle};
        temp                      = ft_selectdata(cfg, temp);      

        cfg                       = [];
        cfg.detrend               = 'yes';     
        cfg.bpfilter              = 'yes';
        cfg.bpfreq                = [12 15];
        cfg.bpinstabilityfix      = 'reduce';
        cfg.bpfiltdir             = 'twopass';
        temp_filt                 = ft_preprocessing(cfg, temp);

        cfg                       = []; 
        cfg.hilbert               = 'angle'; 
        spi_phase                 = ft_preprocessing(cfg, temp_filt);

        % compute the average
        timelock_circ.time        = spi_phase.time;
        timelock_circ.sampleinfo  = spi_phase.sampleinfo;
        timelock_circ.dimord      = spi_phase.dimord;
        
        timelock_circ.avg         = squeeze(circ_mean(spi_phase.trial));   
        timelock_circ.phase       = squeeze(spi_phase.trial(:,1701)); % sampling point 1701 corresponds to ripple center     
        
        timelock_circ.r_time_zero = squeeze(circ_r(spi_phase.trial(:,1701))); % vector length at time point zero (ripple peak)
        timelock_circ.label       = spi_phase.label;

        all_dat{ichan}            = timelock_circ;

        clear timelock_circ

    end

    all_dats{iSub} = all_dat;
    
end


%% Ripple triggered Classification

TMRdir     = fullfile(mother,'/sleep/');
datadir    = fullfile(mother,'/wake/');

sleep_EEG  = '_ripple_centered_4TMR'; % spindle-locked ripple centered TMR  
wake_EEG   = '_ret.mat';              % retrieval data

subjects  = {'Pmtl02'};

% time of interest
TOI_wake  = [-0.3 0.3] ;
TOI_sleep = [-0.3 0.3];

classi_timeaxis_train = TOI_wake(1):0.01:TOI_wake(2);
classi_timeaxis_test  = TOI_sleep(1):0.01:TOI_sleep(2);
acc                   = cell(1,numel(subjects));

% subject loop

for iSub = 1:numel(subjects)
            
    cd(fullfile(datadir, [subjects{iSub}]))    
    load ([subjects{iSub} wake_EEG]);

    cd(fullfile(TMRdir, [subjects{iSub}]))  
    load ([subjects{iSub} sleep_EEG]);
    
    % check which head directions were cued
    for ii = 1:10
        hd_react(ii) = data_sleep.trialinfo{ii,1}.Display;  
    end
    
    hd_react = unique(hd_react);
    hd_react = sort(hd_react);
    hd_react = (hd_react(1:2));
            
    % resample      
    cfg            = [];
    cfg.resamplefs = 200;   
    eeg            = ft_resampledata(cfg, eeg);   
         
    % add to trialinfo whether head-direction was cued before 
    for jj = 1 :size (eeg.trialinfo,1)        
        if ismember(eeg.trialinfo{jj, 1}.head_angle, hd_react) ==1
           eeg.trialinfo{jj, 1}.React = 1;
        else
           eeg.trialinfo{jj, 1}.React = 0;
        end
    end
          
    % bring data into better format and normalize (z-score)
    cfg                    = [];
    cfg.hpfilter           = 'yes';
    cfg.hpfreq             = 0.1;
    cfg.lpfilter           = 'no';
    cfg.lpfreq             = 40;
    cfg.hpinstabilityfix   = 'reduce';    
    cfg.bsfilter           = 'yes';
    cfg.bsfreq             = [48 52];
    cfg.demean             = 'yes';           
    cfg.removemean         = 'no';        
    data_trl_ret           = ft_preprocessing(cfg, eeg);

    cfg                    = [];
    cfg.keeptrials         = 'yes';
    cfg.removemean         = 'no';     
    data_trl_ret           = ft_timelockanalysis(cfg,data_trl_ret);
    dat_trial_ret1         = data_trl_ret.trial;
       
    % z-score
    preprocess_param          = mv_get_preprocess_param('zscore');
    [~, dat_trial_norm_ret1 ] = mv_preprocess_zscore(preprocess_param, dat_trial_ret1 );        
    data_trl_ret.trial        = dat_trial_norm_ret1;  
    
    % reduce data to experimental conditions (left + right react) ret1
    trs_exp_ret1 = [];   
    for tr = 1 : size(data_trl_ret.trial,1)
        if (data_trl_ret.trialinfo{tr,1}.React ~= 0)
    trs_exp_ret1 = cat(1,trs_exp_ret1,tr);  
        end
    end 
          
    % allocate data to conditions
    cfg            = []; 
    cfg.trials     = trs_exp_ret1; 
    data_trl_ret   = ft_redefinetrial(cfg,data_trl_ret);     
            
    % bring into format
    cfg            = [];
    data_wake      = ft_appenddata(cfg,data_trl_ret); 
        
    % do the same for sleep data                          
    cfg            = [];
    cfg.resamplefs = 200;   
    data_sleep     = ft_resampledata(cfg, data_sleep);       
    
    % bring data into better format and normalize (z-score)
    cfg                    = [];
    cfg.bsfilter           = 'yes';
    cfg.bsfreq             = [48 52];
    cfg.hpfilter           = 'yes';
    cfg.hpfreq             = 0.1;
    cfg.hpinstabilityfix   = 'reduce';
    cfg.lpfilter           = 'no';
    cfg.lpfreq             = 40;
    cfg.removemean         = 'no';        
    data_sleep             = ft_preprocessing(cfg, data_sleep);

    cfg                    = [];
    cfg.keeptrials         = 'yes';
    cfg.removemean         = 'no';     
    data_sleep             = ft_timelockanalysis(cfg,data_sleep);
    dat_sleep              = data_sleep.trial;

    % z-score
    preprocess_param       = mv_get_preprocess_param('zscore');
    [~, dat_trial_norm ]   = mv_preprocess_zscore(preprocess_param, dat_sleep);        
    data_sleep.trial       = dat_trial_norm;
 
    % append wake & sleep                
    cfg              = [];
    data_sleep       = ft_appenddata (cfg, data_sleep);

    cfg              = [];
    cfg.channel      = data_sleep.label;
    data_wake        = ft_selectdata(cfg, data_wake);
    
    cfg              = [];
    cfg.channel      = data_wake.label;
    data_sleep       = ft_selectdata(cfg, data_sleep);
    
    cfg              = [];
    data_app         = ft_appenddata (cfg, data_wake, data_sleep);   
           
    % run pca on appended data and reduce ranks
    cfg              = [];
    cfg.method       = 'pca';
    cfg.updatesens   = 'no';
    cfg.numcomponent = 30; 
    comp             = ft_componentanalysis(cfg, data_app);

    cfg              = [];
    cfg.updatesens   = 'no';
    cfg.component    = comp.label(31:end);
    data_app         = ft_rejectcomponent(cfg, comp);       

    % identify wake data
    cfg              = [];
    cfg.trials       = 1:numel(data_wake.trialinfo);
    data_all_wake    = ft_selectdata(cfg,data_app);

    % identify sleep part
    cfg              = [];
    cfg.trials       = numel(data_wake.trialinfo)+1:numel(data_app.trialinfo);
    data_all_sleep   = ft_selectdata(cfg,data_app);
            
    % temporal smoothing (running average)        
    for itrial = 1:numel(data_all_wake.trial)
        data_all_wake.trial{itrial} = smoothdata(data_all_wake.trial{itrial},2,'movmean',0.15/(1/data_all_wake.fsample));
    end

    for itrial = 1:numel(data_all_sleep.trial)
        data_all_sleep.trial{itrial} = smoothdata(data_all_sleep.trial{itrial},2,'movmean',0.15/(1/data_all_sleep.fsample));
    end
    
    % prepare data for classification
    cfg             = [];
    cfg.keeptrials  = 'yes';
    cfg.removemean  = 'no'; 
    tmp             = ft_timelockanalysis(cfg,data_all_wake);
    dat_wake        = tmp.trial;
    tmp             = [];
    
    % class selection (2 classes)
    trlinfo  = cell2mat(data_all_wake.trialinfo);    
    category = [trlinfo.head_angle];       
    behav    = [trlinfo.headang_acc];
    
    % Training (define classes)
    left    = [1,2];
    right   = [3,4];
    correct = 1;
    
    train_sel1  = ismember(category,left) & ismember(behav,correct);
    train_sel2  = ismember(category,right)& ismember(behav,correct);

    % Training Labels
    train_dat       = cat(1,dat_wake(train_sel1,:,:),dat_wake(train_sel2,:,:));
    classcode_train = cat(1,1*ones(sum(train_sel1),1),2*ones(sum(train_sel2),1));
        
    trialinfo     = [];
    category      = [];
    
    % now the same for sleep data    
    % bring data into better format
    cfg             = [];
    cfg.keeptrials  = 'yes';
    cfg.removemean  = 'no';
    tmp             = ft_timelockanalysis(cfg,data_all_sleep);
    dat_sleep       = tmp.trial;
    tmp             = [];
    
    % class selection (2 classes)    
    trlinfo  = cell2mat(data_all_sleep.trialinfo);    
    category = [trlinfo.Display];       
 
    % Testing data (define classes))
    left  = [1,2];
    right = [3,4];
    
    test_sel1  = ismember(category,left); 
    test_sel2  = ismember(category,right);  
   
    % Test Labels   
    test_dat       = cat(1,dat_sleep(test_sel1,:,:),dat_sleep(test_sel2,:,:));
    classcode_test = cat(1,1*ones(sum(test_sel1),1),2*ones(sum(test_sel2),1));
       
    trialinfo = [];
    category  = [];
    
    % time-info
    timeaxis_samples_train = nearest(data_all_wake.time{1},TOI_wake(1)):round(0.01*data_all_wake.fsample):nearest(data_all_wake.time{1},TOI_wake(2));
    timeaxis_samples_test  = nearest(data_all_sleep.time{1},TOI_sleep(1)):round(0.01*data_all_sleep.fsample):nearest(data_all_sleep.time{1},TOI_sleep(2));
        
    test_train_dat         = train_dat(:,:,timeaxis_samples_train);
    test_test_dat          = test_dat(:,:,timeaxis_samples_test);
    
    % classification
    cfg             = [];
    cfg.classifier  = 'lda';
    cfg.metric      = 'auc';
    [perf, result]  = mv_classify_timextime(cfg, test_train_dat, classcode_train, test_test_dat, classcode_test);        
    acc{iSub}       = perf;
    
end

% plot it

%define time
start_test = find (classi_timeaxis_test == cfg.latency(1));
fin_test   = find (classi_timeaxis_test == cfg.latency(2));

start_train = find (classi_timeaxis_test == cfg.frequency(1));
fin_train   = find (classi_timeaxis_test == cfg.frequency(2));

%prepare contour plot
stats_time = nearest(cstat{1}.time,cfg.latency(1)):nearest(cstat{1}.time,cfg.latency(2));
stats_freq = nearest(cstat{1}.freq,cfg.frequency(1)):nearest(cstat{1}.freq,cfg.frequency(2));

sigmap    = zeros(numel(Fieldtripstats.freq),numel(Fieldtripstats.time));
sigval    = Fieldtripstats.mask;
sigmap(stats_freq,stats_time) = sigval;

figure;
imagesc(classi_timeaxis_test(start_test:fin_test),classi_timeaxis_train(start_train:fin_train),squeeze(Fieldtripstats.stat));

colorbar
axis xy
xlabel('time TMR (sec)','FontSize', 16)
ylabel('time retrieval (sec)','FontSize', 16)
set(gca,'tickdir','out')
caxis([-3 3])

h = colorbar();
ylabel(h, 't-values','FontSize', 16);
set(gca,'TickDir','in');
set(gca,'linewidth',1.5)

a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a, 'fontsize',16)

a = get(gca,'YTickLabel');    
set(gca,'YTickLabel',a,'fontsize',16)

plot_contour(classi_timeaxis_test(start_test:fin_test),classi_timeaxis_train(start_train:fin_train),sigmap,'k-',2)
xline(0, '--', 'linewidth',1.5)
yline(0, '--', 'linewidth',1.5)
