
''' All functions are designed to print some kind of data structure containing data into a file or the standard output'''

#####################################################################################################################
##################  DICTIONARY WITH KEYS AND ONE OF THE VALUES IN TUPLE TO STOUT ####################################
#####################################################################################################################

def printDict(dict, numValue):
    """
    To print only one of the characteristics associated with the identifiers in the dictionary
    :param dict:
    :param numValue: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :return: only values in the stout
    """
    for key,value in dict.items():
        print(key + ":"+ value[numValue])

def printDict(dict, numValue1:int, numValue2:int):
    """
    To print two characteristics associated with each identifiers in the dictionary
    :param dict: Dictionary containing the fasta sequence and its information
    :param numValue1:  0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param numValue2:  0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :return: only values in the stout
    """
    for key,value in dict.items():
        print(key + ":" + value[numValue1] + value[numValue2])

def printDict(dict, numValue1:int, numValue2:int, numValue3:int):
    """
    To print three characteristics associated with each identifiers in the dictionary
    :param dict: Dictionary containing the fasta sequence and its information
    :param numValue1: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III); 4: source (UniProt or NCBI)
    :param numValue2: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III); 4: source (UniProt or NCBI)
    :param numValue3: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III); 4: source (UniProt or NCBI)
    :return: only values in the stout
    """
    for key,value in dict.items():
        print(key + ":" + value[numValue1] + value[numValue2] + value[numValue3])


#####################################################################################################################
##################  DICTIONARY WITH KEYS AND ONE OF THE VALUES IN TUPLE TO TEXT FILE ################################
#####################################################################################################################


def printDict1(dict, numValue, delimiter, outfile):
    """
    To print one characteristic associated with each identifiers in the dictionary as table in a file located in
    same folder of original fasta file
    :param dict: Dictionary containing the fasta sequence and its information
    :param numValue: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param delimiter: recommended "\t", "," as strings
    :param outfile: global path where file should be placed.
    :return: Delimited file containing the identifier and its associated information defined by the numerical value chosen
    """
    file = open(outfile, "w+")
    for key, value in dict.items():
        print(key + delimiter + value[numValue], file= file)
    file.close()


def printDict2(dict, numValue1: int, numValue2: int, delimiter, outfile):
    """
    To print two characteristic associated with each identifiers in the dictionary as table in a file located in
    same folder of original fasta file
    :param dict: Dictionary containing the fasta sequence and its information
    :param numValue1: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param numValue2: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param delimiter: recommended "\t", "," as strings
    :param outfile: global path where file should be placed.
    :return: Delimited file containing the identifier and its associated information defined by the numerical value chosen
    """
    file = open(outfile, "w+")
    for key, value in dict.items():
        print(key.strip() + delimiter + value[numValue1] + delimiter + value[numValue2], file=file)
    file.close()

def printDict3(dict, numValue1: int, numValue2: int, numValue3: int, delimiter, outfile):
    """
    To print three characteristic associated with each identifiers in the dictionary as table in a file located in
    same folder of original fasta file
    :param dict: Dictionary containing the fasta sequence and its information
    :param numValue1: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param numValue2: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param numValue3: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param delimiter: recommended "\t", "," as strings
    :param outfile: global path where file should be placed.
    :return: delimited file containing the identifier and its associated information defined by the numerical value chosen
    """
    file = open(outfile, "w+")
    for key, value in dict.items():
        print(key + delimiter + value[numValue1] + delimiter + value[numValue2] + delimiter + value[numValue3], file= file)
    file.close()

def printDict4(dict, numValue1: int, numValue2: int, numValue3: int, numValue4:int, delimiter, outfile):
    """
    To print four characteristic associated with each identifiers in the dictionary as table in a file located in
    same folder of original fasta file
    :param dict: Dictionary containing the fasta sequence and its information
    :param numValue1: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param numValue2: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param numValue3: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param numValue4: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
    :param delimiter: recommended "\t", "," as strings
    :param outfile: global path where file should be placed.
    :return: delimited file containing the identifier and its associated information defined by the numerical value chosen
    """
    file = open(outfile, "w+")
    for key, value in dict.items():
        print(key + delimiter + value[numValue1] + delimiter + value[numValue2] + delimiter + value[numValue3]
              + delimiter + value[numValue4], file= file)
    file.close()

def printDict5(dict, numValue1: int, numValue2: int, numValue3: int, numValue4:int, numValue5:int , delimiter, outfile):
    """
     To print four characteristic associated with each identifiers in the dictionary as table in a file located in
     same folder of original fasta file
     :param dict: Dictionary containing the fasta sequence and its information
     :param numValue1: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param numValue2: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param numValue3: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param numValue4: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param numValue5: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param delimiter: recommended "\t", "," as strings
     :param outfile: global path where file should be placed.
     :return: delimited file containing the identifier and its associated information defined by the numerical value chosen
     """
    file = open(outfile, "w+")
    for key, value in dict.items():
        print(key + delimiter + value[numValue1] + delimiter + value[numValue2] + delimiter + value[numValue3]
              + delimiter + value[numValue4] + delimiter + value[numValue5],  file= file)
    file.close()

def printDict6(dict, numValue1: int, numValue2: int, numValue3: int, numValue4:int, numValue5:int, numValue6:int , delimiter, outfile):
    """
     To print four characteristic associated with each identifiers in the dictionary as table in a file located in
     same folder of original fasta file
     :param dict: Dictionary containing the fasta sequence and its information
     :param numValue1: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param numValue2: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param numValue3: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param numValue4: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param numValue5: 0 correspond to the species; 1:sequence; 2:geneName/protein name; 3: type of toxin (type I, II or III)
     :param delimiter: recommended "\t", "," as strings
     :param outfile: global path where file should be placed.
     :return: delimited file containing the identifier and its associated information defined by the numerical value chosen
     """
    file = open(outfile, "w+")
    for key, value in dict.items():
        print(key + delimiter + value[numValue1] + delimiter + value[numValue2] + delimiter + value[numValue3]
              + delimiter + value[numValue4] + delimiter + value[numValue5] + delimiter + value[numValue6],  file= file)
    file.close()

def printDict7(dict, numValue1: int, numValue2: int, numValue3: int, numValue4:int, numValue5:int, numValue6:int, numValue7:int, delimiter, outfile):
    """
     To print four characteristic associated with each identifiers in the dictionary as table in a file located in
     same folder of original fasta file
     :param dict: Dictionary containing the fasta sequence and its information
     :param numValue1: first value after ID
     :param numValue3: third value after ID
     :param numValue2: second value after ID
     :param numValue4: fourth value after ID
     :param numValue5: fifth value after ID
     :param numValue6: sixth value after ID
     :param numValue7: seventh value after ID
     :param delimiter: recommended "\t", "," as strings
     :param outfile: global path where file should be placed.
     :return: delimited file containing the identifier and its associated information defined by the numerical value chosen
     """
    file = open(outfile, "w+")
    for key, value in dict.items():
        print(key + delimiter + value[numValue1] + delimiter + value[numValue2] + delimiter + value[numValue3]
              + delimiter + value[numValue4] + delimiter + value[numValue5]+ delimiter + value[numValue6]
              +delimiter + value[numValue7],  file= file)
    file.close()


#####################################################################################################################
######################## FROM DICTIONARY CONTAINING FASTA TO universal-FASTA FORMAT #################################
#####################################################################################################################


def printFasta (dict, output, basename):
    """
    Print the fasta file in a database independent way, unifying the most important aspects of all fasta sequences
    :param dict: Dictionary containing the fasta sequence and its information
    :param output: place where file should be placed with the attachment: "fasta_clean"
    :return: File with a clean version of the fasta file fed to create the dictionary. The format resembles the NCBI
    fasta format for identifiers but it is not recognized by my parser!
    """
    fileName = basename
    file = open(output+"/fasta_clean_"+fileName, "w+" )
    for key, value in dict.items():
        print (">" + key + " " + value[2] + "[" + value[0] + "]" + "\n" + value[1] , file= file)
    file.close()

def printFasta3 (dict, output, basename):
    """
    Print the fasta file in a database independent way, unifying the most important aspects of all fasta sequences
    :param dict: Dictionary containing the fasta sequence and its information
    :param output: place where file should be placed with the attachment: "fasta_clean"
    :return: File with a clean version of the fasta file fed to create the dictionary. The format resembles the NCBI
    fasta format for identifiers but it is not recognized by my parser!
    """
    fileName = basename
    file = open(output+"/fasta_clean_"+fileName, "w+" )
    for key, value in dict.items():
        print (">" + key + " " + value[2] + "[" + value[0] + "]" + "\n" + value[1] , file= file)
    file.close()

def printFasta2 (dict, output, basename, extension):
    """
    Print the fasta file in a database independent way, unifying the most important aspects of all fasta sequences
    :param dict: Dictionary containing the fasta sequence and its information
    :param output: place where file should be placed with the attachment: "fasta_clean"
    :param extension: The end value to be added to the file.
    :return: File with a clean version of the fasta file fed to create the dictionary. The format resembles the NCBI
    fasta format for identifiers but it is not recognized by my parser!
    """
    fileName = basename
    file = open(output+"/"+fileName+extension, "w+")
    for key, value in dict.items():
        print (">" + key + " " + value[2] + "[" + value[0] + "]" + "\n" + value[1] , file= file)
    file.close()


def printFasta3 (dict, output, basename):
    """
    Print the fasta file in a database independent way, unifying the most important aspects of all fasta sequences
    :param dict: Dictionary containing the fasta sequence and its information
    :param output: place where file should be placed with the attachment: "fasta_clean"
    :return: File with a clean version of the fasta file fed to create the dictionary. The format resembles the NCBI
    fasta format for identifiers but it is not recognized by my parser!
    """
    fileName = basename
    file = open(output+"/"+fileName+"_clean.fasta", "w+" )
    for key, value in dict.items():
        print (">" + key + " " + value[2] + "[" + value[0] + "]" + "\n" + value[1] , file= file)
    file.close()