compute_FPCscores <- function(fdObj, fpcaObj, nPC) {
  # computes FPC scores of a curve
  
  # fdObj: the curve is represented as fd object; only ONE curve, but with any number of dimensions
  # fpcaObj: an object of class pca.fd, typically obtained by running pca.fd()
  # nPC: the number of pc scores you want to compute, mininum 1 (the first), maximum all the ones available in fpcaObj
  #
  # The input curve fdObj may or may not be part of the data used to compute fpcaObj. 
  # If it is, you should obtain values close to the original PC scores already available from fpcaObj.
  # Typically it is not, as this is a way to parametrise a new curve based on an existing PCA model.
  if (is.matrix(fpcaObj$meanfd$coefs)) { # 1D curve
    inprod(fdObj - fpcaObj$meanfd, fpcaObj$harmonics[1:nPC]) %>% as.numeric
  } else { # multi-D curve
    nDim <- dim(fpcaObj$meanfd$coefs)[3]
    sapply(1:nPC, function(pc) {
      sapply(1:nDim, function(dimInd) {
        inprod(fd(coef = fdObj$coefs[, dimInd] - fpcaObj$meanfd$coefs[, 1, dimInd], basisobj = fdObj$basis),
               fpcaObj$harmonics[pc,dimInd])
      }) %>% sum
    }, simplify = TRUE)
  }
}