library(tidyverse)
library(ggforce)
library(gridExtra)


tibble(
  group      = c ("A", "B"),
  centroid_x = c (2.5, 5.5),
  centroid_y = c (5.5, 2.5),
  radius_a   = c (3, 2),
  radius_b   = c (1, 1),
  angle      = c (1/8, 3/8) * 2*pi # 1/4 multiplied by 2*pi is a quarter turn
) %>% 
  ggplot() +
  aes (x = centroid_x, y = centroid_y) +
  
  # Draw coordinate system
  coord_fixed(xlim = c(0, 8),
              ylim = c(0, 8),
              expand = FALSE) +
  geom_vline(xintercept = 0) +
  geom_hline(yintercept = 0) +
  theme(panel.background = element_rect(fill = 'transparent'),
        text = element_text(size = 14)) +
  
  # Draw axis labels and legend
  scale_x_continuous(breaks = NULL, name = "Acoustic feature 1") +
  scale_y_continuous(breaks = NULL, name = "Acoustic feature 2") +
  scale_fill_discrete(name = "Category") +
  ggtitle(label = "2-dimensional example") +
  
  # Draw data
  geom_ellipse(aes(x0 = centroid_x,
                   y0 = centroid_y,
                   a = radius_a,
                   b = radius_b,
                   angle = angle,
                   fill = group)) +
  geom_point() +
  geom_line(linetype = 2) -> p1


tibble(
  group      = c ("A", "B"),
  centroid_x = c (2, 8),
  centroid_y = c (0.5, 0.5),
  radius_a   = c (1.5, 4.5)
) %>%
  ggplot() +
  aes (x = centroid_x, y = centroid_y) +
  
  # Draw coordinate system
  coord_fixed(xlim = c(0, 12),
           #   ylim = c(0, 8),
              expand = FALSE) +
  #geom_vline(xintercept = 0) +
  geom_hline(yintercept = 0) +
  theme(panel.background = element_rect(fill = 'transparent'),
        text = element_text(size = 14)) +
  
  # Draw axis labels and legend
  scale_x_continuous(breaks = NULL, name = "Acoustic feature 1") +
  scale_y_continuous(breaks = NULL, name = "") +
  scale_fill_discrete(name = "Category") +
  ggtitle(label = "1-dimensional example") +
  
  # Draw data
  geom_tile(aes (x = centroid_x,
                 y = centroid_y,
                 width = radius_a,
                 height = 1,
                 fill = group),
            color = "black") +
  geom_point() +
  geom_line(linetype = 2) -> p2


png ("figure1.png", width=4800, height=5348, res = 600)
grid.arrange(p2, p1,
             ncol = 1,
             nrow = 2,
             heights = c(843, 2962))
dev.off()
