/*! https://www.geldkunstnetz.gwi.uni-muenchen.de/wp-content/plugins/gkn_transcription-tool/js/edition.js?ver=1.0.0 ursprünglicher Link */

/**
 * Displaying the digital edition of the Accountats Books
 *
 * a Book consists of: multiple Pages
 * a Page consists of: multiple Entries
 * a Entry consists of: Tokens
 *
 * Processing Steps From Tokes to Book Visualization:
 *
 * 1. Data is fetched from server in form of Tokens
 * 2. Each token is looped sequentially then is added to an entry (represented by HTML <tr>) and a page (represented by HTML <table>)
 * 3. HTML Tables has 3 Columns: Date, Book entry text and Sum (sum contains 3 <td>: for the 3 currencies)
 * 4. Each Token is a <span> with accociated class and data attributes
 */

/**
 * Global Variables.
 */

var page_data;
var books_data;
var current_book_id = 2;
var folio_nr;
var book_id;


/**
 * global variables for Loading Book Pages.
 * A Sort of Pagination, because loading multiple pages takes time to be processed.
 */
var data_to_load = [];
var index_to_load;
var initial_data_load = true;
var load_previous_index;
var load_previous_index_end;
var min_index;
var max_index;
var load_start_page = 0;
var load_end_page = 20;

/**
 * Initialize Page.
 * Look for URL Params for book id and folio nr, then get data to display the book with specified folio nr.
 * Else load data from first Book.
 */
jQuery(document).ready(function() {

  var url_string = window.location.href;
  var url = new URL(url_string);
  book_id = url.searchParams.get("book");
  folio_nr = url.searchParams.get("folio");

  console.log(book_id + " " + folio_nr);

  get_books_data(function(page_data) {

    jQuery('.book_pages').removeClass('show')
    if (!book_id) book_id = current_book_id
    jQuery('#book_' + book_id).addClass('show')

    if (folio_nr && book_id) {

      data_to_load = []
      for (var page in page_data) {
        if (page_data[page].book_id == book_id) {
          data_to_load.push(page_data[page].page_id)
        }
      }

      current_book_id = book_id
      index_to_load = get_page_index(folio_nr, current_book_id);

      load_start_page = index_to_load - 5;
      load_end_page = parseInt(index_to_load) + 5;

      if (load_start_page < min_index) load_start_page = min_index;
      if (load_end_page > max_index) load_end_page = max_index;

      console.log("Start INDEX: " + load_start_page);
      console.log("End INDEX: " + load_end_page);

      get_token_data(book_id, data_to_load.slice(load_start_page, load_end_page), "append", function() {

        load_previous_index = load_start_page;

        load_start_page = load_end_page;

        if (load_start_page < min_index) load_start_page = min_index;

      });



    } else if (book_id) {
      load_new_book(book_id)
    } else {
      load_new_book(current_book_id)
      // console.log("Start INDEX: " + load_start_page);
      // console.log("End INDEX: " + load_end_page);

      // get_token_data(current_book_id, data_to_load.slice(load_start_page, load_end_page), "append", function() {

      //   load_previous_index = load_start_page;

      //   load_start_page = load_end_page;
      //   load_end_page += 10;

      //   if (load_start_page < min_index) load_start_page = min_index;
      //   if (load_end_page > max_index) load_end_page = max_index;

      // });


    }

  });
})

/**
 * get page index according to the folio nr.
 * needed to load speficif page, when only folio nr and not id are available.
 * @param  {[type]} folio_nr [description]
 * @param  {[type]} book_id  [description]
 * @return {[type]}          [description]
 */
function get_page_index(folio_nr, book_id) {
  var i = 1;
  var page_index;

  for (var page in page_data) {
    if (page_data.hasOwnProperty(page)) {
      if (book_id == page_data[page].book_id) {
        if (page_data[page].folie_nr == folio_nr) {
          page_index = i;
          return page_index
        }
        i++;
      }

    }
  }

  return page_index;
}

/**
 * Gets Books Names and Pages (e.g. Folios) to be filled in the left side menu for book navigation.
 * @param  {[type]} display_book_pages_callback [description]
 */
function get_books_data(display_book_pages_callback) {
  jQuery.ajax({
    url: ajax_object.ajax_url,
    type: 'POST',
    data: {
      action: 'get_books_data'
    },
    success: function(response) {
      books_data_json = JSON.parse(response);
      page_data = books_data_json.page_data;
      books_data = books_data_json.books_data;

      console.log(books_data_json)

      books_data_json.books_data.map(function(book) {

        var book_container = jQuery("<div class='card card-default' ></div>")

        var heading = jQuery('<div class="card-heading">')
        var title = jQuery('<h6 class="card-title">').css('text-align', 'center')

        var edited_book_name = book.book_name.replace("R_Vv", "R/Vv")
        edited_book_name += " " + book.book_time_period

        var book_heading = jQuery("<a class='menu_book_title' data-toggle='collapse' data-parent='#book_list' aria-expanded='true' aria-controls=book_" + book.book_id + "></a>")
          .text(edited_book_name)
          .data("target", "#book_" + book.book_id)
        // .attr("href", "#book_" + book.book_id)

        var book_el = jQuery("<ul class='panel-collapse collapse in panel-body' ></ul>")
          .attr("id", "book_" + book.book_id)
          .addClass("book_pages")
          .data("book_id", book.book_id)

        book_heading.on("click", function() {
          console.log(book.book_id)
          if (current_book_id != book.book_id) {
            load_new_book(book.book_id)
            // book_container.collapse('show')
          }
        })

        heading.append(title)
        title.append(book_heading)

        book_container.append(heading)
        book_container.append(book_el)

        jQuery('#book_list').append(book_container)
      })

      console.log(page_data)

      for (var page in page_data) {
        if (page_data.hasOwnProperty(page)) {
          if (page_data[page].book_id == current_book_id) {

            var page_el = jQuery("<li></li>").data("folio_nr", page_data[page].folie_nr).text(page_data[page].folie_nr); // "page_" + page_data[page].page_id
            jQuery("#book_" + page_data[page].book_id).append(page_el);
            jQuery("#book_" + page_data[page].book_id).addClass('show')
            data_to_load.push(page_data[page].page_id);
          } else {
            var page_el = jQuery("<li></li>").data("folio_nr", page_data[page].folie_nr).text(page_data[page].folie_nr); // "page_" + page_data[page].page_id
            jQuery("#book_" + page_data[page].book_id).append(page_el);
          }
        }
      }

      min_index = 0;
      max_index = data_to_load.length;

      display_book_pages_callback(page_data);
    }
  });

}

function load_new_book(book_id) {


  // var url_string = window.location.href;
  // console.log(book_id)

  // var url = new URL(url_string);
  // book_id = url.searchParams.get("book");

  window.history.pushState("", "", location.protocol + '//' + location.host + location.pathname + "?book=" + book_id);


  // load new book pages
  jQuery('.book_pages').removeClass('show')
  jQuery('#book_' + book_id).addClass('show')

  current_book_id = book_id

  index_to_load = 0;

  data_to_load = []

  load_start_page = 0
  load_end_page = 10

  if (load_start_page < min_index) load_start_page = min_index
  if (load_end_page > max_index) load_end_page = max_index

  for (var page in page_data) {
    if (page_data[page].book_id == current_book_id) {
      data_to_load.push(page_data[page].page_id)
    }
  }

  min_index = 0
  max_index = data_to_load.length

  get_token_data(current_book_id, data_to_load.slice(load_start_page, load_end_page), "newbook", function() {


    load_previous_index = load_start_page;

    load_start_page = load_end_page;
    load_end_page += 10;

    if (load_start_page < min_index) load_start_page = min_index;
    if (load_end_page > max_index) load_end_page = max_index;

    console.log(books_data)
    current_book_data = books_data.find(function(book) {
      return book.book_id == current_book_id
    })

    var book_name = current_book_data.book_name.replace("R_Vv", "R/Vv")

    var book_title_h = jQuery("<h4 id='book_title'>").html(book_name + "<br>" + current_book_data.book_time_period)
    jQuery('#book_container').prepend(book_title_h)

    jQuery([document.documentElement, document.body]).animate({
      scrollTop: jQuery("#book_title").offset().top - 75
    }, 1750);

    jQuery('#load_previous').remove()

  });
}

/**
 * Gets all token data associated to a specific list of pages.
 * When successful callbacks to the token preprocessing and eventual display of the page data.
 * @param  {[type]} book_id                   [description]
 * @param  {[type]} page_id_list              [description]
 * @param  {[type]} possition_to_add          [description]
 * @param  {[type]} function_success_callback [description]
 * @return {[type]}                           [description]
 */
function get_token_data(book_id, page_id_list, possition_to_add, function_success_callback) {
  // console.log("book_id: " + book_id)
  // console.log("page_id_list: ")
  // console.log(page_id_list)
  // console.log("possition_to_add: " + possition_to_add)

  // console.log(page_id_list);
  if (page_id_list.length > 0) {

    jQuery("#book_container").append(jQuery("<div class='loader'></div>"));

    page_id_list = "(" + page_id_list.join(',') + ")";
    jQuery.ajax({
      url: ajax_object.ajax_url,
      type: 'POST',
      data: {
        action: 'get_book_data',
        page_id_list: page_id_list,
        book_id: book_id,
        possition_to_add: possition_to_add
      },
      success: function(response) {
        token_data = JSON.parse(response);
        display_book_data(token_data, possition_to_add);
        register_action_clicks();

        function_success_callback();
        jQuery(".loader").remove();
      }
    });
  } else {
    register_action_clicks();
  }
  enable_loading();
}

/**
 * Renders the Token data in form of Tables.
 * Each token is looped and according to its attributes is asigned to a specific entry and page.
 * Each entry is a Table Row <tr>
 * Each page is a Table
 * Each Table Column encapsules specific information:
 * 1. Day
 * 2. Entry Text
 * 3. Sum
 *
 * Tokens are <spam> elements that have their own attributes (data, id, class)
 *
 * @param  {[type]} token_data       [description]
 * @param  {[type]} possition_to_add [description]
 * @return {[type]}                  [description]
 */
function display_book_data(token_data, possition_to_add) {
  var last_el_id;

  var cur_entry_nr;
  var cur_page_nr;

  var cur_page_number = 1;

  if (possition_to_add == "newbook") {
    jQuery("#book_container").empty()
  }

  for (var i = 0; i < token_data.length; i++) {

    cur_token = token_data[i];

    cur_entry_nr = cur_token.entry_id;

    cur_page_nr = cur_token.page_nr;

    var new_line = false;

    if (String(cur_token.token).indexOf("|") >= 0) {
      new_line = true;
      cur_token.token = cur_token.token.replace("|", "");
    } else {
      new_line = false;
    }

    //entry
    if (jQuery("." + cur_entry_nr).length) {

      var entry = jQuery("." + cur_entry_nr);
      var token_string = String(cur_token.token);
      var token = jQuery('<span></span>');

      var date_row = entry.find('.date'); // jQuery("<td class='date'></td>");
      var text_row = entry.find('.text'); //jQuery("<td class='text'></td>");
      var sum_row = entry.find('.sum_row').find('.sum'); //jQuery("<td class='sum'></td>");

      if (cur_token.tageszahl == "1") {

        date_row.append(token.text(String(cur_token.token) + " "));

      } else if (cur_token.gulden == "1") {
        sum_row.find(".gulden_td").append(token.text(String(cur_token.token) + " "));
      } else if (cur_token.groschen == "1") {
        sum_row.find(".groschen_td").append(token.text(String(cur_token.token) + " "));
      } else if (cur_token.pfenning == "1") {
        sum_row.find(".pfenning_td").append(token.text(String(cur_token.token) + " "));
      } else {

        if (last_el_id != cur_token.entry_object_id) {
          text_row.append("&nbsp;");
          text_row.append(token.text(String(cur_token.token)));
        } else {
          text_row.append(token.text(" " + String(cur_token.token)));
        }

        last_el_id = cur_token.entry_object_id;
      }

      if (cur_token.gulden != "1") sum_row.find(".gulden_td").append(" ");
      if (cur_token.groschen != "1") sum_row.find(".groschen_td").append(" ");
      if (cur_token.pfenning != "1") sum_row.find(".pfenning_td").append(" ");

    } else {

      var entry = jQuery("<tr></tr>");
      var token = jQuery('<span></span>');

      var date_row = jQuery("<td class='date'></td>");
      var text_row = jQuery("<td class='text'></td>");
      var sum_row = jQuery("<td class='sum_row'><table id='no_style_table' class='no_outher_border_table'><tr class='sum'><td class='gulden_td'></td><td class='groschen_td'></td><td class='pfenning_td'></td></tr></table></td>");

      entry.append(date_row);
      entry.append(text_row);
      entry.append(sum_row);

      if (cur_token.tageszahl == "1") {
        date_row.append(token.text(String(cur_token.token) + " "));
      } else if (cur_token.gulden == "1") {
        sum_row.find('.sum').find(".gulden_td").append(token.text(String(cur_token.token) + " "));
      } else if (cur_token.groschen == "1") {
        sum_row.find('.sum').find(".groschen_td").append(token.text(String(cur_token.token) + " "));
      } else if (cur_token.pfenning == "1") {
        sum_row.find('.sum').find(".pfenning_td").append(token.text(String(cur_token.token) + " "));
      } else {

        if (last_el_id != cur_token.entry_object_id) {
          text_row.append("&nbsp;");
          text_row.append(token.text(String(cur_token.token)));
        } else {
          text_row.append(token.text(" " + String(cur_token.token)));
        }

        last_el_id = cur_token.entry_object_id;
      }

      if (cur_token.gulden != "1") sum_row.find(".gulden_td").append("&nbsp;");
      if (cur_token.groschen != "1") sum_row.find(".groschen_td").append("&nbsp;");
      if (cur_token.pfenning != "1") sum_row.find(".pfenning_td").append("&nbsp;");

      entry.attr("class", cur_entry_nr + " " + "entry");

      if (cur_token.seitentitel == "1") {
        entry.addClass("seitentitel")
      }

      jQuery("." + cur_page_nr).append(entry); //
    }

    if (new_line) {
      token.append(jQuery("<br>"));
    }

    token = attach_token_attr(token, cur_token);

    if (cur_token.seitentitel == "1") {
      entry.addClass("seitentitel")
    }


    //page
    if (jQuery("#" + cur_page_nr).length) {

      var page = jQuery("#" + cur_page_nr);

      page.append(entry);

    } else {
      var page_nr_div = jQuery("<div></div>").text("Folio " + page_data[cur_token.page_nr].folie_nr).attr("id", page_data[cur_token.page_nr].folie_nr); //  folie_nr
      var table_container = jQuery("<div class='table_container'></div>");
      var page = jQuery("<table></table>");
      var image_container = jQuery("<div class='scan_img_container'></div>");
      var scan_img = jQuery("<img class='scan_img'></img>");

      var book_name = books_data.find(function(book) {
        return book.book_id == page_data[cur_token.page_nr].book_id
      }).book_name


      image_container.append(scan_img);

      var page_scan = jQuery("<div class='scan_container'></div>");
      page_scan.append(page_data[cur_token.page_nr].folie_nr);

      page.attr("id", cur_page_nr);
      page.attr("class", "book_page");

      var scan_name = page_data[cur_token.page_nr].page_name.replace(".jpg", "");
      var src = window.origin + "/wp-content/uploads/" + book_name + "/" + scan_name + "-150x150.jpg";
      scan_img.attr("src", src);
      scan_img.attr("data-page_id", cur_token.page_nr)

      page.append(entry);


      table_container.append(page);
      table_container.append(image_container);
      switch (possition_to_add) {
        case "append":
          jQuery("#book_container").append(table_container);
          break;
        case "prepend":
          jQuery("#book_pages_before").append(table_container);
          break;
        case "newbook":
          jQuery("#book_container").append(table_container);
          break;
      }

      page_nr_div.insertBefore(page);
    }

  }

  if (possition_to_add == "prepend") {
    jQuery("#book_container").prepend(jQuery("#book_pages_before").children());
    jQuery("#book_pages_before").empty();
  }

  // additional processing of the html elements: adding footnote display
  process_entries();

  jQuery("#book_container").show();


  jQuery("#load_previous").remove();
  load_previous_btn = jQuery("<button id='load_previous' class='btn btn-default'>vorherige Seiten</button>")
  jQuery("#book_container").prepend(load_previous_btn);


  jQuery("#load_more").remove();
  load_more_btn = jQuery("<button id='load_more' class='btn btn-default' >nÃ¤chste Seiten</button>")
  jQuery("#book_container").append(load_more_btn);

  if (initial_data_load) {
    setTimeout(function() {
      scrollToFolio();
      initial_data_load = false;
    }, 1000);

  }

  register_action_clicks();

}

/**
 * Scrolls HTML Page to a specific Folio.
 * @return {[type]} [description]
 */
function scrollToFolio() {
  if (folio_nr) {
    if (jQuery('#' + folio_nr).length > 0) {
      var scroll = jQuery('#' + folio_nr).offset().top - 120;
      jQuery(document).scrollTop(scroll);
    }

  }
}

/**
 * Attach data attributes and classes to objects, person, location Tokens.
 * @param  {[type]} token        [description]
 * @param  {[type]} token_object [description]
 * @return {[type]}              [description]
 */
function attach_token_attr(token, token_object) {

  if (token_object.entry_attribute == "Tageszahl") {
    token.addClass("tageszahl");
  }

  if (token_object.seitentitel == "1") {
    token.addClass("seitentitel")
  }

  if (token_object.person == "1") {
    token.addClass("person");
    token.attr("data-entry_object_id", token_object.entry_object_id);
  }

  if (token_object.ort == "1") {
    token.addClass("location");
    token.attr("data-entry_object_id", token_object.entry_object_id);
  }

  if (token_object.objekt == "1") {
    token.addClass("object");
    token.attr("data-entry_object_id", token_object.entry_object_id);
  }

  if (token_object.groschen == "1") {
    token.addClass("groschen");
  }

  if (token_object.gulden == "1") {
    token.addClass("gulden");
  }

  if (token_object.pfenning == "1") {
    token.addClass("pfenning");
  }

  // if (token_object.token == "") {
  //   token.append("&nbsp;");
  // }

  if (token_object.durchgestrichen == "1") {
    token.addClass("durchgestrichen");
  }

  if (token_object.hochgestellt == "1") {
    token.addClass("hochgestellt");
  }

  if (token_object.unleserlich == "1") {
    token.addClass("unleserlich");
  }

  if (token_object.fremdhaendig == "1") {
    token.addClass("fremdhaendig");
  }

  if (token_object.zwischenzeile == "1") {
    token.addClass("zwischenzeile");
  }

  if (token_object.summa == "1") {
    token.addClass("summa");
  }

  if (token_object.mark == "1") {
    token.addClass("mark");
  }

  if (token_object.humanistica == "1") {
    token.addClass("humanistica");
  }

  if (token_object.textkritik == "1") {
    token.addClass("textkritik");
  }

  if (token_object.erlaeuterung == "1") {
    token.addClass("erlaeuterung");
  }

  if (token_object.uebersetzung == "1") {
    token.addClass("uebersetzung");
  }

  if (token_object.archivarsnotiz == "1") {
    token.addClass("archivarsnotiz");
  }

  return token;
}

/**
 * Register event handlers.
 * Handles Event for the Pagination Logic:
 * 1. Clicked Folio on the left Menu.
 * 2. Clicked Next/Previous Pages.
 *
 */
function register_action_clicks() {

  jQuery(".person").unbind();
  jQuery(".location").unbind();
  jQuery(".object").unbind();
  jQuery(".erlaeuterung").unbind();
  jQuery(".scan_img").unbind();
  jQuery(".book_pages li").unbind();
  jQuery("#load_more").unbind();
  jQuery("#load_previous").unbind();
  jQuery(".card").unbind();

  jQuery(".person").on("click", function() {
    hide_fullsize_img();

    var person_id = jQuery(this).data("entry_object_id");

    //var cur_person = get_single_person(person_id);

    if (jQuery(this).hasClass("erlaeuterung")) {
      console.log("Object Has extra class");
      footnote = jQuery(this).find('.footnote');

      clear_info_div();

      var cur_person = get_single_person(person_id, true);
      populate_info_div(footnote.attr('title'), "erlaeuterung", true);

    } else {
      var cur_person = get_single_person(person_id, false);
    }

  });

  jQuery(".location").on("click", function() {
    hide_fullsize_img();

    var ort_id = jQuery(this).data("entry_object_id");

    // var cur_location = get_single_location(ort_id);

    if (jQuery(this).hasClass("erlaeuterung")) {
      console.log("Object Has extra class");
      footnote = jQuery(this).find('.footnote');

      clear_info_div();

      var cur_location = get_single_location(ort_id, true);
      populate_info_div(footnote.attr('title'), "erlaeuterung", true);

    } else {
      var cur_location = get_single_location(ort_id, false);
    }


  });

  jQuery(".object").on("click", function() {
    console.log("OBJECT KLICKED");

    hide_fullsize_img();

    var object_id = jQuery(this).data("entry_object_id");

    if (jQuery(this).hasClass("erlaeuterung")) {
      console.log("Object Has extra class");
      footnote = jQuery(this).find('.footnote');

      clear_info_div();

      var cur_object = get_single_object(object_id, true);
      populate_info_div(footnote.attr('title'), "erlaeuterung", true);

    } else {
      var cur_object = get_single_object(object_id, false);
    }


  });

  // jQuery(".erlaeuterung").on("click", function() {
  //   console.log("FOOTNOTE KLICKED");
  //   hide_fullsize_img();
  //   var additional_data;

  //   var footnote = jQuery(this).find('.footnote')

  //   var object_id = jQuery(this).data("entry_object_id");

  //   if (jQuery(this).hasClass("person") || jQuery(this).hasClass("object") || jQuery(this).hasClass("location")) {

  //   } else {
  //     console.log("Footnote Has NO class");
  //     populate_info_div(footnote.attr('title'), "erlaeuterung", false);
  //   }

  // });

  jQuery(".scan_img").on("click", function() {
    clear_info_div();

    jQuery('.scan_img').css('display', 'block');
    jQuery('#focused_scan_container').remove();

    var page_id = jQuery(this).data("page_id");

    var book_name = books_data.find(function(book) {
      return book.book_id == page_data[page_id].book_id
    }).book_name

    var scan_name = page_data[page_id].page_name.replace(".jpg", "");
    var src = window.origin + "/wp-content/uploads/" + book_name + "/" + scan_name + ".jpg"; // + "-150x150.jpg";
    var scan_to_focus = jQuery("<img></img>");
    scan_to_focus.attr("src", src);
    scan_to_focus.attr("id", "focused_scan");

    var img_scroll_container = jQuery("<div id='focused_scan_container'></div>");
    img_scroll_container.append(scan_to_focus);

    jQuery(this).parent().append(img_scroll_container);
    jQuery(this).hide();
    wheelzoom(scan_to_focus); // document.querySelector('#current_page')

  })

  //Folio Click
  jQuery(".book_pages li").on("click", function() {
    disable_loading();

    var scrollTo = "#" + jQuery(this).data("folio_nr");
    console.log(scrollTo);

    jQuery(".selected_folio").removeClass("selected_folio");
    jQuery(this).addClass("selected_folio");

    folio_nr = jQuery(this).data("folio_nr");
    book_nr = jQuery(this).parent().data("book_id")
    initial_data_load = true;

    if (current_book_id != book_nr) {
      // load new book pages
      jQuery('.book_pages').removeClass('show')
      jQuery('#book_' + book_nr).addClass('show')

      current_book_id = book_nr

      index_to_load = get_page_index(jQuery(this).data("folio_nr"), current_book_id);

      data_to_load = []

      load_start_page = index_to_load - 5
      load_end_page = index_to_load + 5

      if (load_start_page < min_index) load_start_page = min_index
      if (load_end_page > max_index) load_end_page = max_index

      for (var page in page_data) {
        if (page_data[page].book_id == current_book_id) {
          data_to_load.push(page_data[page].page_id)
        }
      }

      min_index = 0
      max_index = data_to_load.length

      console.log("LOADING NEW BOOK")

      console.log("Start INDEX: " + load_start_page);
      console.log("End INDEX: " + load_end_page);

      get_token_data(current_book_id, data_to_load.slice(load_start_page, load_end_page), "newbook", function() {


        load_previous_index = load_start_page;

        load_start_page = load_end_page;
        load_end_page += 10;

        if (load_start_page < min_index) load_start_page = min_index;
        if (load_end_page > max_index) load_end_page = max_index;

      });

    } else {
      // load pages from same book
      if (jQuery(scrollTo).length) {
        var scroll = jQuery(scrollTo).offset().top - 120;
        jQuery(document).scrollTop(scroll);

        window.history.pushState("", "", location.protocol + '//' + location.host + location.pathname + "?folio=" + jQuery(this).data("folio_nr") + "&book=" + book_nr);

        enable_loading();
        register_action_clicks();
      } else {

        index_to_load = get_page_index(jQuery(this).data("folio_nr"), current_book_id);

        if (index_to_load <= load_start_page) {
          console.log("Start INDEX: " + index_to_load);
          console.log("End INDEX: " + load_previous_index);
          console.log("LOADING DATA TO PREPEND");
          var sliced_data = data_to_load.slice(index_to_load, load_previous_index);
          console.log(sliced_data);
          get_token_data(current_book_id, sliced_data, "prepend", function() {
            load_previous_index = index_to_load;
          });

        } else {
          console.log("Start INDEX: " + load_start_page);
          console.log("End INDEX: " + index_to_load);
          console.log("LOADING DATA TO APPEND");
          var sliced_data = data_to_load.slice(load_start_page, index_to_load);
          console.log(sliced_data);
          get_token_data(current_book_id, sliced_data, "append", function() {
            load_start_page = index_to_load;
          });


        }

        window.history.pushState("", "", location.protocol + '//' + location.host + location.pathname + "?folio=" + jQuery(this).data("folio_nr") + "&book=" + book_nr);

      }

    }


  })

  jQuery(".card").on("click", function() {
    // jQuery(".card").find("ul").collapse('hide');
    // jQuery(this).find("ul").collapse('show');
  })




  jQuery("#load_more").on('click', function() {
    disable_loading();

    load_end_page += 10;
    if (load_start_page < index_to_load) load_start_page = index_to_load;

    if (load_end_page <= load_start_page) load_end_page = load_end_page + 5
    if (load_end_page > max_index) load_end_page = max_index;

    console.log("Start INDEX: " + load_start_page);
    console.log("End INDEX: " + load_end_page);

    get_token_data(current_book_id, data_to_load.slice(load_start_page, load_end_page), "append", function() {

      load_start_page = load_end_page;

      console.log("LOADING DATA TO APPEND");
    });

  });

  jQuery("#load_previous").on('click', function() {
    disable_loading();

    load_previous_index_end = load_previous_index;

    if ((load_previous_index - 5) < 0) {
      load_previous_index = 0
    } else {
      load_previous_index = load_previous_index - 5
    }

    console.log("Start INDEX: " + load_previous_index);
    console.log("End INDEX: " + load_previous_index_end);

    get_token_data(current_book_id, data_to_load.slice(load_previous_index, load_previous_index_end), "prepend", function() {
      console.log("LOADING DATA TO PREPEND");
    });

  });

  // make top menu items fixed when scrolling
  jQuery(window).scroll(function(event) {
    var scroll = jQuery(window).scrollTop();

    if (scroll > 222) {
      jQuery("#book_menu").addClass("fixed_div_left");
      jQuery("#object_info").addClass("fixed_div_right");
      jQuery("#book_container").addClass("floating_menues");
    }

    if (scroll < 222) {
      jQuery("#book_menu").removeClass("fixed_div_left");
      jQuery("#object_info").removeClass("fixed_div_right");
      jQuery("#book_container").removeClass("floating_menues");
    }

  });


}

/**
 * Currently Disables Loading Buttons, while waiting for pages to be processed and displayed.
 */
function disable_loading() {
  jQuery(".book_pages li").unbind();

  jQuery("#load_more").prop("disabled", true);
  jQuery("#load_more").unbind();

  jQuery("#load_previous").prop("disabled", true);
  jQuery("#load_previous").unbind();
}

/**
 * Enables Page Loading Buttons.
 */
function enable_loading() {
  jQuery("#load_more").prop("disabled", false);
  jQuery("#load_previous").prop("disabled", false);
}

function clear_info_div() {
  jQuery("#object_info").empty();
}

/**
 * Adds information about specific Entity to the right menu (Only visible when clicked on a text element from the pages).
 * @param  {[type]} object_data     [description]
 * @param  {[type]} object_type     [description]
 * @param  {[type]} additional_data [description]
 */
function populate_info_div(object_data, object_type, additional_data) {

  if (!additional_data) {
    clear_info_div();
  }

  if (object_data) {
    switch (object_type) {
      case "location":
        display_location_data(object_data);
        break;
      case "person":
        display_person_data(object_data);
        break;
      case "object":
        display_object_data(object_data);
        break;
      case "erlaeuterung":
        var title = jQuery('<h4 class="obj_title"><b>ErlÃ¤uterung:</b> </h4>');
        var info_data = jQuery("<div></div>").append(object_data);
        break;
      default:
        var title = jQuery('<h4 class="obj_title"><b>Kein Objekt gefunden!</b>  </h4>');
        var info_data = jQuery("<div>Keine Informationen Vorhanden.</div>");
    }
  } else {
    var title = jQuery('<h4 class="obj_title"><b>Kein Objekt gefunden!</b> </h4>');
    var info_data = jQuery("<div>Keine Informationen Vorhanden.</div>");
  }

  jQuery("#object_info").append(title);
  jQuery("#object_info").append(info_data);
}

/**
 * Processing of a single page entry to enable the correct display of Footnotes as "[*]"
 * @param  {[type]} entry [description]
 */
function process_entry(entry) {
  //tesitng
  // var erlaeuterung_content = jQuery(this);
  // testing

  erlaeuterungen = entry.find('.erlaeuterung');

  text = "";

  var erlaeuterung_footnote = false;

  var footnote = jQuery("<span class = 'footnote'></span>").text("[*] ");

  erlaeuterungen.each(function(index) {
    erlaeuterung_text = jQuery(this).text();
    // console.log('erlaeuterung text:')
    // console.log(erlaeuterung_text)

    // WORKING BUT WITH ERRORS
    // if (erlaeuterung_text.indexOf("[") != -1 && erlaeuterung_text.indexOf("]") != -1) {
    //   text += jQuery(this).text();
    //   jQuery(this).hide();

    //   var footnote = jQuery("<span class = 'footnote'></span>").text("[*] ");


    //   if (erlaeuterung_content) {
    //     footnote.attr('title', text);
    //     erlaeuterung_content.append(footnote);
    //   }


    //   text = "";

    // } else if (erlaeuterung_text.indexOf("[") != -1) {
    //   erlaeuterung_footnote = true;
    //   text += jQuery(this).text();
    //   jQuery(this).hide();
    // } else if (!erlaeuterung_footnote) {
    //   erlaeuterung_content = jQuery(this);
    // } else if (erlaeuterung_footnote) {
    //   text += jQuery(this).text();
    //   jQuery(this).hide();
    // } else if (erlaeuterung_text.indexOf("]") != -1) {
    //   text += jQuery(this).text();
    //   jQuery(this).hide();

    //   var footnote = jQuery("<span class = 'footnote'></span>").text("[*] ");

    //   footnote.attr('title', text);
    //   erlaeuterung_content.append(footnote);

    //   text = "";
    //   erlaeuterung_footnote = false;
    // }
    //




    //TESTING OUT
    var erlaeuterung_content = jQuery("<span></span>").insertBefore(jQuery(this))

    if (erlaeuterung_text.indexOf("[") != -1 && erlaeuterung_text.indexOf("]") != -1) {
      text += jQuery(this).text();
      jQuery(this).hide();

      footnote = jQuery("<span class = 'footnote'></span>").text("[*] ");
      footnote.attr('title', text);
      erlaeuterung_content.append(footnote);

      text = "";
      erlaeuterung_footnote = false;
    } else if (erlaeuterung_text.indexOf("[") != -1) {
      erlaeuterung_footnote = true;
      text += jQuery(this).text();
      jQuery(this).hide();
    } else if (erlaeuterung_footnote) {
      text += jQuery(this).text();
      jQuery(this).hide();
    } else if (erlaeuterung_text.indexOf("]") != -1) {
      text += jQuery(this).text();
      jQuery(this).hide();

      footnote = jQuery("<span class = 'footnote'></span>").text("[*] ");

      footnote.attr('title', text);
      erlaeuterung_content.append(footnote);

      text = "";
      erlaeuterung_footnote = false;
    }

    footnote.on("click", function(){
      // console.log(footnote.attr('title'))
      populate_info_div(footnote.attr('title'), "erlaeuterung", false);
    })

  });
}

/**
 * Additional Processing of all entries to be displayed on the page.
 * @return {[type]} [description]
 */
function process_entries() {
  var entries = jQuery('.entry').filter(function() {
    return !(jQuery(this).hasClass('processed'));
  });
  // var erlaeuterung_content;

  entries.each(function(index) {
    var entry = jQuery(this);
    // console.log(entry)
    process_entry(entry);
    entry.addClass('processed');
  })

}

function hide_fullsize_img() {
  jQuery('.scan_img').css('display', 'block');
  jQuery('#focused_scan_container').remove();
}

/**
 * Display person data in the right floating menu.
 * @param  {[type]} object_data [description]
 */
function display_person_data(object_data) {
  var data_container = jQuery("<div></div>").attr("id", "data_container");
  var tbody = jQuery("<tbody></tbody>")

  var title = jQuery('<h4 class="obj_title"><b>Person:</b> </h4>');
  var name = jQuery('<tr><th scope="row" class="obj_info">Name: </th></tr>');
  var birth_date = jQuery('<tr><th scope="row" class="obj_info">Geburtsdatum: </th></tr>');
  var death_date = jQuery('<tr><th scope="row" class="obj_info">Sterbedatum: </th></tr>');
  var occupation_title = jQuery('<tr><th scope="row" class="obj_info">Beruf/Funktion: </th></tr>');


  name.append(jQuery("<div></div>").text(object_data.family_name + ", " + object_data.first_name));
  birth_date.append(jQuery("<div></div>").text(object_data.birth_date));
  death_date.append(jQuery("<div></div>").text(object_data.death_date));
  occupation_title.append(jQuery("<div></div>").text(object_data.occupation_title));

  tbody.append(name);
  tbody.append(birth_date);
  tbody.append(death_date);
  tbody.append(occupation_title);

  if (object_data['alternative_names'].length > 0) {
    var alt_names = jQuery('<tr><th scope="row" class="obj_info">Alternative Namen: </th></tr>')

    for (var i = 0; i < object_data['alternative_names'].length; i++) {
      alt_name = object_data['alternative_names'][i];
      alt_names.append(jQuery("<div></div>").text(alt_name.alternative_family_name + ", " + alt_name.alternative_first_name))
    }

    tbody.append(alt_names);
  }

  if (object_data['mention_years'].length > 0) {
    var mention_years = jQuery('<tr><th scope="row" class="obj_info">ErwÃ¤hnungsdatum: </th></tr>')

    for (var i = 0; i < object_data['mention_years'].length; i++) {
      mention_year = object_data['mention_years'][i];
      mention_years.append(jQuery("<div></div>").text(mention_year.entity_date))
    }

    tbody.append(mention_years);
  }

  if (object_data['sources'].length > 0) {
    var sources = jQuery('<tr><th scope="row" class="obj_info">Quellenfundstelle: </th></tr>')


    for (var i = 0; i < object_data['sources'].length; i++) {
      source = object_data['sources'][i];

      if (source.source_folie_nr) {
        sources.append(jQuery("<div></div>").text(source.source_folie_nr + ", " + source.source_book))
      }
    }

    if (source.source_text) {
      sources.append(jQuery("<div></div>").text(source.source_text))
    }

    tbody.append(sources);
  }

  if (object_data['bibliography'].length > 0) {
    var bibliographies = jQuery('<tr><th scope="row" class="obj_info">Bibliografien: </th></tr>')

    for (var i = 0; i < object_data['bibliography'].length; i++) {
      bib = object_data['bibliography'][i];

      bib_text = bib.abbreviation; // + ", " + bib.author_institution

      if (bib.volume) bib_text = bib_text + ", " + bib.volume;
      if (bib.page_from_to) bib_text = bib_text + ", " + bib.page_from_to;

      console.log(bib);

      bib_el = jQuery("<div></div>").text(bib_text).addClass("bib_el").attr("id", bib.bib_source_id);

      link_el = jQuery("<i  class='fas fa fa-link bib_link'></i>").attr("href", bib.url); // target='_blank'
      if (bib.url) bib_el.append(link_el);

      bibliographies.append(bib_el);

      register_bib_click(bib_el);
    }

    tbody.append(bibliographies);
  }

  data_container.append(title)
  data_container.append(tbody)

  jQuery("#object_info").append(data_container);

  data_container.css("max-height", jQuery(window).height() - 250);

  // jQuery("#object_info").append(title);
  // jQuery("#object_info").append(tbody);

  jQuery(".bib_link").off("click");
  jQuery(".bib_link").on('click', function(e) {
    e.stopPropagation();
    console.log("OPEN WIKI TAB");
    window.open(jQuery(this).attr('href'), '_blank');
  });

  remove_empty_elements();
}

/**
 * Get Bubliography Data to display in a modal.
 * @param  {[type]} jquery_el [description]
 */
function register_bib_click(jquery_el) {
  jquery_el.on("click", function() {
    console.log(jquery_el.attr("id"));
    bib_source_id = jquery_el.attr("id")

    jQuery.ajax({
      url: ajax_object.ajax_url,
      type: 'POST',
      data: {
        action: 'get_single_bibliography_edition',
        requested_bibliography_source_id: bib_source_id
      },
      success: function(response) {

        searched_bibliography = JSON.parse(response);
        console.log(searched_bibliography);
        populate_bibliography_edit_modal(searched_bibliography);
        //open bib_modal
      }
    });
  })
}

/**
 * Adds data to the bibliography modal.
 * @param  {[type]} bibliography [description]
 * @return {[type]}              [description]
 */
function populate_bibliography_edit_modal(bibliography) {

  jQuery("#m_bib_name").text("");
  jQuery('#m_author_institution').text("");
  jQuery('#m_part_of').text("");
  jQuery('#m_issued_by').text("");
  jQuery('#m_bib_location').text("");
  jQuery('#m_bib_year').text("");
  jQuery('#m_bib_volume').text("");
  jQuery('#m_bib_page_from_to').text("");
  jQuery('#m_bib_abbreviation').text("");
  jQuery('#m_bib_url').text("");


  jQuery('#m_bib_name').text(bibliography.bib_name);
  jQuery('#m_author_institution').text(bibliography.author_institution);
  jQuery('#m_part_of').text(bibliography.part_of);
  jQuery('#m_issued_by').text(bibliography.issued_by);
  jQuery('#m_bib_location').text(bibliography.location);
  jQuery('#m_bib_year').text(bibliography.year);
  jQuery('#m_bib_volume').text(bibliography.volume);
  jQuery('#m_bib_page_from_to').text(bibliography.pages);
  jQuery('#m_bib_abbreviation').text(bibliography.abbreviation);
  jQuery('#m_bib_url').text(bibliography.url);

  link_el = jQuery("<a target='blank'><i  class='fas fa fa-link bib_link'  ></i></a>").attr("href", bibliography.url); // target='_blank'
  if (bibliography.url) jQuery('#m_bib_url').prepend(link_el);


  console.log(bibliography);

  jQuery("#edit_bibliography_modal").modal();
}

/**
 * Display object data in the right floating menu.
 * @param  {[type]} object_data [description]
 */
function display_object_data(object_data) {
  var data_container = jQuery("<div></div>").attr("id", "data_container");
  var tbody = jQuery("<tbody></tbody>")

  var title = jQuery('<h4 class="obj_title"><b>Objekt:</b> </h4>');
  var name = jQuery('<tr><th scope="row" class="obj_info">Name: </th></tr>');
  var object_term = jQuery('<tr><th scope="row" class="obj_info">Objekt Bezeichnung: </th></tr>');
  var object_type = jQuery('<tr><th scope="row" class="obj_info">Objekttyp: </th></tr>');
  var object_value = jQuery('<tr><th scope="row" class="obj_info">Wert: </th></tr>');
  var object_amount = jQuery('<tr><th scope="row" class="obj_info">Menge: </th></tr>');
  var description = jQuery('<tr><th scope="row" class="obj_info">Beschreibung: </th></tr>');
  var obj_function = jQuery('<tr><th scope="row" class="obj_info">Funktion: </th></tr>');
  var material = jQuery('<tr><th scope="row" class="obj_info">Material: </th></tr>');
  var technique = jQuery('<tr><th scope="row" class="obj_info">Technique: </th></tr>');

  if (object_data.object_amount == 0) {
    obj_amount = "";
  } else {
    obj_amount = object_data.object_amount;
  }

  name.append(jQuery("<div></div>").text(object_data.object_name));
  object_term.append(jQuery("<div></div>").text(object_data.object_term));
  object_type.append(jQuery("<div></div>").text(object_data.object_type));
  object_value.append(jQuery("<div></div>").text(object_data.object_value));
  object_amount.append(jQuery("<div></div>").text(obj_amount));
  description.append(jQuery("<div></div>").text(object_data.description));
  obj_function.append(jQuery("<div></div>").text(object_data.function));
  material.append(jQuery("<div></div>").text(object_data.material));
  technique.append(jQuery("<div></div>").text(object_data.technique));

  tbody.append(name);
  tbody.append(object_term);
  tbody.append(object_type);
  tbody.append(object_value);
  tbody.append(object_amount);
  tbody.append(description);
  tbody.append(obj_function);

  if (object_data['alternative_names'].length > 0) {
    var alt_names = jQuery('<tr><th scope="row" class="obj_info">Alternative Namen: </th></tr>')

    for (var i = 0; i < object_data['alternative_names'].length; i++) {
      alt_name = object_data['alternative_names'][i];
      alt_names.append(jQuery("<div></div>").text(alt_name.alternative_first_name))
    }

    tbody.append(alt_names);
  }

  if (object_data['mention_years'].length > 0) {
    var mention_years = jQuery('<tr><th scope="row" class="obj_info">ErwÃ¤hnungsdatum: </th></tr>')

    for (var i = 0; i < object_data['mention_years'].length; i++) {
      mention_year = object_data['mention_years'][i];
      mention_years.append(jQuery("<div></div>").text(mention_year.entity_date))
    }

    tbody.append(mention_years);
  }

  console.log(object_data.sources);

  if (object_data['sources'].length > 0) {
    var sources = jQuery('<tr><th scope="row" class="obj_info">Quellenfundstelle: </th></tr>')

    for (var i = 0; i < object_data['sources'].length; i++) {
      source = object_data['sources'][i];

      if (source.source_folie_nr) {
        sources.append(jQuery("<div></div>").text(source.source_folie_nr + ", " + source.source_book))
      }

      if (source.source_text) {
        sources.append(jQuery("<div></div>").text(source.source_text))
      }

    }

    tbody.append(sources);
  }

  if (object_data['bibliography'].length > 0) {
    var bibliographies = jQuery('<tr><th scope="row" class="obj_info">Bibliografien: </th></tr>')

    for (var i = 0; i < object_data['bibliography'].length; i++) {
      bib = object_data['bibliography'][i];

      bibliographies.append(jQuery("<div></div>").text(bib.abbreviation + ", " + bib.author_institution));

    }
    tbody.append(bibliographies);
  }

  data_container.append(title)
  data_container.append(tbody)

  jQuery("#object_info").append(data_container);

  data_container.css("max-height", jQuery(window).height() - 250);

  // jQuery("#object_info").append(title);
  // jQuery("#object_info").append(tbody);

  remove_empty_elements();
}

/**
 * Display location data in the right floating menu.
 * @param  {[type]} object_data [description]
 */
function display_location_data(object_data) {
  var data_container = jQuery("<div></div>").attr("id", "data_container");
  var tbody = jQuery("<tbody></tbody>");

  var title = jQuery('<h4 class="obj_title"><b>Ort:</b> </h4>');
  var name = jQuery('<tr><th scope="row" class="obj_info">Name: </th></tr>');
  var additional_names = jQuery('<tr><th scope="row" class="obj_info">Alternativer Name (aktuell): </th></tr>');
  var book_context = jQuery('<tr><th scope="row" class="obj_info">Kontext in Buch: </th></tr>');
  var current_german_name = jQuery('<tr><th scope="row" class="obj_info">Aktueller deutscher Name: </th></tr>');

  name.append(jQuery("<div></div>").text(object_data.in_book_name));
  additional_names.append(jQuery("<div></div>").text(object_data.alternative_current_name));
  book_context.append(jQuery("<div></div>").text(object_data.book_context));
  current_german_name.append(jQuery("<div></div>").text(object_data.current_german_name));

  tbody.append(name);
  tbody.append(additional_names);
  tbody.append(book_context);
  tbody.append(current_german_name);

  if (object_data['alternative_names'].length > 0) {
    var alt_names = jQuery('<tr><th scope="row" class="obj_info">Alternative Namen: </th></tr>')

    for (var i = 0; i < object_data['alternative_names'].length; i++) {
      alt_name = object_data['alternative_names'][i];
      alt_names.append(jQuery("<div></div>").text(alt_name.alternative_first_name))
    }

    tbody.append(alt_names);
  }

  if (object_data['mention_years'].length > 0) {
    var mention_years = jQuery('<tr><th scope="row" class="obj_info">ErwÃ¤hnungsdatum: </th></tr>')

    for (var i = 0; i < object_data['mention_years'].length; i++) {
      mention_year = object_data['mention_years'][i];
      mention_years.append(jQuery("<div></div>").text(mention_year.entity_date))
    }

    tbody.append(mention_years);
  }


  if (object_data['sources'].length > 0) {
    var sources = jQuery('<tr><th scope="row" class="obj_info">Quellenfundstelle: </th></tr>')

    for (var i = 0; i < object_data['sources'].length; i++) {
      source = object_data['sources'][i];

      if (source.source_folie_nr) {
        sources.append(jQuery("<div></div>").text(source.source_folie_nr + ", " + source.source_book))
      }

      if (source.source_text) {
        sources.append(jQuery("<div></div>").text(source.source_text))
      }
    }

    tbody.append(sources);
  }

  if (object_data['bibliography'].length > 0) {
    var bibliographies = jQuery('<tr><th scope="row" class="obj_info">Bibliografien: </th></tr>')

    for (var i = 0; i < object_data['bibliography'].length; i++) {
      bib = object_data['bibliography'][i];

      bibliographies.append(jQuery("<div></div>").text(bib.abbreviation + ", " + bib.author_institution));

    }
    tbody.append(bibliographies);
  }

  data_container.append(title)
  data_container.append(tbody)

  jQuery("#object_info").append(data_container);

  data_container.css("max-height", jQuery(window).height() - 250);

  remove_empty_elements();
}

/**
 * Removes empty elements after info is displayed in the right floating menu.
 */
function remove_empty_elements() {
  var trs = jQuery("#object_info").find("tr");

  trs.each(function(index) {
    if (isEmpty(jQuery(this).find("div"))) {
      jQuery(this).remove();
    }
  });
}

function isEmpty(el) {
  return !jQuery.trim(el.html())
}

/**
 * Get function for object data.
 * @param  {[type]} person_id [description]
 * @return {[type]}           [description]
 */
function get_single_person(person_id) {
  jQuery.ajax({
    url: ajax_object.ajax_url,
    type: 'POST',
    data: {
      action: 'get_single_person',
      requested_person_id: person_id
    },
    success: function(response) {

      searched_person = JSON.parse(response);

      console.log(searched_person);
      console.log(person_id);

      if ((Object.keys(searched_person).length === 0) || !person_id) {
        entity_type = "no data";
      } else {
        entity_type = "person";
      }

      console.log(entity_type);

      populate_info_div(searched_person, entity_type, false);
    }
  });
}

/**
 * Get function for object data.
 * @param  {[type]} location_id [description]
 * @return {[type]}             [description]
 */
function get_single_location(location_id) {
  jQuery.ajax({
    url: ajax_object.ajax_url,
    type: 'POST',
    data: {
      action: 'get_single_location',
      requested_location_id: location_id
    },
    success: function(response) {

      searched_location = JSON.parse(response);
      populate_info_div(searched_location, "location", false);
    }
  });
}

/**
 * Get function for object data.
 * @param  {[type]} object_id       [description]
 * @param  {[type]} additional_data [description]
 * @return {[type]}                 [description]
 */
function get_single_object(object_id, additional_data) {
  jQuery.ajax({
    url: ajax_object.ajax_url,
    type: 'POST',
    data: {
      action: 'get_single_object',
      requested_object_id: object_id
    },
    success: function(response) {

      searched_object = JSON.parse(response);
      populate_info_div(searched_object, "object", additional_data);
    }
  });
}
