-- phpMyAdmin SQL Dump
-- version 4.9.5
-- https://www.phpmyadmin.net/
--
-- Hôte : db.dmz.dhvlab.fo
-- Généré le : lun. 20 déc. 2021 à 16:16
-- Version du serveur :  5.5.65-MariaDB
-- Version de PHP : 7.3.18

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `labuser_jdesiderio`
--

-- --------------------------------------------------------

--
-- Structure de la table `ToponymsList`
--

CREATE TABLE `ToponymsList` (
  `id_toponym` int(11) NOT NULL COMMENT 'unique ID for each toponym in the text',
  `lat_name` varchar(100) DEFAULT NULL COMMENT 'main placename as given in the text',
  `sec_name` varchar(100) DEFAULT NULL COMMENT 'secondary name as given in the text',
  `en_name` varchar(200) DEFAULT NULL COMMENT 'translation of the placename in English / modern name',
  `type` varchar(20) DEFAULT NULL COMMENT 'typology of places (territories, settlements, geographical features, landmarks, buildings) ',
  `location` varchar(20) DEFAULT NULL COMMENT 'level of certainty of the location (certain, uncertain, unknown)',
  `biblical` tinyint(1) NOT NULL COMMENT 'is the site specifically linked to a biblical episode?',
  `geonames` int(10) DEFAULT NULL COMMENT 'Geonames ID: https://www.geonames.org/"#"',
  `pleiades` int(10) DEFAULT NULL COMMENT 'Pleiades ID: https://pleiades.stoa.org/places/"#"',
  `qid` int(11) DEFAULT NULL COMMENT 'Wikidata ID: https://www.wikidata.org/wiki/Q"#"',
  `wibilex` int(10) DEFAULT NULL COMMENT 'wissenschaftliche Bibellexikon im Internet: https://www.bibelwissenschaft.de/stichwort/"#"',
  `corp_huj` varchar(200) DEFAULT NULL COMMENT 'link to the corpus: https://dig.corps-cmhl.huji.ac.il/',
  `atlas_ref` text COMMENT 'some references to printed atlases',
  `latitude` decimal(8,6) DEFAULT NULL,
  `longitude` decimal(9,6) DEFAULT NULL,
  `id_mother` int(3) DEFAULT NULL COMMENT 'ID of the toponym in which the place is directly located',
  `comment` text COMMENT 'analysis of the use of the toponym in the context of Bede''s text'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='index of the toponyms cited in the text.';

--
-- Déchargement des données de la table `ToponymsList`
--

INSERT INTO `ToponymsList` (`id_toponym`, `lat_name`, `sec_name`, `en_name`, `type`, `location`, `biblical`, `geonames`, `pleiades`, `qid`, `wibilex`, `corp_huj`, `atlas_ref`, `latitude`, `longitude`, `id_mother`, `comment`) VALUES
(1, 'Alexandria', NULL, 'Alexandria', 'city', 'certain', 0, 361058, 727070, 87, NULL, NULL, NULL, '31.201760', '29.915820', 27, NULL),
(2, 'Arimathia', NULL, 'Arimathea', 'city', 'certain', 1, 0, 688014, 2558868, NULL, NULL, NULL, '32.040597', '35.021578', 34, NULL),
(3, 'Bersabea', NULL, 'Beersheba', 'city', 'certain', 0, 295530, 687846, 534596, 14780, NULL, NULL, '31.244722', '34.840833', 41, 'Tel Sheva is the archaeological site related to the remains of the biblical town of Beersheba. It is located in southern Israel, east of the modern city of Beersheba. The earliest remnants found are of unfortified settlements from the 10th-9th centuries. A fortified city was built on this site during the Iron Age II, and traces of settlements up to the Byzantine era have been found there. The town is a significant centre in the biblical narrative and is particularly linked to the story of Abraham. Bede only mentions the city as the southern point of the Holy Land, as it is often used in the Ancient Testament (Judges 20:1; 1 Sam. 3:20; 2 Sam. 3:10, 17:11, 24:2, 24:15; 1 Kings 4:25; 2 Kings 23:8).'),
(4, 'Bethania', NULL, 'Bethany', 'city', 'certain', 0, 285111, 156668177, 831190, 52045, NULL, NULL, '31.773151', '35.259589', 49, 'The town of Bethany is on the eastern slope of the Mount of Olives, alongside the south road to Jericho. It is now known as the village of Al-Eizariya, the Arabic name being derived from the name of Lazarus. Bede recalls the distance between Jerusalem and Bethany (15 stadia = 2,8 km) that is found in John 11:18. He mentions the town as it is the place where pilgrims may visit the Tomb of Lazarus marked by a church, without developing the biblical episode [See the notice Tomb of Lazarus]. Archaeological findings show that from the time of the Second Temple, it was an important stopover for Jewish pilgrims and since Byzantine times, it has been an important Christian pilgrimage site [See Küchler, 2014: 619-628].'),
(5, 'Bethlehem', NULL, 'Bethlehem', 'city', 'certain', 0, 284315, 687856, 5776, 10159, NULL, NULL, '31.712291', '35.202123', 34, NULL),
(6, 'Caesarea Palestinae', NULL, 'Caesarea Maritima', 'city', 'certain', 0, 294716, 678401, 319242, NULL, NULL, NULL, '32.501833', '34.900416', 36, NULL),
(7, 'Capharnaum', NULL, 'Capernaum', 'city', 'certain', 0, 294522, 678231, 59174, NULL, NULL, NULL, '32.880887', '35.575891', 56, NULL),
(8, 'Chebron', NULL, 'Hebron', 'city', 'certain', 0, 285066, 687915, 168225, 20809, NULL, NULL, '31.524354', '35.108539', 34, NULL),
(9, 'Chenereth', NULL, 'Kinneret / Gennesaret', 'city', 'certain', 0, 294461, 0, 5533392, NULL, NULL, NULL, '32.860556', '35.507222', 56, NULL),
(10, 'Constantinopolis', NULL, 'Constantinople', 'city', 'certain', 0, 745044, 520998, 16869, NULL, NULL, NULL, '41.016667', '28.975000', 32, NULL),
(11, 'Damascus', NULL, 'Damascus', 'city', 'certain', 0, 170654, 678106, 3766, 16125, NULL, NULL, '33.511612', '36.309102', NULL, 'The city of Damascus was established in the middle of the second millennium BC, and it is one of the oldest continuously inhabited cities in the world. Damascus is located on a plateau and was surrounded by the fertile land of an oasis named Ghouta, irrigated by the Barada River, which used to be an important stream of water. The three other rivers crossing near the city that Bede refers to are the Awaj River, which comes from the Hermon and maybe Baniyas and Qanawat [?]. In the east of the Ghouta, the Barada and the Awaj formed two large end lakes, that were a continuous body of water until the 19th century. These two rivers are recorded in the Old Testament as Abana / Amana and Pharpar (2 Kings 5: 10-12, where they are represented as more important than the Jordan). In the 1st century BC, Damascus was conquered by the Romans and incorporated into the province of Syria; the Christianization of the city is likely to have started early in the 1st century AD, as Paul already met a Christian community there (around 33 AD). Flavius Josephus mentions the existence of a Jewish colony in Damascus, as he gives an account of the Jewish victims during the first uprising against Rome in 66 AD (War II 559-561 and VII 368). Under Theodosius I, the temple of Jupiter was converted into a Christian cathedral, later dedicated to Saint John the Baptist [See the notice Church of Saint John the Baptist in Damascus]. After the Arab conquest of the city in 634, a prayer room for Muslims was built as an annex to the church [See the notice Prayer room], before the Umayyad Mosque was built on the site at the beginning of the 8th century. Damascus is the first of the three cities outside of the Holy Land that Bede describes in the last chapters of his DLS [with Alexandria and Constantinople], as the pilgrim Arculf, Adomnan’s source, visited it after his stay in Galilee.'),
(12, 'Dan', NULL, 'Tel Dan', 'city', 'certain', 0, 295356, 678109, 1346856, 16185, NULL, NULL, '33.242223', '35.652834', 41, 'Tel Dan is situated between the southern part of Mount Lebanon to the west and, to the northeast, the Hermon mountains. It is a very fertile zone, thanks to the melting snow from the Hermon mountains, which, as one of the sources of the Jordan (also named Dan) provides most of the water of the river. Five phases of the settlements could be distinguished, dating back to the first half of the 5th millennium BC. Bede only mentions the city as the northern point of the Holy Land – opposite to Beersheba –, as it is often used in the Ancient Testament (Judges 20:1; 1 Sam. 3:20; 2 Sam. 3:10, 17:11, 24:2, 24:15; 1 Kings 4:25; 2 Kings 23:8).'),
(13, 'Gomorra', NULL, 'Gomorrah', 'city', 'uncertain', 1, 0, 0, 1069011, 29019, NULL, NULL, NULL, NULL, NULL, NULL),
(14, 'Hiericho', NULL, 'Jericho', 'city', 'certain', 0, 284899, 687917, 5687, 22344, NULL, NULL, '31.870047', '35.443876', 57, NULL),
(15, 'Hierusalem', 'Hierosolima, Helia', 'Jerusalem', 'city', 'certain', 0, 281184, 687928, 1218, 22380, NULL, NULL, '31.776679', '35.234156', 34, NULL),
(16, 'Hippo', NULL, 'Hippos', 'city', 'certain', 0, 0, 678185, 1620075, NULL, NULL, NULL, '32.778671', '35.659795', NULL, NULL),
(17, 'Ioppe', NULL, 'Jaffa', 'city', 'certain', 0, 293253, 687931, 180294, NULL, NULL, NULL, '32.053079', '34.749930', 41, 'Jaffa (Latin Ioppe/Ioppa from Greek Ἰόππη, Hebrew Yafo and Arabic Yafa) is the oldest part of Tel Aviv-Yafo, located in the southern part of the modern city. It was an important ancient port, established around 1800 BC. The city is associated with the biblical stories of Jonah, Solomon and, in the New Testament, Saint Peter (Acts, 9:36–42; 10:10-23). In the Ancient Testament, Jaffa was described as the city bordering the territory of the Tribe of Dan (Joshua 19:46), before being conquered by the kings David and Solomon. Bede only mentions the city as the western point of the Holy Land – opposite to Bethlehem.'),
(18, 'Iulias', NULL, 'Bethsaida', 'city', 'certain', 0, 0, 678065, 501773, 15140, NULL, NULL, '32.895613', '35.619825', NULL, NULL),
(19, 'Nazareth', NULL, 'Nazareth', 'city', 'certain', 0, 294098, 678299, 430776, 52024, NULL, NULL, '32.701029', '35.300148', 56, NULL),
(20, 'Panium', 'Caesarea Philippi', 'Caesarea Philippi', 'city', 'certain', 0, 171831, 678324, 2484244, NULL, NULL, NULL, '33.247526', '35.693461', NULL, NULL),
(21, 'Scythopolis', NULL, 'Scythopolis', 'city', 'certain', 0, 295435, 678378, 3517238, 15152, NULL, NULL, '32.503362', '35.502981', 38, NULL),
(22, 'Sichem', 'Neapolis', 'Shechem', 'city', 'certain', 1, 282615, 678403, 7951237, 28513, NULL, NULL, '32.213557', '35.281522', NULL, NULL),
(23, 'Sodoma', NULL, 'Sodom', 'city', 'uncertain', 1, 293611, 0, 3297078, 29019, NULL, NULL, '31.131580', '35.375890', 40, NULL),
(24, 'Tiberias', NULL, 'Tiberias', 'city', 'certain', 0, 293322, 678431, 151920, NULL, NULL, NULL, '32.781575', '35.542153', 56, NULL),
(25, 'Vicus Genuauari', NULL, 'Ginnabris / Sennabris ', 'city', 'uncertain', 0, 0, 678386, 4703258, NULL, NULL, NULL, '32.709862', '35.566036', NULL, 'Bede names this small town as the northern limit of the Great Plain (i.e. the Jordan Valley). The denomination of the village has been modified through time and thus the precise location of the site was lost in the DLS. Bede found it in Hegesippus, which adapted Josephus (War 4,451-461). The Greek text had Γινναβρὶν (455), \"Ginnabris\", which was transmitted, according to Weber\'s app. crit., as <i>genuabari, genubari, gennabar</i> in some of the manuscripts of Hegesippus. If the spelling <i>genuauari</i> was not already present in the source manuscript used by Bede, it appears as an evident corruption of <i>genuabari</i>. Ginnabris, usually known as Sennabris, is situated about 5 kilometres south of Tiberias, on the bank of the Jordan river as it leaves the Sea of Galilee.'),
(26, 'Zoaros', NULL, 'Zoara', 'city', 'uncertain', 0, 0, 697768, 218016, 35454, NULL, NULL, '31.027273', '35.481818', 28, NULL),
(27, 'Aegyptus', NULL, 'Egypt', 'region', 'certain', 0, 8378475, NULL, 202311, 24365, NULL, NULL, '27.000000', '30.000000', NULL, NULL),
(28, 'Arabia Petraea', NULL, 'Arabia', 'region', 'certain', 0, 8378481, 29475, 221353, NULL, NULL, NULL, '32.519390', '36.482430', 29, NULL),
(29, 'Asia', NULL, 'Asia', 'region', 'certain', 0, 6255147, 915832, 48, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(30, 'Britannia', NULL, 'Britain', 'region', 'certain', 0, 8378485, 981513, 185103, NULL, NULL, NULL, '54.758440', '-2.695310', 32, NULL),
(31, 'Cilicia', NULL, 'Cilicia', 'region', 'certain', 0, 8378491, 981514, 4819648, NULL, NULL, NULL, '36.917100', '34.899660', 29, 'After clarifying the precise location of Constantinople, Bede recounts the story of the choice of the site of the city: originally, Constantine wanted to build it on the Asian side of the strait, and Bede, repeating Adomnan’s words, says that it would have been situated in the province of Cilicia. This is a clear mistake, as this province is situated in southern Anatolia. If the city was founded on the other side of the Bosporus, it would have been in the province of Bithynia et Pontus.'),
(32, 'Europa', NULL, 'Europe', 'region', 'certain', 0, 6255148, 1001887, 46, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(33, 'Gallia', NULL, 'Gaul', 'region', 'certain', 0, 12060420, 993, 38060, NULL, NULL, NULL, '47.085090', '1.483150', 32, NULL),
(34, 'Iudaea', NULL, 'Judea', 'region', 'certain', 0, NULL, NULL, 104028, NULL, NULL, NULL, '31.583330', '35.000000', 41, NULL),
(35, 'Neptalim', NULL, 'Naphtali', 'region', 'certain', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL),
(36, 'Palestina', NULL, 'Palestine', 'region', 'certain', 0, 12047392, NULL, 23792, NULL, NULL, NULL, '31.653930', '35.103520', 29, NULL),
(37, 'Phoenice', NULL, 'Phoenice', 'region', 'certain', 0, 8378532, NULL, NULL, NULL, NULL, NULL, '33.269540', '35.196260', 29, NULL),
(38, 'Scythopolis urbis terra', NULL, 'Territory of Scythopolis', 'region', 'certain', 0, NULL, NULL, 1377515, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(39, 'Sicilia', NULL, 'Sicily', 'region', 'certain', 0, 8378528, 981549, 691321, NULL, NULL, NULL, '37.623040', '13.934570', 32, NULL),
(40, 'Sodomitana regio', NULL, 'Territory of Sodom', 'region', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(41, 'Terra Repromissionis', NULL, 'The Promised Land', 'region', 'certain', 1, NULL, NULL, 48175, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(42, 'Thamnica regio', NULL, 'Territory of Thamna', 'region', 'certain', 0, NULL, NULL, NULL, NULL, NULL, NULL, '32.119500', '35.157200', NULL, NULL),
(43, 'Traconitidis terra', NULL, 'Trachonitis', 'region', 'certain', 0, NULL, NULL, 826132, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(44, 'Zabulon', NULL, 'Zebulun', 'region', 'certain', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL),
(45, 'Collis Mambre', NULL, 'Mamre', 'mountain', 'certain', 0, NULL, NULL, 2143048, 20809, NULL, NULL, '31.556536', '35.105336', 8, 'The Hill of Mamre is in the north of Hebron, 1.5 km north of the cave of the Patriarchs. It is the place where, according to biblical tradition, Abraham pitched his tent, after separating from Lot, and was visited by the three angels (Gen. 13:18, 18:21, 23:19) [For more information about this holy site, see the notice Oak of Mamre; about the current archaeological research on the site, <a href=\"https://www.aibl.fr/fouilles-archeologiques/labels-archeologie-2020-2021/article/programme-christianisation-et\">Labels Archéologie 2020 & 2021, AIBL</a>]..'),
(46, 'Mons ferreus', NULL, 'Iron Mount', 'mountain', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(47, 'Mons Libanus', NULL, 'Mount Lebanon', 'mountain', 'certain', 0, 9062341, 678267, 333711, NULL, NULL, NULL, '34.298990', '36.105840', NULL, NULL),
(48, 'Mons nudus', NULL, 'Judaean Mountains', 'mountain', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(49, 'Mons Oliueti', 'mons Oliuarum', 'Mount of Olives', 'mountain', 'certain', 0, 8581500, NULL, 205976, 52045, NULL, NULL, '31.780240', '35.246460', 34, 'The Mount of Olives is part of a ridge of hills going from north to south, to the east of Jerusalem, across the Kidron Valley [See the notice Kidron]. It is 818 meters high facing the Temple area. Bede situates it a mile away from Jerusalem (1480 m. – which is coherent with the walking distance between the Mount and the Temple area), equal in heights to Mount Sion (it is, in reality, slightly higher) but larger and wider [See the notice Mount Sion]. \r\nThe hill takes its name from the main vegetation growing on its slopes and top, olive trees. Bede, following the Vulgate, names it <i>Mons Oliueti</i>, “Mountain of the Olive Grove”, and once, <i>Mons Oliuarum</i>, “Mountain of the Olive Trees”. It seems that the Latin name was not fixed in the textual sources. \r\nAs Bede explains, it was cultivated, thanks to a soil good for vines and olive trees, but also for wheat and barley. The Latin text of the last sentence describing the vegetation on the Mount is a bit problematic, as the manuscripts all present an unattested word, <i>bruc(h)osa</i> or <i>brucos</i>: <i>bruchus</i> is a type of locust and <i>bruscosa</i> – Meehan’s conjecture in his edition of Adomnan\'s DLS – designates, in later texts, a “shrubland”. As Bede here opposes two type of soils, one <i>brucosus</i> and one grassy, we decided to follow Meehan’s proposition. \r\nAfter this description, Bede gives details about the sacred building located on this Mount: the Church of the Ascension, on top of the hill, the Tomb of Lazarus (with its church and monastery), and the Eleona, both close to the town of Bethany [see the corresponding notices].'),
(50, 'Mons pinosus', NULL, 'Mount with pines', 'mountain', 'unknown', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 34, NULL),
(51, 'Mons Siculus', NULL, 'Mount of Sicily', 'mountain', 'unknown', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, 'Salt mines near Realmonte?'),
(52, 'Mons Sion', 'mons Syon', 'Mount Zion', 'mountain', 'certain', 0, 281214, NULL, 332444, 35418, NULL, NULL, '31.766670', '35.233330', 15, NULL),
(53, 'Mons Thabor', NULL, 'Mount Tabor', 'mountain', 'certain', 0, 293418, 678419, 193785, 32198, NULL, NULL, '32.687280', '35.390650', 56, NULL),
(54, 'Vallis Iosaphat', NULL, 'Valley of Josaphat', 'valley', 'certain', 1, 281760, NULL, 531729, 22788, NULL, NULL, '31.766670', '35.233330', 34, NULL),
(55, 'Acheldemach', NULL, 'Akeldama', 'plain', 'certain', 0, NULL, NULL, 886458, NULL, NULL, NULL, '31.768410', '35.232880', 34, NULL),
(56, 'Campus Galilaeae', NULL, 'Galilee', 'plain', 'certain', 0, 294932, 678145, 83241, NULL, NULL, NULL, '32.900000', '35.333330', 41, NULL),
(57, 'Campus Hiericho', NULL, 'Plain of Jericho', 'plain', 'certain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 58, NULL),
(58, 'Campus Magnus', 'Aulon', 'Great Plain', 'plain', 'certain', 0, NULL, NULL, 67214249, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(59, 'Cedron', NULL, 'Kidron', 'river', 'certain', 0, 282563, NULL, 860532, NULL, NULL, NULL, '31.748943', '35.255235', 54, 'Bede mentions the Kidron river twice in the text, referring to the beginning of its course. The torrent – Bede remarks himself that it has no constant stream, but only flows when it rains (thus in the winter) – takes its source close to Jerusalem and flows south through the Valley of Josaphat (modern Kidron Valley), which separates the eastern side of the city from the Mount of Olives. It ends its course in the Dead Sea.'),
(60, 'Danubius', NULL, 'Danube', 'river', 'certain', 0, 791630, 226577, 1653, NULL, NULL, NULL, '45.333330', '29.666670', 32, 'The Danube is the second longest river in Europe, running from southern Germany to the Black Sea.\r\nBede uses the reference to the Danube Delta to help situate the city of Constantinople. As the river marked for centuries the north frontier of the Roman Empire, Bede might have considered this precision useful as it is a well-known geographical point. However, it appears that the distances he gives are erroneous, as he places the city 40 Roman miles (59km) south of the river. He probably copied the paragraph from Adomnan\'s text without checking the veracity of the information [see also the notice on Cilicia]. '),
(61, 'Iordanis', NULL, 'Jordan', 'river', 'certain', 0, 294624, 687932, 40059, NULL, NULL, NULL, '31.760250', '35.557920', NULL, 'The Jordan river is the main river of the Holy Land, running north to south, from the foot of the Anti-Lebanon mountain range, close to Mount Hermon, to the Dead Sea. Its full length is about 250 km, due to its meandering nature in the Jordan valley, between the Sea of Galilee and the Dead Sea. \r\nBeda mentions the Jordan river numerous times in the DLS, especially in chapter 10, dedicated to the river and the Sea of Galilee. Bede gives precise information about the course of the Jordan: he explains how its sources were discovered in the Trachonitis region before resurging near Panium (Banias); he quickly describes its course through the lakes of Merom (Hula) and Gennesaret (the Sea of Galilee). He does not comment on its descent but remarks on its winding nature down to the Dead Sea, where one can still follow the stream of the sweet water because of its milky colour. \r\nThe Jordan river was the largest source of water for the region at the time and thus bears an important role in sustaining life in the region. It also has an essential significance in Judaism and Christianity: it appears in biblical history as the place of many miracles. Bede refers to the Jordan when he recalls the site where Saint John baptized Jesus Christ (in the river, 5 or 6 km north of the Dead Sea), and when he speaks about Gilgal, close to Jericho, where Joshua erected 12 stones to commemorate the miracle of the crossing of the river on dry ground.'),
(62, 'Nilus', NULL, 'Nile', 'river', 'certain', 0, 351036, 727172, 3392, 29260, NULL, NULL, '30.161960', '31.149460', 27, 'Considering the historical and spiritual importance of Egypt and the Nile, one full chapter of the DLS is devoted to the city of Alexandria and to the river. As the main source of sustenance in Egypt, the Nile, which runs through eastern Africa for 6650 km down to the Mediterranean Sea, was worshipped in the ancient world. However, it is interesting to note that Bede mainly comments on very practical matters concerning the conditions of living near the river. As the Nile rises and floods annually, thus fertilizing the land, the population had to adapt: they built dikes to protect the fields, so that they would not be flooded, and constructed their houses on stilts. It is probable that Bede mentions the specificity of the Nile by contrast with the climate of the Holy Land, where most of the water supply comes from the winter rains. '),
(63, 'Phiala', NULL, 'Lake Ram', 'spring', 'certain', 0, 165565, NULL, 26835, NULL, NULL, NULL, '33.232630', '35.766130', NULL, 'The question of the place where the Jordan takes its source is essential, considering the concrete and spiritual importance of the river. It is known today that the principal sources of the Jordan are the three springs near Tel Dan, Banias, and Hasbaya, filled by the precipitation on Mount Hermon. \r\nIt was believed in Antiquity that the spring in Banias actually came from the crater lake now known as Lake Ram, named Phiala in Greek because of its round form. According to Bede\'s sources, Philip the Tetrarch, who ruled over the northeast part of his father\'s kingdom (Herod I) at the beginning of the 1st century, threw chaff in the lake and saw it reappear in Banias, after travelling through underground channels. \r\nModern calculations show that this is probably untrue [cf. Mazor, E. (1976). \"The Ram Crater Lake A note on the revival of a 2000-year-old groundwater tracing experiment.\" International Atomic Energy Agency (IAEA): IAEA]. The lake appears to have no outlet, and the only known underground spring is the one feeding it. '),
(64, 'Fons Elisei', NULL, 'Elisha\'s Spring [Ain es-Sultan]', 'spring', 'certain', 1, 281732, NULL, 6585622, 17376, NULL, NULL, '31.870489', '35.444761', 14, 'Elisha\'s Spring (modern Ain-Es-Sultan) is the main source of water in the region of Jericho. Remains of very ancient human settlements, going back to the 10th millennium BC, have been found close by (Tell es-Sultan). It is referred to in II Kings, II 19-22, as the waters which Elisha purified with a pot of salt. \r\nIn the DLS, the spring is part of the description of the region of Jericho: Bede starts with the fact that the city is mostly destroyed and that the site - and the plain around - now mostly bears fields and vines. He then mentions two sacred sites: Gilgal and Elisha\'s Spring, reminding the readers of the biblical episodes linked to them. Most of the chapter is then dedicated to the topography of the lower Jordan valley and to the local agriculture, permitted by the irrigation system linked to the spring. '),
(65, 'Fons Iacob', NULL, 'Jacob\'s Well', 'spring', 'certain', 1, 281302, NULL, 1679519, 22151, NULL, NULL, '32.209520', '35.285180', 141, 'The well, situated near Nablus, close to the archaeological site of Tell Balata - thought to be the site of Shechem -, has been associated with Jacob by all Jewish, Samaritan, Christian, and Muslim traditions. In Genesis 33:18–20, it is said that Jacob, returning to Shechem, bought the land on which he camped and built there an altar. The well itself is named in the New Testament in John 4:5–6, and the Gospel then relates the conversation between Jesus and the Samaritan woman. Bede clearly abridged Adomnan\'s paragraph on the subject, only referring briefly to the biblical passage and describing the size of the well, in order to offer a mental image of the site to its readers. However, Bede’s Latin is not very clear here, indicating either that he misunderstood Adomnan or, more probably, that a copist inserted a marginal note within the text. The phrase <i>a latere ipso usque ad summum digitorum extentus</i> should be understood as a gloss explaining the length of a cubit – as it was done in Adomnan’s text –, but the syntax does not permit this reading: <i>extentus</i> can only qualify the subject <i>fons</i>, giving the impression that Bede informs us here on the width of the well. If this detail was indeed a note on the length of a cubit, we can conclude that Bede took a cubit to be a Roman ulna (about 1.2 meters), and the well would be around 48 meters deep.'),
(66, 'Fons Iohannis', NULL, 'Spring of John', 'spring', 'unknown', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, 'After describing the site where Saint John baptized Jesus Christ, Bede turns to the desert where John spent his childhood (Luke 1:80). It is impossible to locate the spring to which John would drink water, as neither Bede nor Adomnan give any details about the desert itself. Following the Gospels, it could be situated in the desert of Judea, maybe close to Qumran [see Finegan, 1992: 13-16]. In the 7th century, according to Arculf\'s own description - as Bede here quotes Adomnan -, the spring was protected by a small roof covered with lime plaster. He makes no mention of a church or any other commemorative building. \r\nIn texts, the “Desert of John” at Ain El-Ma’moudiyeh (= “spring of the Baptism”), nine kilometres west of Hebron, was first connected to John in the travel report of the Anonymous II, in the 12th century. The pilgrim mentions a church of Saint John the Baptist (“where he preached the baptism of Penitence in the desert”) and a spring where water always flows [see Kopp–Steve, 1946]. The spring known as Ain el-Habis, “the spring of the Hermit”, enclosed in the actual Monastery of Saint John in the Wilderness, has been linked to John later, in the 15th century. It is situated a few kilometres away from Ein Karem, where, according to Christian tradition, John was born. '),
(67, 'Fons Siloe', NULL, 'Pool of Siloam', 'spring', 'certain', 0, 281787, NULL, 1483483, 22380, NULL, NULL, '31.760070', '35.247490', 15, 'The pool of Siloam is one of the few sites whose identification is undisputed among topographers and scholars. This term refers precisely to rock-cut pools, at the foot of Mount Sion to the southeast, in the Lower City. These pools were fed by the Gihon Spring, through the Siloam tunnel, carved in the 9th-8th century BC. The \"Old Pool\" (originally - at least until 70 AD - the pool of Siloam), which is the lower and the bigger one, is known as Birket el Hamra, \"the red pool\". The excavations led at the site of the pool of Siloam showed that throughout the centuries, various pools have been built, destroyed and restored, which might have impeded a clear description of the site by pilgrims and commentators. The question of the location of the pool within the walls of the city (Bede places it so, probably referring to the wall built in the 1st century AD, enclosing Birkeh Silwan, the newer pool) is a good indicator of the evolution of the site since its construction [Wilkinson, 1978; Finegan, 1992: 187-192].\r\nHowever, Bede, following Eucherius, does not really describe the pools, but the spring itself: Gihon Spring (probable derivation from Hebrew \"giha\", \"gushing\"; also known as the Fountain of the Virgin) was historically and culturally essential, as the main source of water that made possible the human settlement of what would become Jerusalem. It is an intermittent spring, with water gushing at specific times of the day. This specificity was bound to attract the attention of Bede, who relays many topographical peculiarities related to biblical episodes in the DLS. '),
(68, 'Fons [Capernaum]', NULL, 'Spring at Tabgha', 'spring', 'uncertain', 1, NULL, NULL, NULL, NULL, NULL, NULL, '32.873658', '35.548975', 142, 'Bede mentions an unnamed spring at the site where, according to the four Gospels, Jesus fed the five thousand with five loaves and two fishes. The Greek name of this plain was Heptapegon (\"seven springs\"): it is impossible to determine which of these seven springs is referred to here, but it might be the spring named Capharnaum by the locals, according to Josephus (3,10,8 §519). Remains show that in the Byzantine period, the water was collected in three water towers (Birket Ali edh-Dhaher at Ein Nur Spring, Hammam Ayyub, and Tannur Ayub) and used for irrigation in the plain of Ginosar thanks to an aqueduct. However, as Arculf said that no human construction was to be seen on site, it is possible that, by the time the bishop visited the site, the towers had also been demolished [For more information about the site itself, see the notice Tabgha].'),
(69, 'Lacus Mareoticus', NULL, 'Lake Mariout', 'sea', 'certain', 0, 8556346, NULL, 2082231, NULL, NULL, NULL, '31.153060', '29.898610', 27, 'Bede, following Adomnan\'s account, reports that the Lake Mariout marks the north border of Alexandria. This topographical feature is only used as a location marker to situate the city (such as the Mediterranean Sea or the Danube River).'),
(70, 'Mare Galilaeae', 'Genesar, Mare Chenereth', 'Sea of Galilee', 'sea', 'certain', 0, 294459, 678430, 126982, NULL, NULL, NULL, '32.807230', '35.592790', 56, 'Bede refers to the Sea of Galilee - the second freshwater lake crossed by the Jordan - under three of its names: <i>Mare Galilaeae</i>, <i>Mare Chenereth</i> and <i>Lacus Genesar</i>. Throughout history, the lake has been known under various names, depending usually on the importance of a neighbouring region or settlement. In the Old Testament, it is called <i>Mare Chenereth</i>, the \"sea of Kinneret(h)\" (Numbers 34:11; Joshua 13:27), linked to the major ancient city of the same name on its north-western shore. In the Gospels (Matthew, Mark and Luke), it is frequently referred to as <i>Mare Galilaeae</i>, after the district of Galilee. The names Gen(n)esar (1 Maccabees 11:67), Gen(n)esareth (Luke 5:1 uses specifically the term \"lake\" of Gennesaret, while it is always referred to elsewhere as a sea), Ginosar (in the Talmud and Flavius Josephus) are also regularly used, and \"Gennesaret\" is considered to be the original designation by Josephus. It comes from the evolution, through Greek, of the more ancient name Chenereth. In the New Testament, it is also called Lake of Tiberias, from the new main city, named after the emperor Tiberius, on the western shore.\r\nIn the text, Bede mainly mentions the Sea of Galilee for its importance as a freshwater source, the fertility of the soil and the abundance and quality of fish it contains. For these reasons, many settlements have been founded around the lake, such as Tiberias, Capernaum and Julias. Also, as Bede reports it, its shores have been the site of the miracle of the feeding of the five thousand.'),
(71, 'Mare Magnum', NULL, 'Mediterranean Sea', 'sea', 'certain', 0, 363196, 1043, 4918, NULL, NULL, NULL, '36.403941', '13.142969', NULL, 'Bede only mentions the Mediterranean Sea to locate the city of Constantinople. Following Adomnan, he notes that the Sea (modern Marmara) stretches for sixty miles (89 km) between the Mediterranean Sea to the walls of the city. This number appears to be quite an understatement, considering the length of the sea from the Hellespont to the Bosporus [see also the notice on the Danube River].'),
(72, 'Mare Mortuum', 'Lacus Asfaltius', 'Dead Sea', 'sea', 'certain', 0, 295347, 697709, 23883, NULL, NULL, NULL, '31.557470', '35.495450', NULL, 'The Jordan ends in the Dead Sea, a saltwater lake in the southeast of Palestine, that has no outlet: the water is lost only through evaporation, and it is known for its high level of salinity and other minerals. In the Old Testament, it is called the \"Sea of Salt\" (e.g., Genesis 14.3; Numbers 34:12), the \"sea of the plain\" (Deuteronomy 3:17), the \"Eastern Sea\" (Ezek. 47:18; Joel 2:20), or the \"Sea of the Arabah\"; in Arabic, it is known as the \"Sea of Lot\" or the \"Sea of Zoar\". \r\nThe first attestations of the name \"Dead Sea\" are in Greek (θάλασσα νεκρά‎), from the 2nd-century texts of Pausanias and Galen. Before that denomination, Greeks also designated the sea as the \"Lake Asphaltites\", because of the bitumen floating on its surface. In Latin, Pliny used the latter in his Natural History, and the name \"Dead Sea\" came in use during late Antiquity in Christian texts. Bede calls it indifferently <i>Mare Mortuum</i> and <i>Asfaltius lacus</i>.\r\nBecause of its specificity, Bede dedicates a full chapter to the description of the Dead Sea. He follows the Hebrew tradition about its formation: the sea was born from the destruction of Sodom and Gomorrah, which explains its salinity. He then relates the most common features of its waters, as transmitted in his sources: the salt and bitumen collected and sold by the inhabitants of its shore; the special qualities of its waters, where everything and everyone float - he even recalls a specific episode about Vespasian - but where no living being can survive (which, incidentally, is the reason for its name); the poor quality of the air, maybe caused by the sulphur in the mud, and the inedible fruits growing in the neighbouring regions. The description of the Dead Sea is one of the few instances in the DLS where Bede did not omit all supernatural elements from the texts he abridged.'),
(73, 'Gehennon', NULL, 'Gehenna', 'valley', 'certain', 0, 281175, NULL, 558093, 21286, NULL, NULL, '31.766670', '35.233330', 34, NULL),
(74, 'Sanctae Mariae Ecclesia', NULL, 'Church of the Sepulchre of Saint Mary', 'building', 'certain', 0, NULL, NULL, 968028, NULL, NULL, NULL, '31.780000', '35.239722', 54, NULL),
(75, 'Monumenta Patrum', NULL, 'Cave of the Patriarchs ', 'tomb', 'certain', 1, 8073316, NULL, 204200, NULL, NULL, NULL, '31.524920', '35.110900', 131, NULL),
(76, 'Locus in quo Dominus baptizatus est', NULL, 'Baptism Site of Jesus Christ', 'landmark', 'certain', 0, 7838934, NULL, 1574073, NULL, NULL, NULL, '31.837100', '35.546310', 61, 'The site of the baptism of Jesus Christ by John is a clear example of Bede’s goal within the DLS: to describe the commemorative landscape of the Holy Land at his time. Bede’s short account comes after a long line of discussions, descriptions, and reports on the subject. For centuries, the exact location of the baptism and the place name were discussed by commentators, and pilgrims gave different indications about the site and its sacred buildings [see Tsafrir, 1986; Waheed, 2013]. Up until the 6th century, the baptism was considered to have happened in Bethany/Bethabara beyond the Jordan, either directly on the east bank of the Jordan River or a bit further in the land. However, because it was easier or safer to access, pilgrims started commemorating the baptism on the west bank. Here Bede copies the most important points of Adomnan’s description, reorganizing the various elements: he starts with the cross marking the exact point in the river where Jesus was baptized and notes the width of the Jordan there. Bede, following Adomnan, says that the other bank is a slingshot away, which could indicate that at that location, the river was not very wide: for John to practice baptisms in the Jordan, an easy access to the water was necessary, which would be permitted by a ford. The location of the site, about 8 km north of the Dead Sea, where the Wadi Al-Kharrar joins the Jordan river, matches such a description. Afterwards, Bede reviews the commemorative buildings located close to the site: the monastery of John with its church [see the notice Monastery of Saint John the Baptist], and the square church in the water where Jesus left his clothes [see the notice Church where the Lord\'s clothes were kept]. He states that a bridge links the monastery to the cross in the river, permitting the pilgrims to access the site to pray. This bridge could correspond to the stairs from the Byzantine era leading to the river that have been found on the east bank of the river. No structure of this kind can be seen today on the west bank of the river.'),
(77, 'Basilica Sancta Sophia', NULL, 'Hagia Sophia', 'building', 'certain', 0, 6947665, 307220778, 12506, NULL, NULL, NULL, '41.008600', '28.980000', 10, NULL),
(78, 'Porta Dauid', NULL, 'Gate of David', 'landmark', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, 'Jaffa Gate?'),
(79, 'Porta uillae fullonis', NULL, 'Gate of the Fuller\'s Field', 'landmark', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL),
(80, 'Porta Sancti Stephani', NULL, 'Gate of St Stephen', 'landmark', 'uncertain', 0, 6957220, NULL, 947597, NULL, NULL, NULL, NULL, NULL, 15, 'Damascus Gate?'),
(81, 'Porta Beniamin', NULL, 'Gate of Benjamin', 'landmark', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, 'Lions\' Gate?'),
(82, 'Portula', NULL, 'Small Gate', 'landmark', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL),
(83, 'Porta Thecuitis', NULL, 'Gate of Tekoa', 'landmark', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL),
(87, 'Martyrium', 'Ecclesia Constantiniana', 'Martyrium (Church of the Holy Sepulchre)', 'building', 'certain', 0, 8335062, NULL, 187702, NULL, NULL, NULL, '31.778611', '35.229444', 15, 'After explaining the overall setting of the city of Jerusalem, Bede discusses the various sacred places within its walls. He starts by the most important site, what is today known as the Church of the Holy Sepulchre, a whole complex containing, most notably, the tomb of Jesus Christ. Bede starts his description of intramural Jerusalem from the north of the city, following the structure of Eucherius\'s brief overlook of the site, and walks the reader through the complex from East to West, and then back to the entrance. He first mentions the Martyrium (the eastern building), then to the West, Golgotha, where Jesus Christ was crucified, and the Anastasis, which contains the Tomb of Jesus. Once Bede is done with the main sites, he walks back to the East and mentions the secondary sacred buildings encountered, the church of the holy Mother of God, the chapel of the Chalice, the place where Abraham was ready to sacrifice his son and finally, the portico of the Martyrium which holds the soldier\'s lance. Most details in these descriptions come from Adomnan\'s DLS, which Bede reorganized to match his walkthrough of the buildings [cf. Aist 2018: 123-124]. The plan of the Holy Sepulchre drawn in some of the manuscripts (copied from Adomnan\'s texts) gives a good overview of the layout of the complex and illustrates well Bede\'s literary description. They partly represent the complex as it had been rebuilt by Modestus in the 7th century, after the destruction of the Constantinian building in 614 during the Persian invasion. </br>\r\nBede gives few information about the Martyrium, the church originally built by Constantine in 335. He mainly insists on the magnificence of the construction and recalls the fact that this is the place where Helena, the mother of Constantine would have found the Holy Cross. If Adomnan mentions the finding of the cross, the attribution to Helena is added by Bede through other sources (such as Sulpicius Severus, Chronicon 2,33,2). The drawn plan of the building represents three crosses in a rectangular basilica, omitting the legend of Adomnan\'s drawings, which explains that there were the two crosses of the robbers around the Holy Cross.'),
(88, 'Golgotha', NULL, 'Calvary', 'building', 'certain', 0, 8335062, NULL, 187702, 46736, NULL, NULL, '31.778611', '35.229444', 15, 'The church of Calvary is the second building described from the complex, next to the Martyrium. Golgotha (\"the place of a skull\", as translated in the Gospels) is the site where Jesus was crucified. The church has two storeys: the ground floor bears the stone of the Holy Cross (now set with a silver cross under a lamp) and the crypt underneath, the cave containing the Cross discovered when the complex was built, is used for liturgies in honour of the dead. '),
(89, 'Crypta Dominicae crucis ', NULL, 'Grotto of the Holy Cross', 'building', 'certain', 0, 8335062, NULL, 187702, 46736, NULL, NULL, '31.778426', '35.230107', 87, '[See the notice Calvary]'),
(90, 'Anastasis', NULL, 'Church of the Holy Sepulchre', 'building', 'certain', 0, 8335062, NULL, 187702, 46848, 'https://dig.corps-cmhl.huji.ac.il/node/12425', NULL, '31.778470', '35.229790', 15, 'Bede\'s description of the Anastasis (\"the church of the resurrection\") is another abridgement from Adomnan\'s DLS. As it is described and shown on the drawn plans in the manuscripts, the church was a round structure built around the tomb of Jesus, with three concentric walls, three altars and two main series of doors, going throughout each wall, on the northeast and the southeast. Some plans in Bede\'s manuscripts (such as N and P) don\'t represent the doors, maybe because Bede\'s directions were unclear. This confusion is still distinct in the various translations of the text, as it appears that both Adomnan and Bede might have misunderstood the winds used as reference points. Foley (1999) translated <i>uulturnum</i> and <i>eurum</i> by south-east and east; Wilkinson (2002), by west and east. However, Bede\'s directions are coherent with what is found in his source\'s text. Adomnan says <i>ex quibus quattuor exitus ad uulturnum spectant, qui et caecias dicitur uentus, alii uero quattuor ad eurum respiciunt</i>, \"four of them are on the north facing east, also called the Caecias wind, and the other four are on the south facing east\" [Wilkinson, 2002: 171]. It seems that Bede omitted the insert where Adomnan equates the Vulturnus (a south-east wind) to the Caecias (a north-east wind), but did not realize that this made the indication almost redundant with the Eurus (a south-east wind) and thus unclear. Considering that the plan in Ms W shows the entrances on the south-east and on the north-east, copying exactly the drawings in Adomnan\'s manuscripts, we decided to translate <i>uulturnus</i> as \"north-east\", considering that this is how Bede understood it.'),
(91, 'Monumentum Domini', NULL, 'Tomb of Jesus', 'tomb', 'certain', 0, 8335062, NULL, 187702, 46848, NULL, NULL, '31.778470', '35.229790', 90, 'Once the Anastasis layout has been explained, Bede then describes the tomb of Jesus in the centre of the church. It consists in a rock-cut aedicule covered in marble (the <i>monumentum</i>), containing, inside to the north, the empty sepulchre of Jesus Christ (the <i>sepulchrum</i>), a shelf about two-meters long carved around 20-25 centimetres above the ground.'),
(92, 'Sepulchrum Domini', NULL, 'Sepulchre of Jesus', 'tomb', 'certain', 0, 8335062, NULL, 187702, 46848, NULL, NULL, '31.778470', '35.229790', 91, '[See the notice Tomb of Jesus]'),
(93, 'Beatae Dei genitricis ecclesia', NULL, 'Church of the holy Mother of God', 'building', 'certain', 0, 8335062, NULL, 187702, NULL, NULL, NULL, '31.778470', '35.229790', 15, 'Bede places the Church of the holy Mother of God, located to the south on the plans, to the right of the Anastasis, which indicates that the reader should now be facing east, starting the walk back to the entrance. [Aist, 2018: 125-126]. This is the first of the minor landmarks of the complex. According to the plans, the church was adjacent to the Anastasis, but some drawings from Adomnan show that it was a separate building, with four entrances opened to the courtyard between the round church and Golgotha.'),
(94, 'Exedra', NULL, 'Chapel of the Chalice', 'landmark', 'certain', 0, 8335062, NULL, 187702, NULL, NULL, NULL, '31.778470', '35.229790', 15, 'The chapel of the Lord\'s chalice is situated right between Golgotha and the Martyrium and contains the cup of the Last Supper. It is not represented in the plans in Bede\'s manuscripts.'),
(95, 'Locus quo Abraham altare ad immolandum filium construxit', NULL, 'Abraham\'s Altar', 'landmark', 'certain', 0, 8335062, NULL, 187702, 12288, NULL, NULL, '31.778470', '35.229790', 15, 'In the north-east corner of the courtyard - according to the plans in Adomnan\'s manuscripts, opposite to the chapel of the Lord\'s chalice, there is a wooden table indicating the place of Abraham\'s altar (Gen. 22). It is not represented in the plans in Bede\'s manuscripts.'),
(96, 'Porticus Martyrii', NULL, 'Portico of the Martyrium', 'landmark', 'certain', 0, 8335062, NULL, 187702, NULL, NULL, NULL, '31.778611', '35.229444', 87, 'The last site of the Holy Sepulchre mentioned by Bede is back at the entrance of the Martyrium: under the portico, a cross holds the Holy Spear used by the soldier to pierce the side of Jesus during the crucifixion.'),
(97, 'Templum', NULL, 'The Second Temple', 'building', 'certain', 0, 6269612, 973646718, 728428, 54011, NULL, NULL, '31.778120', '35.235130', 15, NULL),
(98, 'Quadrata domus', NULL, 'Al-Aqsa Mosque', 'building', 'certain', 0, 6269611, NULL, 425281, NULL, NULL, NULL, '31.776140', '35.235490', 15, NULL),
(99, 'Cisternae', NULL, 'Cisterns', 'spring', 'uncertain', 0, NULL, NULL, 4916469, NULL, NULL, NULL, '31.780339', '35.236208', 15, 'It is plausible that the cisterns close to the Temple Mount and the Mosque correspond to the pool today named Birket Israel, built by the Romans as a water reservoir on the northern wall of the Temple Mount. It has been assumed that it was built during Hadrian\'s restoration of the city: the study of the masonry and the fact that Josephus does not mention it in his texts (but the pilgrim of Bordeaux does) points to this era [see Jacobson, 1990-1991: 37-44].  \r\nIt was Jerusalem\'s largest reservoir, and it might have also served as a moat. Bede, copying Eucherius, talks about cisterns in the plural: it might refer to other reservoirs close by (e.g., to the east of the two main pools of Bethesda, there are 6 smaller pools, which could have been water reservoirs), or just be an emphasis, considering the size of this pool.\r\nBede\'s account is quite imprecise: he does not keep the location given by Eucherius (\"to the north\"), but as he moves on north, from the Mosque on the Temple Mount to the pool of Bethesda, before going further east to the pool of Siloam, he could have felt that the direction was an unnecessary addition.'),
(100, 'Bethsaida piscina', NULL, 'Pool of Bethesda', 'spring', 'certain', 1, NULL, NULL, 831297, NULL, NULL, NULL, '31.781300', '35.235800', 15, 'The Pool of Bethesda is a bathing pool in Jerusalem mentioned in the Gospel of John (5:1-15) as the location where Jesus miraculously healed a paralysed man. The waters were thought to have healing powers when they were agitated. \r\nThe manuscripts of the Gospel and the commentators don\'t give a uniform version of the name: we find, for instance, Beth-zatha, derived from the name or the suburb Bezetha; Bethsaida, frequently used by commentators (including Jerome) and pilgrims, but probably a metathesis influenced by the city of the same name [Wieand, 1966]. The discovery of the Dead Sea scrolls showed that the Greek transcription Bethesda (= \"house of mercy\") is the most probable name. All the DLS manuscripts we have transcribed hold the reading Bethsaida, which was the one used by Eucherius.\r\nIn the Gospel, the pool is situated near the Sheep Gate and briefly described as being surrounded by five porticoes. Archaeological digs conducted in the last two centuries close to the Lion\'s Gate unearthed first a large water tank, situated north-west of St. Anne\'s Church, then the remains of a second large pool, the dam between these two pools, a Temple of Asclepius and Serapis, the healing pools of an Asclepeion, a Byzantine and a Crusader church. This site is the most probable candidate to be associated with the Pool of Bethesda. Other sites have been considered (e.g. the Pool of the Virgin, also known as Gihon Spring, an intermittent spring feeding the pool of Siloam) but, as Bede names first the cisterns close to the Temple Mount (which may be a reference to Birket Israel [see Cisterns]), the pool of Bethesda and then the pool of Siloam [see Pool of Siloam] at the foot of Mount Sion, it is clear that they are three different reservoirs.\r\nBede copies almost word for word Eucherius\' text: he describes it briefly as containing two large tanks, one being filled by the winter rains, and the other being of a reddish colour. Jerome (sit. et nom. 142,9-15) links the red colour and the Greek name of the pool (προβατικὴ, \"of / belonging to sheep\") to the fact that priests would wash the sacrificial sheep in this pool. However, neither Eucherius nor Bede discuss the pool\'s functions, taken today [von Wahlde, 2009] as an otsar (the north pool, collecting rainwater) and a mikveh (the south pool, a ritual bath filled from the north pool). Adomnan does not mention it, which may imply that, during Arculf\'s time, the pool was not part of the pilgrims\' tour of Jerusalem anymore. The last documented reference to the pool is in the <i>Itinerarium S. Willibaldi</i> (who was in Jerusalem in 724-725), but archaeological evidence shows that the pool was not completely abandoned before the 9th century [see Dauphin, 2005: 259-261].'),
(101, 'Monachorum cellulae [Sion]', NULL, 'Holy Zion monastery', 'building', 'certain', 0, NULL, NULL, 1245538, NULL, 'https://dig.corps-cmhl.huji.ac.il/node/12503', NULL, '31.772200', '35.228900', 15, NULL),
(102, 'Ecclesia magna ab Apostolis fundata', NULL, 'Church of the Apostles on Mount Zion', 'building', 'certain', 0, NULL, NULL, 1245538, NULL, 'https://dig.corps-cmhl.huji.ac.il/node/12503', NULL, '31.772200', '35.228900', 101, NULL),
(105, 'Columna ubi cruce domini superposita mortuus reuixit', NULL, 'Centre of the Earth', 'landmark', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL),
(106, 'Pons medietatem', NULL, 'Bridge', 'road', 'unknown', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(107, 'Ficus', NULL, 'Fig-Tree', 'landmark', 'unknown', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(108, 'Ecclesia [linteum a sancta maria contextum]', NULL, 'Church containing St Mary\'s veil [Jerusalem]', 'building', 'unknown', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(109, 'Locus Bahalim sacrus', NULL, 'Temple of Baal', 'building', 'unknown', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 73, NULL),
(110, 'Turris regis Iosaphat', NULL, 'Tower of Jehoshapat', 'tomb', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, '31.777278', '35.238889', 73, 'Tomb of Asphalom?'),
(111, 'Regis Iosaphat sepulchrum', NULL, 'Cave of Jehoshapat', 'tomb', 'uncertain', 0, NULL, NULL, 3117130, NULL, NULL, NULL, '31.777278', '35.238889', 110, NULL);
INSERT INTO `ToponymsList` (`id_toponym`, `lat_name`, `sec_name`, `en_name`, `type`, `location`, `biblical`, `geonames`, `pleiades`, `qid`, `wibilex`, `corp_huj`, `atlas_ref`, `latitude`, `longitude`, `id_mother`, `comment`) VALUES
(112, 'Domus [Symeonis  et Ioseph]', NULL, 'Chamber containing the tombs of Simeon and Joseph', 'building', 'uncertain', 0, NULL, NULL, 1708945, NULL, NULL, NULL, NULL, NULL, 54, 'Tomb of Zechariah and Tomb of Benei Hezir (?)'),
(113, 'Duo cauata sepulchra Symeonis senis et Ioseph Sanctae Mariae sponsi', NULL, 'Tombs of Simeon and Joseph', 'tomb', 'uncertain', 0, NULL, NULL, 492091, NULL, NULL, NULL, NULL, NULL, 112, 'Tomb of Zechariah and Tomb of Benei Hezir (?)'),
(114, 'Monumentum uacuum in quo Sancta Maria aliquandiu pausasse dicitur', NULL, 'Saint Mary’s tomb', 'tomb', 'certain', 0, NULL, NULL, 968028, NULL, NULL, NULL, '31.780000', '35.239722', 74, NULL),
(115, 'Ecclesia ubi dominus ad caelos ascendit', NULL, 'Chapel of the Ascension', 'building', 'certain', 0, NULL, NULL, 773726, 52045, NULL, NULL, '31.778956', '35.244959', 49, NULL),
(116, 'Monumentum Lazari', NULL, 'Tomb of Lazarus ', 'tomb', 'certain', 0, NULL, NULL, 7818622, 51951, 'https://dig.corps-cmhl.huji.ac.il/node/7964', NULL, '31.771661', '35.255903', 117, 'John 11 says that it is in Bethany [See the notice Bethany] that Jesus resurrected Lazarus. The tomb has been visited by pilgrims since Antiquity and is still accessible to this day: through a doorway, twenty-two steps lead down to a cave, where it is said Lazarus laid before his resurrection. The tomb was first mentioned, at the beginning of the 4th century, by the Pilgrim of Bordeaux in his Itinerarium (596), and Eusebius of Caesarea in the Onomastikon (p. 58). However, it seems that the church above it had not yet been built. The discovery of other tombs close by indicates that it was situated in a funerary area, therefore originally outside the village, which could correspond to the specification given by Bede about its location in “a certain field of Bethany”.\r\n[See the notices Church of Saint Lazarus and Monastery of Saint Lazarus for more information about this site]'),
(117, 'Ecclesia [Lazari]', NULL, 'Church of Saint Lazarus', 'building', 'certain', 0, NULL, NULL, 7818622, 51951, 'https://dig.corps-cmhl.huji.ac.il/node/7964', NULL, '31.771661', '35.255903', 4, 'Bede mentions a church and a monastery built above the tomb of Lazarus in a field of Bethany, that, according to Adomnan, Arculf visited. The first allusion of a church dedicated to Saint Lazarus commemorating the miracle in Bethany is found in Jerome (sit. et nom. 108 p. 142,3-5), in 390. Egeria (29,3-4), 20 years later, described this church, which she called the Lazarium, alongside the liturgies that took place there. This church was destroyed in the 5th century by an earthquake; a larger church was built to replace it, which remained unchanged until the Crusader period.\r\n[See the notices Tomb of Lazarus and Monastery of Saint Lazarus for more information about this site]'),
(118, 'Monasterium [Lazari]', NULL, 'Monastery of Saint Lazarus', 'building', 'uncertain', 0, NULL, NULL, 7818622, 51951, 'https://dig.corps-cmhl.huji.ac.il/node/7964', NULL, '31.771661', '35.255903', 117, 'Even though both churches from the Byzantine period (the Lazarium from the 4th century and the larger church replacing it in the 5th century) were excavated, no remains of the monastery were identified. This building is only known from literary sources: it is impossible to determine if Arculf visited the monastery or if Adomnan drew upon earlier mentions of the presence of monks on site (cf. the Itinerarium of Egeria, 29,3-4) to infer the existence of a local monastery.\r\n[See the notices Tomb of Lazarus and Church of Saint Lazarus for more information about this site]'),
(119, 'Ecclesia ubi Dominus ante Passionem discipulis de die iudicii loquitur', NULL, 'Church of Eleona', 'building', 'certain', 1, NULL, NULL, 588849, NULL, NULL, NULL, '31.778078', '35.245192', 49, 'At the end of the chapter on the Mount of Olives, Bede refers to the last of the main commemorative buildings situated on the hill, that is the church of the Disciples – known from Egeria as the church of the Eleona (Greek for “olive grove”), commissioned by Constantine and built under the direction of the emperor’s mother Helena at the beginning of the 4th century. Bede explicitly links the building to the site where Jesus made the prophecy about the end, in the days before his crucifixion (the “Olivet Discourse”, cf. Mark 13; Matt. 24:3-14; Luke 21). The church was destroyed in 614 when the Persians took Jerusalem: the site remained associated to the Christ’s teaching, but no church was rebuilt there before the Crusader period. Thus, the church that Bede mentions, following Adomnan’s DLS, did not exist anymore at the time Arculf visited the Holy Land. It is unlikely that Adomnan did not know about its destruction, but he says nothing about it, maybe in order to maintain the sacredness of the site. In the chapter 1,25 of his DLS, Adomnan takes a step back from Arculf’s tour to comment on the Discourse episode related by the three Gospels. It is interesting to remark that here again, Bede severely abridged his source’s text: where Adomnan clarified the time, place, content and audience of the prophecy, Bede only noted that a church was built to commemorate the site of this episode of the Christ’s life.\r\nFinally, if the Constantinian church of the Eleona, built on the Mount of Olives facing the Temple Mount corresponds to the place described by the Gospels, the location given by Adomnan and copied by Bede is slightly problematic: they both refer to a church south of Bethany, while the Eleona is northwest of the town. As Adomnan describes the Mount of Olives from northwest to southeast and top to bottom, maybe locating the church to the south permitted him to have a coherent literary progression. Bede then simply copied what he found in his source, without noticing the mistake.'),
(120, 'Praesepe Domini', NULL, 'Grotto of the Nativity', 'landmark', 'certain', 0, NULL, NULL, 81212998, 10159, NULL, NULL, '31.704306', '35.207639', 121, NULL),
(121, 'Sanctae Mariae Ecclesia [Bethlehem]', NULL, 'Church of the Nativity', 'building', 'certain', 0, 8075635, NULL, 194504, 10159, 'https://dig.corps-cmhl.huji.ac.il/churches/bethlehem-nativity-constantinian-church', NULL, '31.704306', '35.207639', 5, NULL),
(122, 'Sepulchrum Dauid', NULL, 'David’s Tomb in Bethlehem ', 'tomb', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 123, NULL),
(123, 'Ecclesia [sepulchri Dauid]', NULL, 'Church containing David’s tomb', 'building', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5, NULL),
(124, 'Ecclesia [sepulchri Hieronymi]', NULL, 'St Jerome\'s monastery', 'building', 'uncertain', 0, NULL, NULL, 12408516, NULL, 'https://dig.corps-cmhl.huji.ac.il/churches/bethlehem-nativity-justinian-church', NULL, '31.704583', '35.207639', 5, 'Probably the modern Church of Saint Catherine or the adjacent Church of the Nativity. It seems that Bede, following Adomnan, considered the Church of the Nativity to be a different building, as both writers describe the churches separately.'),
(125, 'Sepulchrum Sancti Hieronimi', NULL, 'Saint Jerome’s Cave', 'tomb', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, '31.704583', '35.207639', 124, NULL),
(126, 'Turris Ader', 'Turris Gregis', 'Migdal Eder / Chapel of the Shepherd\'s Field', 'building', 'certain', 1, NULL, NULL, 24039683, NULL, 'https://dig.corps-cmhl.huji.ac.il/node/2533', NULL, '31.707306', '35.230111', 5, NULL),
(127, 'Ecclesia [sepulchri trium pastorum]', NULL, 'Church of the Tombs of the Three Wise Men', 'building', 'uncertain', 0, NULL, NULL, NULL, NULL, 'https://dig.corps-cmhl.huji.ac.il/node/2533', NULL, '31.707306', '35.230111', 126, NULL),
(128, 'Trium Pastorum Dominicae natiuitatis consciorum monumenta', NULL, 'Tombs of the Three Wise Men', 'tomb', 'uncertain', 0, NULL, NULL, NULL, NULL, 'https://dig.corps-cmhl.huji.ac.il/node/2533', NULL, '31.707306', '35.230111', 127, NULL),
(129, 'Via Regia', NULL, 'Way of the Patriarchs', 'road', 'certain', 0, NULL, NULL, 259222, NULL, NULL, NULL, NULL, NULL, NULL, '[confusion with the King\'s Highway?]'),
(130, 'Sepulchrum Rachel', NULL, 'Rachel’s Tomb', 'tomb', 'certain', 0, 282254, NULL, 2424300, NULL, NULL, NULL, '31.721900', '35.203055', 5, NULL),
(131, 'Spelunca duplicis', NULL, 'Double Cave with the Tombs of the Patriarchs', 'landmark', 'certain', 0, NULL, NULL, 204200, NULL, NULL, NULL, '31.524672', '35.110758', 8, NULL),
(132, 'Trium feminarum memoriae', NULL, 'Tombs of the Patriarchs\' Wives', 'tomb', 'certain', 0, NULL, NULL, 204200, NULL, NULL, NULL, '31.524672', '35.110758', 131, NULL),
(133, 'Quercus Abrahae', NULL, 'Oak of Mamre', 'landmark', 'certain', 0, NULL, NULL, 2143048, 20809, NULL, NULL, '31.556536', '35.105336', 134, 'One of the most important sacred places around the city of Hebron is the Oak of Mamre. Following biblical tradition, it is on the hill of Mamre, near an oak tree, that Abraham pitched his tent and was visited by the three angels (Gen.13:18, 18:21, 23:19). The holy place described by Bede is situated on the site of Ramat el-Khalil, and not on the site of Khirbet es-Sibte a few kilometres south-west of the former, where an old oak tree has been identified as Abraham’s Oak by a more recent tradition. At Ramat el-Khalil, archaeological findings include a rectangular sacred wall on the flat top of the hill, built under Herod, and a Christian complex within the wall that can be attributed to the emperor Constantine. This is without doubt the church built around the tree that Arculf saw and described to Adomnan. Bede has abridged Adomnan’s paragraph to a minimum, only keeping the fact that the trunk was the height of two men: we know, from Adomnan’s text, that in the 7th century, the tree was mostly cut off, and only the roots and parts of its trunk remained, protected by the roof of the church. '),
(134, 'Ecclesia [Mambre]', NULL, 'Constantinian Church of Mamre', 'building', 'certain', 0, NULL, NULL, 2143048, 20809, NULL, NULL, '31.556536', '35.105336', 45, '[See the notices Mamre and Oak of Mamre]'),
(135, 'Domus Raab', NULL, 'Rahab\'s House', 'building', 'uncertain', 0, NULL, NULL, NULL, 31780, NULL, NULL, NULL, NULL, 14, NULL),
(136, 'Ecclesia Galgalis', NULL, 'Gilgal', 'building', 'uncertain', 0, NULL, NULL, 2289734, 19592, 'https://dig.corps-cmhl.huji.ac.il/Monasteries/khirbet-en-nitle-galgala', 'Stern 1993/2:517-518', '31.850320', '35.488905', 57, NULL),
(137, 'Panium', NULL, 'Banias', 'spring', 'certain', 0, 8660355, NULL, 606295, NULL, NULL, NULL, '33.248611', '35.694444', NULL, 'Banias (Latin Panium, from the Greek Paneon / Panias) is the location of a spring gushing from a limestone cave, source of the Banias river, one of the main tributaries of the Jordan. However, it was believed, since the experiment led by Philip the Tetrarch, that the spring was fed by underground channels out of Lake Ram (Phiala). \r\nThe site around the spring had been associated with various deities throughout the centuries, and during the Hellenistic period, was dedicated to the god Pan, which gave his name to the cave, the spring (Panias), the city nearby (Paneas) and the region (Panion). A temple dedicated to Pan was built close to the cave, and Bede refers to a monument built or renovated by Agrippa II, who carried out many urban improvements during his reign over the region. Bede makes no reference to the fact that, at his time, the city was mostly depopulated, following the Muslim victories: his knowledge about the cave and the source is directly taken from Hegesippus\'s adaptation of The Jewish War of Flavius Josephus, thus referring solely to the situation in the 1st century.'),
(138, 'Monasterium [Iohannis]', NULL, 'Monastery of Saint John the Baptist ', 'building', 'certain', 0, 282398, NULL, 1574073, NULL, 'https://dig.corps-cmhl.huji.ac.il/Monasteries/qasr-el-yahud-st-john-baptist-st-john-baptist-prodromos', NULL, '31.838333', '35.539167', 76, 'The monastery with the church dedicated to Saint John the Baptist that Bede describes, following Adomnan’s account, can only be understood as the Byzantine church that used to be situated on the site of modern Qasr Al-Yahud. He clearly places it on the west bank of the river and on a small hill over the river. Qasr Al-Yahud may be understood as the Prodromos built by Anastasius I at the beginning of the 6th century [cf. <a target=\"_blank\" href=\"https://dig.corps-cmhl.huji.ac.il/Monasteries/qasr-el-yahud-st-john-baptist-st-john-baptist-prodromos\">Digital Corpus of Early Christian Churches and Monasteries in the Holy Land</a>]. \r\nHowever, this location might have been the result of a misunderstanding from Adomnan: archaeological findings show that a Byzantine religious complex, including a basilica (maybe the Prodromos) with stairs leading to the Jordan and a smaller church right by the river, existed on the eastern side of the river. This site could fit the description given by Arculf and copied by Bede, even though it is not on the same bank of the river. '),
(139, 'Beati Baptistae Iohannis ecclesia', NULL, 'Church of Saint John the Baptist ', 'building', 'certain', 0, 282398, NULL, 1574073, NULL, NULL, NULL, '31.838333', '35.539167', 138, '[See the notice Monastery of Saint John the Baptist]'),
(140, 'Ecclesia ubi Domini uestimenta cum baptizaretur seruata esse dicuntur', NULL, 'Church where the Lord\'s clothes were kept', 'building', 'uncertain', 0, 282398, NULL, 1574073, NULL, NULL, NULL, NULL, NULL, 76, 'Some remains on the west bank of the river can be dated back to the byzantine period, but it is unclear if one building could fit the description of the square church built on four piles above the river. However, [as mentioned in the notice Monastery of Saint John the Baptist] a small rectangular church has been found on the eastern bank, now 150 meters away from the course of the river which could also correspond to this church: the building was partially eroded by water, which may imply that it was situated right by a now dried branch of the Jordan. Even though Waheed’s [2013] interpretation of Arculf seems a bit far-fetched (no building is said to be situated on the eastern bank in Adomnan’s DLS), it is possible that Adomnan misplaced the buildings described by the bishop.'),
(141, 'Ecclesia [Sichem]', NULL, 'Church of Jacob\'s Well', 'building', 'certain', 0, 281302, NULL, 1679519, NULL, NULL, NULL, '32.209520', '35.285180', 22, 'Thanks to the pilgrims’ reports about Shechem and the Well of Jacob, it appears that by the time the Pilgrim of Bordeaux visited Samaria, this site had already been identified as the place where Jesus met with the Samaritan woman and the spring was probably being used for baptisms (the pilgrim uses the term <i>balneus</i>, which is usually understood, in his text, as “baptistery”). By the end of the 4th century, a cruciform church had been built over the well, which Jerome mentions in his letters (epist. 108,13). This edifice was destroyed or at least damaged by the Samaritan revolts of the 5th and 6th century, but was rebuilt, probably by Justinian. It is this second byzantine church that Arculf visited, and that Bede mentions in the DLS [see the notice Jacob’s Well; about the church and its plan, Abel, 1933; Vincent 1958].'),
(142, 'Locus ille in quo Dominus panes benedixit et pisces', NULL, 'Tabgha', 'landmark', 'certain', 1, 294593, NULL, 1026813, NULL, NULL, NULL, '32.873658', '35.548975', NULL, 'The first place that Bede describes in chapter 15 is the site where Jesus performed the miracle of the five loaves and the two fishes (Matt. 14:19; Mark 6:41; Luke 9:16; John 6:11). Even though he does not give a precise location, the general description of the place north of Tiberias and close to Capernaum corresponds to the site of Tabgha, commonly associated with the biblical episode, alongside the teaching of the Beatitudes and the confirmation of the primacy of Peter [See Finegan, 1992: 85-87]. This denomination is the Arabic contraction of the Greek name Heptapegon (“seven springs”). When Egeria visited the site in the 4th century, she reports that she could see steps on the shore and a church, containing the stone on which Jesus divided the bread to feed the five thousand, but no other signs of human settlement, corresponding with the description of a “solitary place” (Mark 6:32). The church, enlarged during the following century, was destroyed during the 7th century, probably during the Persian invasion of 614, which would explain Arculf’s description of the site, only bearing a few columns. Bede, wishing to insist on the isolation of this sacred place, untouched by human construction or cultivation, only recalls a grassy field and the spring to which the people drank [see the notice Tabgha Spring].'),
(143, 'Domus in qua Dominus nutritus est infans', NULL, 'Church of the Nutrition', 'building', 'uncertain', 1, NULL, NULL, 16566748, NULL, NULL, NULL, '32.702700', '35.296800', 19, 'When Bede comes to Nazareth, he mentions two churches: the Church of the Nutrition, built on the site of the house where Jesus was fed as a child, and the Church of the Annunciation, built on the site of the house of Mary, where Angel Gabriel announced that she would bear the Son of God [see the notice Church of the Annunciation]. He takes the time to describe the architecture of the Church of the Nutrition, situated in the middle of the city: it was constructed on two piles with arches, above a clear spring of water, situated in between the piles [see the notice Well in the church of Nutrition]. Bede, following Adomnan, uses Latin <i>cancer</i> (“lattice”) and <i>tumulus</i> (“mound” or “vault”) to designate these two piles: in the text, we understand these to form the structure supporting the building above, and not actual tombs. \r\nThe localisation of this byzantine church has long been disputed, and various propositions have been made, at the modern sites of the Church of St Gabriel (close to Mary’s Well), St Joseph’s Church and the Sisters of Nazareth convent. Recent excavations underneath this last edifice indicate that this is the most probable location: remains of a large artificial cave church, smaller rooms, and a water system including a cistern, underneath a surface-level church, have been found and studied [for a full description, see Dark, 2012]. It appears to be a vast and important religious structure, which could explain why Adomnan, following Arculf’s words, described it with precision.  '),
(144, 'Ecclesia ubi domus erat in qua Angelus ad Mariam uenit', NULL, 'Church of the Annunciation ', 'building', 'certain', 1, NULL, NULL, 130815, 52024, 'https://dig.corps-cmhl.huji.ac.il/Monasteries/nazareth-church-annunciation', NULL, '32.702140', '35.297690', 19, NULL),
(145, 'Monasterium [Thabor]', NULL, 'Monastery on Mount Tabor', 'building', 'uncertain', 0, NULL, NULL, NULL, 32198, NULL, NULL, '32.686200', '35.392900', 53, NULL),
(146, 'Tres ecclesiae [Thabor]', NULL, 'Three Churches on Mount Tabor', 'building', 'uncertain', 0, NULL, NULL, NULL, 32198, NULL, NULL, '32.686200', '35.392900', 53, NULL),
(147, 'Sancti Baptistae Iohannis ecclesia [Damascus]', NULL, 'Church of Saint John the Baptist in Damascus', 'building', 'certain', 0, 7642376, 245122016, 7698734, 16125, NULL, NULL, '33.511944', '36.306667', 11, 'The site of the church of Saint John the Baptist in Damascus had been holy at least since the Iron Age. While Damascus was the capital of the Kingdom of Aram-Damascus, a temple to Hadad, the storm god, was built by the Arameans. With the Hellenization of the city during the 2nd century BC, there was a progressive transition to a dedication to Zeus, the Greek equivalent to Hadad; and when the Romans conquered the city, they erected a monumental temple to Jupiter on the site, following a different plan than the original building. Under Theodosius, in 391, the temple was converted into a Christian cathedral. It is however impossible today to determine the shape of the Christian building or its exact location on the site. It is also unclear when the church was dedicated to Saint John the Baptist, as no information can be found before the 6th century, but the tradition held that the head of the saint was kept in the crypt as a holy relic. Adomnan stated that Arculf saw this church during his pilgrimage, which corresponds to the known chronology of the building. After the Muslim conquest of Damascus in 635, a treaty was concluded in order for the cathedral to be kept as a worship place for Christians. A prayer room for Muslims was added in the temenos of the church, which is probably the building built by the Saracen King (Mu\'awiya I, already named in the Chapter 5) mentioned by Adomnan and Bede. The church was destroyed in 706 by the caliph al-Walid I, to give place to the Umayyad Mosque. The head of John the Baptist is still kept in a golden shrine inside the Mosque.  '),
(148, 'Ecclesia [Saracenorum rex, Damascus]', NULL, 'Prayer room', 'building', 'certain', 0, 7642376, 245122016, 7698734, 16125, NULL, NULL, '33.511944', '36.306667', 147, '[See the notice Church of Saint John the Baptist in Damascus]'),
(149, 'Portus [Alexandria]', NULL, 'Harbour of Alexandria', 'landmark', 'certain', 0, 8555980, NULL, 1344739, NULL, NULL, NULL, '31.186080', '29.867370', 1, NULL),
(150, 'Farus', NULL, 'Pharos [Lighthouse of Alexandria]', 'building', 'certain', 0, NULL, 727197, 43244, NULL, NULL, NULL, '31.214039', '29.885368', 149, NULL),
(151, 'Ecclesia in qua Beatus Euangelista Marcus requiescit', NULL, 'Saint Mark cathedral', 'building', 'certain', 0, NULL, NULL, 1581553, NULL, NULL, NULL, '31.260000', '30.011400', 1, NULL),
(152, 'Memoria [Marci]', NULL, 'Tomb of Saint Mark', 'tomb', 'certain', 0, NULL, NULL, NULL, NULL, NULL, NULL, '31.260000', '30.011400', 151, NULL),
(154, 'Sepulchra Patriarcharum', NULL, 'Tomb of the Patriarchs ', 'tomb', 'certain', 0, 8073316, NULL, 204200, NULL, NULL, NULL, '31.524672', '35.110758', 75, NULL),
(156, 'Locus cenae Domini Venerabilis', NULL, 'Site of the Last Supper', 'landmark', 'certain', 1, NULL, NULL, 1245538, 48941, 'https://dig.corps-cmhl.huji.ac.il/node/12503', NULL, '31.772200', '35.228900', 102, NULL),
(157, 'Manasse', NULL, 'Manasseh', 'region', 'certain', 1, NULL, NULL, 12409827, NULL, NULL, NULL, '32.557450', '35.473588', 41, NULL),
(158, 'Vallis [Bethlehem]', NULL, 'Valley north of Bethlehem', 'valley', 'uncertain', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5, NULL),
(159, 'Lacus Semechonitis', NULL, 'Lake Hula (Waters of Merom)', 'sea', 'certain', 1, 9193427, NULL, 65091150, NULL, NULL, NULL, '33.102890', '35.609360', NULL, 'When describing the course of the Jordan, Bede remarks that the river passes through a lake, which he does not name, further down Panium, 15 miles (22 km) north of the Sea of Galilee. Considering that Bede copies here almost word for word Hegesippus, there is no doubt that he is referring to the lake commonly associated with the Waters of Merom, where Joshua won the battle against Jabin and his confederates (cf. Joshua 11:5). Indeed, Hegesippus gives a denomination in his text (<i>lacus Semechonitis</i>), although none of the witnesses bear a clear spelling of the name. This confusion in the manuscripts might explain the reason why Bede did not keep the name in its own chapter. Furthermore, the mention of the swamp quality of the lake is coherent with the reality of Lake Hula, which used to be surrounded by marshland.'),
(160, 'Fons [Nazareth]', NULL, 'Well in the Church of the Nutrition', 'spring', 'certain', 0, NULL, NULL, NULL, NULL, NULL, NULL, '32.702700', '35.296800', 143, 'Underneath the church built to commemorate the place where Jesus was nursed as an infant, Bede mentions a clear <i>fons</i> accessible to the local population: it is not described as a holy spring, but merely as a practical source of water for the inhabitants of the town. A well was probably built to facilitate the collection of water, as Bede explains that they used pulleys and small vessels to get water from the church level [For more information about the location of the spring, see the notice Church of Nutrition].');

--
-- Index pour les tables déchargées
--

--
-- Index pour la table `ToponymsList`
--
ALTER TABLE `ToponymsList`
  ADD PRIMARY KEY (`id_toponym`);

--
-- AUTO_INCREMENT pour les tables déchargées
--

--
-- AUTO_INCREMENT pour la table `ToponymsList`
--
ALTER TABLE `ToponymsList`
  MODIFY `id_toponym` int(11) NOT NULL AUTO_INCREMENT COMMENT 'unique ID for each toponym in the text', AUTO_INCREMENT=161;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
