-- phpMyAdmin SQL Dump
-- version 4.9.5
-- https://www.phpmyadmin.net/
--
-- Hôte : db.dmz.dhvlab.fo
-- Généré le : lun. 20 déc. 2021 à 16:14
-- Version du serveur :  5.5.65-MariaDB
-- Version de PHP : 7.3.18

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `labuser_jdesiderio`
--

-- --------------------------------------------------------

--
-- Structure de la table `SourceReferences`
--

CREATE TABLE `SourceReferences` (
  `id_reference` int(3) NOT NULL DEFAULT '0' COMMENT 'unique ID of each reference to a source text',
  `id_text` int(2) DEFAULT NULL COMMENT 'ID of the cited text (from SourceTexts)',
  `reference` varchar(21) DEFAULT NULL COMMENT 'reference of the chapter / paragraph / verse of the passage',
  `printed_ref` varchar(25) DEFAULT NULL COMMENT 'page and line numbers of the printed edition of reference',
  `id_edited_text` int(2) DEFAULT NULL COMMENT 'ID of the edited text (from SourceTexts): 11 = beda DLS',
  `sentence` int(3) DEFAULT NULL COMMENT 'text sentence number',
  `link` varchar(87) DEFAULT NULL COMMENT 'link to online editions of the texts (which are not CSEL or PL)',
  `link_csel` varchar(107) DEFAULT NULL COMMENT 'links to the online editions of the CSEL',
  `link_pl` varchar(72) DEFAULT NULL COMMENT ' links to the online editions of the Patrologia Latina (digitized version) '
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='list of ancient sources with their references used by Bede in the DLS text. Linked to AlignmentBeda via ''sentence''.';

--
-- Déchargement des données de la table `SourceReferences`
--

INSERT INTO `SourceReferences` (`id_reference`, `id_text`, `reference`, `printed_ref`, `id_edited_text`, `sentence`, `link`, `link_csel`, `link_pl`) VALUES
(1, 3, '3', 'p. 237,11-15 (CCSL)', 11, 29, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:3?q=situs&qk=form', NULL),
(2, 3, '2', 'p. 237,7-8 (CCSL)', 11, 31, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:3?q=hierusalem&qk=form', NULL),
(3, 1, '1,1', 'p. 185,7-13 (CCSL)', 11, 33, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.1?q=magno&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n406/mode/2up'),
(4, 3, '5', 'p. 237,22-23 (CCSL)', 11, 34, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:5?q=&qk=form', NULL),
(5, 1, '1,1', 'p. 185,16-19 (CCSL)', 11, 34, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.1?q=quamlibet&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n406/mode/2up'),
(6, 1, '1,1', 'p. 185,19-24 (CCSL)', 11, 35, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.1?q=pars&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n406/mode/2up'),
(7, 1, '1,1', 'p. 186,42-52 (CCSL)', 11, 36, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.1?q=Hierosolymitanus&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n406/mode/2up'),
(8, 3, '6', 'p. 237,24-26 (CCSL)', 11, 38, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:6?q=&qk=form', NULL),
(9, 1, '1,6', 'p. 190,7-9 (CCSL)', 11, 38, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.6?q=basilica&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(10, 3, '6', 'p. 237,26-27 (CCSL)', 11, 39, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:6?q=constantino&qk=form', NULL),
(11, 1, '1,6', 'p. 190,5-7 (CCSL)', 11, 39, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.6?q=basilica&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(12, 3, '6', 'p. 237,27-238,32 (CCSL)', 11, 40, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:6?q=dehinc&qk=form', NULL),
(13, 1, '1,5', 'p. 190,5-14 (CCSL)', 11, 40, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.5?q=superioribus&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(14, 1, '1,4', 'p. 190,5-6 (CCSL)', 11, 42, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.4?q=rotundae&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(15, 3, '6', 'p. 238,27-28 (CCSL)', 11, 42, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:6/?q=sed&qk=form', NULL),
(16, 1, '1,2', 'p. 187,15-188,65 (CCSL)', 11, 42, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.2?q=utique&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n406/mode/2up'),
(17, 5, 'Matt. 27:60', '', 11, 44, 'https://www.academic-bible.com/bible-text/matthew27/vulg/', NULL, NULL),
(18, 1, '1,3', 'p. 189,4-14 (CCSL)', 11, 48, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.3?q=pars&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(19, 1, '1,3', 'p. 189,23-24 (CCSL)', 11, 49, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.3?q=color&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(20, 1, '1,4', 'p. 190,6-7 (CCSL)', 11, 50, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.4?q=dextera&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(21, 1, '1,6', 'p. 191,18-21 (CCSL)', 11, 51, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.6?q=inter&qk=form', NULL),
(22, 5, 'Matt. 26:27', '', 11, 51, 'https://www.academic-bible.com/bible-text/matthew26/vulg/', NULL, NULL),
(23, 5, 'Matt. 27:48', '', 11, 51, 'https://www.academic-bible.com/bible-text/matthew27/vulg/', NULL, NULL),
(24, 1, '1,7', 'p. 191,5-17 (CCSL)', 11, 51, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.7?q=golgothanam&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(25, 1, '1,6', 'p. 191,12-17 (CCSL)', 11, 52, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.6?q=inter&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(26, 5, 'John 19:34', '', 11, 55, 'https://www.academic-bible.com/bible-text/john19/vulg/', NULL, NULL),
(27, 1, '1,8', 'p. 191,2-192,8 (CCSL)', 11, 55, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.8?q=Arculfus&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(28, 3, '6-7', 'p. 238,32-35 (CCSL)', 11, 56, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:6?q=atque&qk=form', NULL),
(29, 1, '1,1', 'p. 186,60-65 (CCSL)', 11, 57, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.1?q=ceterum&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n406/mode/2up'),
(30, 3, '7', 'p. 238,37-38 (CCSL)', 11, 58, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:7?q=paucae&qk=form', NULL),
(31, 3, '8-9', 'p. 238,40-46 (CCSL)', 11, 59, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:8-9?q=&qk=form', NULL),
(32, 3, '4', 'p. 237,16-21 (CCSL)', 11, 61, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:4?q=paucae&qk=form', NULL),
(33, 5, 'Matt. 26:20-29', '', 11, 61, 'https://www.academic-bible.com/bible-text/matthew26/vulg/', NULL, NULL),
(34, 5, 'Matt. 27:26', '', 11, 62, 'https://www.academic-bible.com/bible-text/matthew27/vulg/', NULL, NULL),
(35, 1, '1,18', 'p. 197,9-10 (CCSL)', 11, 62, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.18?q=memorabilis&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(36, 5, 'Acts 7:54-60', '', 11, 65, 'https://www.academic-bible.com/bible-text/acts7/vulg/', NULL, NULL),
(37, 1, '1,18', 'p. 197,6-7 (CCSL)', 11, 65, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.18?q=petra&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(38, 1, '1,11', 'p. 194,2-195,19 (CCSL)', 11, 66, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.11?q=haec&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(39, 5, 'Ps. 74,12 (73:12)', '', 11, 67, 'https://www.academic-bible.com/bible-text/psalms73/vulg/', NULL, NULL),
(40, 6, '1-2', 'p. 305 (CSEL)', 11, 68, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0104p.stoa003.opp-lat2:5.1-5.2', NULL),
(41, 1, '1,16', 'p. 197 (CCSL)', 11, 70, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.16?q=porta&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(42, 1, '1,17', 'p. 197 (CCSL)', 11, 71, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.17?q=medietatem&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(43, 7, 'euang. 4,631', 'p. 138 (CSEL)', 11, 71, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0169a.stoa002.opp-lat2:4.631?q=&qk=form', NULL),
(44, 1, '1,19', 'p. 198,3-8 (CCSL)', 11, 72, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.19?q=hunc&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(45, 5, 'Acts 1:19', '', 11, 72, 'https://www.academic-bible.com/bible-text/acts1/vulg/', NULL, NULL),
(46, 5, 'Matt. 27:8', '', 11, 72, 'https://www.academic-bible.com/bible-text/matthew27/vulg/', NULL, NULL),
(47, 1, '1,9', 'p. 192,11-194,81 (CCSL)', 11, 74, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.9?q=sacrosancto&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(48, 1, '1,1', 'p. 194,1-9 (CCSL)', 11, 82, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.10?q=aliud&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n408/mode/2up'),
(49, 3, '10', 'p. 238,50-51 (CCSL)', 11, 84, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:10?q=&qk=form', NULL),
(50, 1, '1,2', 'p. 198,5-13', 11, 85, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.20?q=helia&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(51, 2, 'epist. 129,4', 'p. 169 (CSEL)', 11, 88, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0162.stoa004.opp-lat3:129.4.1?q=dan&qk=form', NULL),
(52, 3, '16', 'p. 239,88-240,90 (CCSL)', 11, 88, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:17?q=utique&qk=form', NULL),
(53, 3, '18', 'p. 240,98-99 (CCSL)', 11, 88, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:17?q=ioppe&qk=form', NULL),
(54, 3, '9', 'p. 238,46-49 (CCSL)', 11, 89, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:9?q=murum&qk=form', NULL),
(55, 5, 'Luke 2:25', '', 11, 91, 'https://www.academic-bible.com/bible-text/Luke2/vulg/', NULL, NULL),
(56, 5, 'Matt. 2:24', '', 11, 91, 'https://www.academic-bible.com/bible-text/matthew2/vulg/', NULL, NULL),
(57, 1, '1,13-14', 'p. 196 (CCSL)', 11, 91, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.13?q=supra&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(58, 5, 'Luke 22:41', '', 11, 92, 'https://www.academic-bible.com/bible-text/Luke22/vulg/', NULL, NULL),
(59, 1, '1,12', 'p. 195,4-196,22 (CCSL)', 11, 92, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.12?q=sanctorum&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(60, 3, '10', 'p. 238,51-52 (CCSL)', 11, 95, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:10?q=quae&qk=form', ''),
(61, 1, '1,22', 'p. 199 (CCSL)', 11, 95, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.21?q=&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n410/mode/2up'),
(62, 1, '1,21', 'p. 198-199 (CCSL)', 11, 95, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.21?q=&qk=form', NULL),
(63, 1, '1,23', 'p. 199,5-6 (CCSL)', 11, 96, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.23?q=toto&qk=form', NULL),
(64, 5, 'Acts 1:9-12', '', 11, 97, 'https://www.academic-bible.com/bible-text/acts1/vulg/', NULL, NULL),
(65, 1, '1,23', 'p. 199,6-14 (CCSL)', 11, 97, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.23?q=interior&qk=form', NULL),
(66, 1, '1,23', 'p. 200,26-31;42-44 (CCSL)', 11, 98, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.23?q=uestigia&qk=form', NULL),
(67, 8, '118 serm. 8,17', 'p. 160,14-15 (CSEL)', 11, 99, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0022.stoa052.opp-lat1:8.18.2?q=lumine&qk=form', NULL),
(68, 1, '1,23', 'p. 200,45-201,66 (CCSL)', 11, 99, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.23?q=igitur&qk=form', NULL),
(69, 5, 'Acts 2:2', '', 11, 100, 'https://www.academic-bible.com/bible-text/acts2/vulg/', NULL, NULL),
(70, 1, '1,23', 'p. 201,67-76 (CCSL)', 11, 100, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.23?q=quaternales&qk=form', NULL),
(71, 1, '1,23', 'p. 201,93-99 (CCSL)', 11, 102, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.23?q=ardere&qk=form', NULL),
(72, 1, '1,24', 'p. 202 (CCSL)', 11, 105, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.25?q=arculfus&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n412/mode/2up'),
(73, 5, 'Matt. 24:3-14', '', 11, 107, 'https://www.academic-bible.com/bible-text/matthew24/vulg/', NULL, NULL),
(74, 1, '1,25', 'p. 202,3-6 (CCSL)', 11, 107, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:1.27?q=celebriore&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n412/mode/2up'),
(75, 3, '11', 'p. 238,56 (CCSL)', 11, 109, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:11?q=&qk=form', NULL),
(76, 1, '2,1', 'p. 206,3-15 (CCSL)', 11, 109, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.1?q=utique&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(77, 1, '2,2', 'p. 206,2-12 (CCSL)', 11, 109, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.2?q=in&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(78, 1, '2,3', 'p. 207,4-13 (CCSL)', 11, 111, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.3?q=petra&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(79, 5, '1 Kgs. 2:10', '', 11, 112, 'https://www.academic-bible.com/bible-text/1kings2/vulg/', NULL, NULL),
(80, 5, 'Acts 2:29', '', 11, 112, 'https://www.academic-bible.com/bible-text/acts2/vulg/', NULL, NULL),
(81, 1, '2,4', 'p. 207,3-11 (CCSL)', 11, 112, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.4?q=quod&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(82, 1, '2,5', 'p. 208,3-8 (CCSL)', 11, 112, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.5?q=Sepulchrum&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(83, 5, 'Gen. 35:21', '', 11, 113, 'https://www.academic-bible.com/bible-text/genesis35/vulg/', NULL, NULL),
(84, 13, '23,29 (p. 52)', 'p. 88,29 (CCSL)', 11, 113, 'https://books.google.de/books?id=0q9DAAAAYAAJ&hl=fr&pg=PA52#v=onepage&q=ader&f=false', NULL, NULL),
(85, 10, '35,21 (p.55,21-24)', 'p. 43,21-24 (CCSL)', 11, 113, 'https://archive.org/details/hieronymiquaest00lagagoog/page/n66/mode/2up', NULL, NULL),
(86, 5, 'Luke 2:8-20', '', 11, 113, 'https://www.academic-bible.com/bible-text/Luke2/vulg/', NULL, NULL),
(87, 1, '2,6', 'p. 208 (CCSL)', 11, 113, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.6?q=trium&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(88, 5, 'Neh. 3,16', '', 11, 114, 'https://www.academic-bible.com/bible-text/nehemiah3/vulg/', NULL, NULL),
(89, 5, 'Gen. 35:20', '', 11, 115, 'https://www.academic-bible.com/bible-text/genesis35/vulg/', NULL, NULL),
(90, 1, '2,7', 'p. 208,5-209,12 (CCSL)', 11, 115, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.7?q=quaedam&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(91, 1, '2,12', 'p. 211,4 (CCSL)', 11, 117, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.12?q=egredientibus&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(92, 1, '2,1', 'p. 210,35-36 (CCSL)', 11, 117, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.10?q=illorum&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(93, 5, 'Gen. 23:9', '', 11, 117, 'https://www.academic-bible.com/bible-text/genesis23/vulg/', NULL, NULL),
(94, 9, '84,16-17 (p. 120)', 'p. 120,16-17', 11, 117, 'https://books.google.de/books?id=0q9DAAAAYAAJ&hl=fr&pg=PA120#v=onepage&q=distat&f=false', NULL, NULL),
(95, 1, '2,9-10', 'p. 209,4-210,32 (CCSL)', 11, 117, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.10?q=sepulchra&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(96, 5, 'Josh. 14:15', '', 11, 117, 'https://www.academic-bible.com/bible-text/joshua14/vulg/', NULL, NULL),
(97, 1, '2,11', 'p. 210,2-211,20 (CCSL)', 11, 119, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.11?q=mambre&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(98, 5, 'Gen. 13:18', '', 11, 119, 'https://www.academic-bible.com/bible-text/genesis13/vulg/', NULL, NULL),
(99, 1, '2,12', 'p. 211,4-9 (CCSL)', 11, 120, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.12?q=egredientibus&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n414/mode/2up'),
(100, 3, '12', 'p. 239,60-61 (CCSL)', 11, 122, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0117p.stoa001.opp-lat1:12?q=hiericho&qk=form', NULL),
(101, 5, 'Josh. 2,1-6', '', 11, 122, 'https://www.academic-bible.com/bible-text/joshua2/vulg/', NULL, NULL),
(102, 1, '2,13', 'p. 212,1-8 (CCSL)', 11, 122, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.13?q=mirum&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(103, 1, '2,13', 'p. 212,7-20 (CCSL)', 11, 123, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.13?q=inter&qk=form', NULL),
(104, 5, 'Josh. 4:19-25', '', 11, 124, 'https://www.academic-bible.com/bible-text/joshua4/vulg/', NULL, NULL),
(105, 1, '2,14-15', 'p. 212,8-213', 11, 124, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.15?q=in&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(106, 5, '2 Kgs. 2:19-22', '', 11, 125, 'https://www.academic-bible.com/bible-text/2kings2/vulg/', NULL, NULL),
(107, 4, '4,17', 'p. 267,15-268,1 (CSEL)', 11, 125, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=260,261&q=hiericho', NULL, NULL),
(108, 4, '4,17', 'p. 268,23-269,9 (CSEL)', 11, 126, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=260,261&q=denique', NULL, NULL),
(109, 4, '1,15', 'p. 24,15-17 (CSEL)', 11, 127, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=32,33&q=balsamum', NULL, NULL),
(110, 4, '4,17', 'p. 269,9-10 (CSEL)', 11, 128, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=260,261&q=caverna', NULL, NULL),
(111, 4, '4,17', 'p. 269,12-14 (CSEL)', 11, 129, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=260,261&q=aestate', NULL, NULL),
(112, 4, '4,16', 'p. 266,12-13 (CSEL)', 11, 130, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=258,259&q=urbs+condita', NULL, NULL),
(113, 4, '4,16', 'p. 266,17-18 (CSEL)', 11, 130, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=258,259&q=aegrum', NULL, NULL),
(114, 4, '4,16', 'p. 266,14-16 (CSEL)', 11, 131, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=258,259&q=scythopolis', NULL, NULL),
(115, 4, '4,16', 'p. 266,19-267,4 (CSEL)', 11, 132, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=258,259&q=adversus', NULL, NULL),
(116, 9, '88,10-19 (p. 123-124)', 'p. 123,10-124,19', 11, 133, 'https://books.google.de/books?id=0q9DAAAAYAAJ&hl=fr&pg=PA123#v=onepage&q=Aulon&f=false', NULL, NULL),
(117, 4, '4,16', 'p. 267,12-14 (CSEL)', 11, 134, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=258,259&q=siquidem', NULL, NULL),
(118, 4, '4,16', 'p. 267,10-11 (CSEL)', 11, 134, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=258,259&q=arida', NULL, NULL),
(119, 1, '2,19', 'p. 215,1-6 (CCSL)', 11, 136, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.19?q=locum&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(120, 4, '3,26', 'p. 234,20-23 (CSEL)', 11, 137, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=228,229&q=agrippae', NULL, NULL),
(121, 1, '2,19', 'p. ?,9-13 (CCSL)', 11, 138, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.19?q=ergo&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(122, 4, '3,26', 'p. 234,11-15 (CSEL)', 11, 138, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=228,229&q=phiala', NULL, NULL),
(123, 4, '3,26', 'p. 234,4-10 (CSEL)', 11, 139, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=226,227&q=superioris', NULL, NULL),
(124, 4, '3,26', 'p. 235,1-5 (CSEL)', 11, 140, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=228,229&q=lacum', NULL, NULL),
(125, 1, '2,17', 'p. 214,3-6 (CCSL)', 11, 143, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.17?q=iordanici&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(126, 1, '2,20', 'p. 215,4-7 (CCSL)', 11, 144, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.20?q=ipsius&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(127, 4, '3,26', 'p. 233,10-11 (CSEL)', 11, 144, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=226,227&q=sinus', NULL, NULL),
(128, 4, '3,26', 'p. 233,13-16 (CSEL)', 11, 145, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=226,227&q=dulcis', NULL, NULL),
(129, 1, '2,20', 'p. 215,7-9 (CCSL)', 11, 145, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.20?q=aquae&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(130, 4, '3,26', 'p. 233,23-234,1 (CSEL)', 11, 146, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=226,227&q=genera', NULL, NULL),
(131, 4, '4,18', 'p. 271,8-10 (CSEL)', 11, 148, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=zoaros', NULL, NULL),
(132, 5, 'Gen. 19:24-26', '', 11, 148, 'https://www.academic-bible.com/bible-text/genesis19/vulg/', NULL, NULL),
(133, 1, '2,20', 'p. 216,18-19 (CCSL)', 11, 149, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.20?q=scilicet&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(134, 1, '2,17', 'p. 214,6-13 (CCSL)', 11, 150, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.17?q=aliter&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(135, 5, 'Matt. 5:13', '', 11, 150, 'https://www.academic-bible.com/bible-text/matthew5/vulg/', NULL, NULL),
(136, 4, '4,18', 'p. 270,8-10 (CSEL)', 11, 151, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=amara', NULL, NULL),
(138, 4, '4,18', 'p. 270,10-13 (CSEL)', 11, 153, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=lucernam', NULL, NULL),
(139, 4, '4,18', 'p. 270,6-8 (CSEL)', 11, 153, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=mergenda', NULL, NULL),
(140, 4, '4,18', 'p. 270,13-15 (CSEL)', 11, 154, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=vespasianum', NULL, NULL),
(141, 4, '4,18', 'p. 270,8 (CSEL)', 11, 155, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=amara', NULL, NULL),
(142, 4, '4,18', 'p. 270,21-22 (CSEL)', 11, 155, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=aqua', NULL, NULL),
(143, 4, '4,18', 'p. 270,24-271,8 (CSEL)', 11, 156, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=vagari', NULL, NULL),
(144, 4, '4,18', 'p. 272,2-5 (CSEL)', 11, 158, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=262,263&q=manent', NULL, NULL),
(145, 4, '4,16', 'p. 267,7-10 (CSEL)', 11, 159, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=258,259&q=aestatis', NULL, NULL),
(146, 1, '2,16', 'p. 213,3-214,31 (CCSL)', 11, 161, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.16?q=&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(147, 1, '2,20', 'p. 216,16-18 (CCSL)', 11, 165, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.20?q=loco&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(148, 5, 'Matt. 3:4', '', 11, 167, 'https://www.academic-bible.com/bible-text/matthew3/vulg/', NULL, NULL),
(149, 5, 'Mark 1:6', '', 11, 167, 'https://www.academic-bible.com/bible-text/mark1/vulg/', NULL, NULL),
(150, 1, '2,23', 'p. 217,10-19 (CCSL)', 11, 167, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.23?q=&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n418/mode/2up'),
(151, 1, '2,22', 'p. 217,3-6 (CCSL)', 11, 170, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.22?q=&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n418/mode/2up'),
(152, 1, '2,21', 'p. 216,5-21 (CCSL)', 11, 172, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.21?q=arculfus&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n416/mode/2up'),
(153, 5, 'John 4:5', '', 11, 172, 'https://www.academic-bible.com/bible-text/john4/vulg/', NULL, NULL),
(154, 5, 'Matt. 14:19', '', 11, 175, 'https://www.academic-bible.com/bible-text/matthew14/vulg/', NULL, NULL),
(155, 5, 'Mark 6:41', '', 11, 175, 'https://www.academic-bible.com/bible-text/mark6/vulg/', NULL, NULL),
(156, 5, 'Luke 9:16', '', 11, 175, 'https://www.academic-bible.com/bible-text/Luke9/vulg/', NULL, NULL),
(157, 5, 'John 6:11', '', 11, 175, 'https://www.academic-bible.com/bible-text/john6/vulg/', NULL, NULL),
(158, 1, '2,24', 'p. 218,3-11 (CCSL)', 11, 175, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.24?q=ad&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n418/mode/2up'),
(159, 1, '2,25', 'p. 218,2-12 (CCSL)', 11, 176, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.25?q=ad&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n418/mode/2up'),
(160, 5, 'Luke 1:26-28', '', 11, 177, 'https://www.academic-bible.com/bible-text/Luke1/vulg/', NULL, NULL),
(161, 1, '2,26', 'p. 218,2-219,16 (CCSL)', 11, 177, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.26?q=&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n418/mode/2up'),
(162, 1, '2,27', 'p. 219,2-220,10 (CCSL)', 11, 181, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.27?q=&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n418/mode/2up'),
(163, 5, 'Mark 9:5', '', 11, 182, 'https://www.academic-bible.com/bible-text/mark9/vulg/', NULL, NULL),
(164, 5, 'Luke 9:33', '', 11, 182, 'https://www.academic-bible.com/bible-text/Luke9/vulg/', NULL, NULL),
(165, 1, '2,27', 'p. 220,12-18 (CCSL)', 11, 183, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.27?q=parui&qk=form', NULL),
(166, 1, '2,28', 'p. 220,2-9 (CCSL)', 11, 185, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.28?q=&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n418/mode/2up'),
(167, 1, '2,3', 'p. 224,82 (CCSL)', 11, 190, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.30?q=longo&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n420/mode/2up'),
(168, 1, '2,3', 'p. 222,12-14 (CCSL)', 11, 190, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.30?q=australi&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n418/mode/2up'),
(169, 1, '2,3', 'p. 222,18-23 (CCSL)', 11, 190, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.30?q=portus&qk=form', NULL),
(170, 4, '4,27', 'p. 284,21-285,5 (CSEL)', 11, 192, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=274,275&q=portus', NULL, NULL),
(171, 1, '2,3', 'p. 222,23-30 (CCSL)', 11, 192, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.30?q=insula&qk=form', NULL),
(172, 4, '4,27', 'p. 285,19-22 (CSEL)', 11, 192, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=276,277&q=inlidentibus', NULL, NULL),
(173, 4, '4,27', 'p. 285,23-24 (CSEL)', 11, 193, 'https://www.digitale-sammlungen.de/en/view/bsb10217875?page=276,277&q=stadiorum', NULL, NULL),
(174, 1, '2,3', 'p. 224,89-94 (CCSL)', 11, 194, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.30?q=item&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n420/mode/2up'),
(175, 1, '2,3', 'p. 225,100-108 (CCSL)', 11, 195, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:2.30?q=ob&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n420/mode/2up'),
(176, 1, '3,1', 'p. 226,7-13 (CCSL)', 11, 197, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:3.1?q=procul&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n420/mode/2up'),
(177, 1, '3,2', 'p. 227,2-10;26 (CCSL)', 11, 198, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:3.2?q=imperator&qk=form', NULL),
(178, 1, '3,3', 'p. 228,3-229,53 (CCSL)', 11, 200, NULL, 'https://scaife.perseus.org/reader/urn:cts:latinLit:stoa0007.stoa002.opp-lat1:3.3?q=procul&qk=form', 'https://archive.org/details/patrologiaecurs26unkngoog/page/n420/mode/2up');

--
-- Index pour les tables déchargées
--

--
-- Index pour la table `SourceReferences`
--
ALTER TABLE `SourceReferences`
  ADD PRIMARY KEY (`id_reference`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
